/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V1IngressBackend;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"backend", "pathType", "path"})
public class V1HTTPIngressPath {
    public static final String JSON_PROPERTY_BACKEND = "backend";
    public static final String JSON_PROPERTY_PATH_TYPE = "pathType";
    public static final String JSON_PROPERTY_PATH = "path";
    @NotNull
    @Valid
    @JsonProperty(value="backend")
    private V1IngressBackend backend;
    @NotNull
    @JsonProperty(value="pathType")
    private String pathType;
    @Nullable
    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String path;

    public V1HTTPIngressPath(V1IngressBackend backend, String pathType) {
        this.backend = backend;
        this.pathType = pathType;
    }

    public V1IngressBackend getBackend() {
        return this.backend;
    }

    public void setBackend(V1IngressBackend backend) {
        this.backend = backend;
    }

    public V1HTTPIngressPath backend(V1IngressBackend backend) {
        this.backend = backend;
        return this;
    }

    public String getPathType() {
        return this.pathType;
    }

    public void setPathType(String pathType) {
        this.pathType = pathType;
    }

    public V1HTTPIngressPath pathType(String pathType) {
        this.pathType = pathType;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public V1HTTPIngressPath path(String path) {
        this.path = path;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1HTTPIngressPath v1HTTPIngressPath = (V1HTTPIngressPath)o;
        return Objects.equals(this.backend, v1HTTPIngressPath.backend) && Objects.equals(this.pathType, v1HTTPIngressPath.pathType) && Objects.equals(this.path, v1HTTPIngressPath.path);
    }

    public int hashCode() {
        return Objects.hash(this.backend, this.pathType, this.path);
    }

    public String toString() {
        return "V1HTTPIngressPath(backend: " + String.valueOf(this.getBackend()) + ", pathType: " + this.getPathType() + ", path: " + this.getPath() + ")";
    }
}

