/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V1CrossVersionObjectReference;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"maxReplicas", "scaleTargetRef", "minReplicas", "targetCPUUtilizationPercentage"})
public class V1HorizontalPodAutoscalerSpec {
    public static final String JSON_PROPERTY_MAX_REPLICAS = "maxReplicas";
    public static final String JSON_PROPERTY_SCALE_TARGET_REF = "scaleTargetRef";
    public static final String JSON_PROPERTY_MIN_REPLICAS = "minReplicas";
    public static final String JSON_PROPERTY_TARGET_C_P_U_UTILIZATION_PERCENTAGE = "targetCPUUtilizationPercentage";
    @NotNull
    @JsonProperty(value="maxReplicas")
    private Integer maxReplicas;
    @NotNull
    @Valid
    @JsonProperty(value="scaleTargetRef")
    private V1CrossVersionObjectReference scaleTargetRef;
    @Nullable
    @JsonProperty(value="minReplicas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Integer minReplicas;
    @Nullable
    @JsonProperty(value="targetCPUUtilizationPercentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Integer targetCPUUtilizationPercentage;

    public V1HorizontalPodAutoscalerSpec(Integer maxReplicas, V1CrossVersionObjectReference scaleTargetRef) {
        this.maxReplicas = maxReplicas;
        this.scaleTargetRef = scaleTargetRef;
    }

    public Integer getMaxReplicas() {
        return this.maxReplicas;
    }

    public void setMaxReplicas(Integer maxReplicas) {
        this.maxReplicas = maxReplicas;
    }

    public V1HorizontalPodAutoscalerSpec maxReplicas(Integer maxReplicas) {
        this.maxReplicas = maxReplicas;
        return this;
    }

    public V1CrossVersionObjectReference getScaleTargetRef() {
        return this.scaleTargetRef;
    }

    public void setScaleTargetRef(V1CrossVersionObjectReference scaleTargetRef) {
        this.scaleTargetRef = scaleTargetRef;
    }

    public V1HorizontalPodAutoscalerSpec scaleTargetRef(V1CrossVersionObjectReference scaleTargetRef) {
        this.scaleTargetRef = scaleTargetRef;
        return this;
    }

    public Integer getMinReplicas() {
        return this.minReplicas;
    }

    public void setMinReplicas(Integer minReplicas) {
        this.minReplicas = minReplicas;
    }

    public V1HorizontalPodAutoscalerSpec minReplicas(Integer minReplicas) {
        this.minReplicas = minReplicas;
        return this;
    }

    public Integer getTargetCPUUtilizationPercentage() {
        return this.targetCPUUtilizationPercentage;
    }

    public void setTargetCPUUtilizationPercentage(Integer targetCPUUtilizationPercentage) {
        this.targetCPUUtilizationPercentage = targetCPUUtilizationPercentage;
    }

    public V1HorizontalPodAutoscalerSpec targetCPUUtilizationPercentage(Integer targetCPUUtilizationPercentage) {
        this.targetCPUUtilizationPercentage = targetCPUUtilizationPercentage;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1HorizontalPodAutoscalerSpec v1HorizontalPodAutoscalerSpec = (V1HorizontalPodAutoscalerSpec)o;
        return Objects.equals(this.maxReplicas, v1HorizontalPodAutoscalerSpec.maxReplicas) && Objects.equals(this.scaleTargetRef, v1HorizontalPodAutoscalerSpec.scaleTargetRef) && Objects.equals(this.minReplicas, v1HorizontalPodAutoscalerSpec.minReplicas) && Objects.equals(this.targetCPUUtilizationPercentage, v1HorizontalPodAutoscalerSpec.targetCPUUtilizationPercentage);
    }

    public int hashCode() {
        return Objects.hash(this.maxReplicas, this.scaleTargetRef, this.minReplicas, this.targetCPUUtilizationPercentage);
    }

    public String toString() {
        return "V1HorizontalPodAutoscalerSpec(maxReplicas: " + this.getMaxReplicas() + ", scaleTargetRef: " + String.valueOf(this.getScaleTargetRef()) + ", minReplicas: " + this.getMinReplicas() + ", targetCPUUtilizationPercentage: " + this.getTargetCPUUtilizationPercentage() + ")";
    }
}

