/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"currentReplicas", "desiredReplicas", "currentCPUUtilizationPercentage", "lastScaleTime", "observedGeneration"})
public class V1HorizontalPodAutoscalerStatus {
    public static final String JSON_PROPERTY_CURRENT_REPLICAS = "currentReplicas";
    public static final String JSON_PROPERTY_DESIRED_REPLICAS = "desiredReplicas";
    public static final String JSON_PROPERTY_CURRENT_C_P_U_UTILIZATION_PERCENTAGE = "currentCPUUtilizationPercentage";
    public static final String JSON_PROPERTY_LAST_SCALE_TIME = "lastScaleTime";
    public static final String JSON_PROPERTY_OBSERVED_GENERATION = "observedGeneration";
    @NotNull
    @JsonProperty(value="currentReplicas")
    private Integer currentReplicas;
    @NotNull
    @JsonProperty(value="desiredReplicas")
    private Integer desiredReplicas;
    @Nullable
    @JsonProperty(value="currentCPUUtilizationPercentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Integer currentCPUUtilizationPercentage;
    @Nullable
    @JsonProperty(value="lastScaleTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss[.SSSSSS]'Z'")
    private OffsetDateTime lastScaleTime;
    @Nullable
    @JsonProperty(value="observedGeneration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Long observedGeneration;

    public V1HorizontalPodAutoscalerStatus(Integer currentReplicas, Integer desiredReplicas) {
        this.currentReplicas = currentReplicas;
        this.desiredReplicas = desiredReplicas;
    }

    public Integer getCurrentReplicas() {
        return this.currentReplicas;
    }

    public void setCurrentReplicas(Integer currentReplicas) {
        this.currentReplicas = currentReplicas;
    }

    public V1HorizontalPodAutoscalerStatus currentReplicas(Integer currentReplicas) {
        this.currentReplicas = currentReplicas;
        return this;
    }

    public Integer getDesiredReplicas() {
        return this.desiredReplicas;
    }

    public void setDesiredReplicas(Integer desiredReplicas) {
        this.desiredReplicas = desiredReplicas;
    }

    public V1HorizontalPodAutoscalerStatus desiredReplicas(Integer desiredReplicas) {
        this.desiredReplicas = desiredReplicas;
        return this;
    }

    public Integer getCurrentCPUUtilizationPercentage() {
        return this.currentCPUUtilizationPercentage;
    }

    public void setCurrentCPUUtilizationPercentage(Integer currentCPUUtilizationPercentage) {
        this.currentCPUUtilizationPercentage = currentCPUUtilizationPercentage;
    }

    public V1HorizontalPodAutoscalerStatus currentCPUUtilizationPercentage(Integer currentCPUUtilizationPercentage) {
        this.currentCPUUtilizationPercentage = currentCPUUtilizationPercentage;
        return this;
    }

    public OffsetDateTime getLastScaleTime() {
        return this.lastScaleTime;
    }

    public void setLastScaleTime(OffsetDateTime lastScaleTime) {
        this.lastScaleTime = lastScaleTime;
    }

    public V1HorizontalPodAutoscalerStatus lastScaleTime(OffsetDateTime lastScaleTime) {
        this.lastScaleTime = lastScaleTime;
        return this;
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    public V1HorizontalPodAutoscalerStatus observedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1HorizontalPodAutoscalerStatus v1HorizontalPodAutoscalerStatus = (V1HorizontalPodAutoscalerStatus)o;
        return Objects.equals(this.currentReplicas, v1HorizontalPodAutoscalerStatus.currentReplicas) && Objects.equals(this.desiredReplicas, v1HorizontalPodAutoscalerStatus.desiredReplicas) && Objects.equals(this.currentCPUUtilizationPercentage, v1HorizontalPodAutoscalerStatus.currentCPUUtilizationPercentage) && Objects.equals(this.lastScaleTime, v1HorizontalPodAutoscalerStatus.lastScaleTime) && Objects.equals(this.observedGeneration, v1HorizontalPodAutoscalerStatus.observedGeneration);
    }

    public int hashCode() {
        return Objects.hash(this.currentReplicas, this.desiredReplicas, this.currentCPUUtilizationPercentage, this.lastScaleTime, this.observedGeneration);
    }

    public String toString() {
        return "V1HorizontalPodAutoscalerStatus(currentReplicas: " + this.getCurrentReplicas() + ", desiredReplicas: " + this.getDesiredReplicas() + ", currentCPUUtilizationPercentage: " + this.getCurrentCPUUtilizationPercentage() + ", lastScaleTime: " + String.valueOf(this.getLastScaleTime()) + ", observedGeneration: " + this.getObservedGeneration() + ")";
    }
}

