/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V1IngressBackend;
import io.micronaut.kubernetes.client.openapi.model.V1IngressRule;
import io.micronaut.kubernetes.client.openapi.model.V1IngressTLS;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"defaultBackend", "ingressClassName", "rules", "tls"})
public class V1IngressSpec {
    public static final String JSON_PROPERTY_DEFAULT_BACKEND = "defaultBackend";
    public static final String JSON_PROPERTY_INGRESS_CLASS_NAME = "ingressClassName";
    public static final String JSON_PROPERTY_RULES = "rules";
    public static final String JSON_PROPERTY_TLS = "tls";
    @Nullable
    @Valid
    @JsonProperty(value="defaultBackend")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1IngressBackend defaultBackend;
    @Nullable
    @JsonProperty(value="ingressClassName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String ingressClassName;
    @Nullable
    @JsonProperty(value="rules")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1IngressRule> rules;
    @Nullable
    @JsonProperty(value="tls")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1IngressTLS> tls;

    public V1IngressBackend getDefaultBackend() {
        return this.defaultBackend;
    }

    public void setDefaultBackend(V1IngressBackend defaultBackend) {
        this.defaultBackend = defaultBackend;
    }

    public V1IngressSpec defaultBackend(V1IngressBackend defaultBackend) {
        this.defaultBackend = defaultBackend;
        return this;
    }

    public String getIngressClassName() {
        return this.ingressClassName;
    }

    public void setIngressClassName(String ingressClassName) {
        this.ingressClassName = ingressClassName;
    }

    public V1IngressSpec ingressClassName(String ingressClassName) {
        this.ingressClassName = ingressClassName;
        return this;
    }

    public List<@Valid V1IngressRule> getRules() {
        return this.rules;
    }

    public void setRules(List<@Valid V1IngressRule> rules) {
        this.rules = rules;
    }

    public V1IngressSpec rules(List<@Valid V1IngressRule> rules) {
        this.rules = rules;
        return this;
    }

    public V1IngressSpec addRulesItem(V1IngressRule rulesItem) {
        if (this.rules == null) {
            this.rules = new ArrayList<V1IngressRule>();
        }
        this.rules.add(rulesItem);
        return this;
    }

    public List<@Valid V1IngressTLS> getTls() {
        return this.tls;
    }

    public void setTls(List<@Valid V1IngressTLS> tls) {
        this.tls = tls;
    }

    public V1IngressSpec tls(List<@Valid V1IngressTLS> tls) {
        this.tls = tls;
        return this;
    }

    public V1IngressSpec addTlsItem(V1IngressTLS tlsItem) {
        if (this.tls == null) {
            this.tls = new ArrayList<V1IngressTLS>();
        }
        this.tls.add(tlsItem);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1IngressSpec v1IngressSpec = (V1IngressSpec)o;
        return Objects.equals(this.defaultBackend, v1IngressSpec.defaultBackend) && Objects.equals(this.ingressClassName, v1IngressSpec.ingressClassName) && Objects.equals(this.rules, v1IngressSpec.rules) && Objects.equals(this.tls, v1IngressSpec.tls);
    }

    public int hashCode() {
        return Objects.hash(this.defaultBackend, this.ingressClassName, this.rules, this.tls);
    }

    public String toString() {
        return "V1IngressSpec(defaultBackend: " + String.valueOf(this.getDefaultBackend()) + ", ingressClassName: " + this.getIngressClassName() + ", rules: " + String.valueOf(this.getRules()) + ", tls: " + String.valueOf(this.getTls()) + ")";
    }
}

