/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V1LabelSelector;
import io.micronaut.kubernetes.client.openapi.model.V1NetworkPolicyEgressRule;
import io.micronaut.kubernetes.client.openapi.model.V1NetworkPolicyIngressRule;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"podSelector", "egress", "ingress", "policyTypes"})
public class V1NetworkPolicySpec {
    public static final String JSON_PROPERTY_POD_SELECTOR = "podSelector";
    public static final String JSON_PROPERTY_EGRESS = "egress";
    public static final String JSON_PROPERTY_INGRESS = "ingress";
    public static final String JSON_PROPERTY_POLICY_TYPES = "policyTypes";
    @NotNull
    @Valid
    @JsonProperty(value="podSelector")
    private V1LabelSelector podSelector;
    @Nullable
    @JsonProperty(value="egress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1NetworkPolicyEgressRule> egress;
    @Nullable
    @JsonProperty(value="ingress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1NetworkPolicyIngressRule> ingress;
    @Nullable
    @JsonProperty(value="policyTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@NotNull String> policyTypes;

    public V1NetworkPolicySpec(V1LabelSelector podSelector) {
        this.podSelector = podSelector;
    }

    public V1LabelSelector getPodSelector() {
        return this.podSelector;
    }

    public void setPodSelector(V1LabelSelector podSelector) {
        this.podSelector = podSelector;
    }

    public V1NetworkPolicySpec podSelector(V1LabelSelector podSelector) {
        this.podSelector = podSelector;
        return this;
    }

    public List<@Valid V1NetworkPolicyEgressRule> getEgress() {
        return this.egress;
    }

    public void setEgress(List<@Valid V1NetworkPolicyEgressRule> egress) {
        this.egress = egress;
    }

    public V1NetworkPolicySpec egress(List<@Valid V1NetworkPolicyEgressRule> egress) {
        this.egress = egress;
        return this;
    }

    public V1NetworkPolicySpec addEgressItem(V1NetworkPolicyEgressRule egressItem) {
        if (this.egress == null) {
            this.egress = new ArrayList<V1NetworkPolicyEgressRule>();
        }
        this.egress.add(egressItem);
        return this;
    }

    public List<@Valid V1NetworkPolicyIngressRule> getIngress() {
        return this.ingress;
    }

    public void setIngress(List<@Valid V1NetworkPolicyIngressRule> ingress) {
        this.ingress = ingress;
    }

    public V1NetworkPolicySpec ingress(List<@Valid V1NetworkPolicyIngressRule> ingress) {
        this.ingress = ingress;
        return this;
    }

    public V1NetworkPolicySpec addIngressItem(V1NetworkPolicyIngressRule ingressItem) {
        if (this.ingress == null) {
            this.ingress = new ArrayList<V1NetworkPolicyIngressRule>();
        }
        this.ingress.add(ingressItem);
        return this;
    }

    public List<@NotNull String> getPolicyTypes() {
        return this.policyTypes;
    }

    public void setPolicyTypes(List<@NotNull String> policyTypes) {
        this.policyTypes = policyTypes;
    }

    public V1NetworkPolicySpec policyTypes(List<@NotNull String> policyTypes) {
        this.policyTypes = policyTypes;
        return this;
    }

    public V1NetworkPolicySpec addPolicyTypesItem(String policyTypesItem) {
        if (this.policyTypes == null) {
            this.policyTypes = new ArrayList<String>();
        }
        this.policyTypes.add(policyTypesItem);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1NetworkPolicySpec v1NetworkPolicySpec = (V1NetworkPolicySpec)o;
        return Objects.equals(this.podSelector, v1NetworkPolicySpec.podSelector) && Objects.equals(this.egress, v1NetworkPolicySpec.egress) && Objects.equals(this.ingress, v1NetworkPolicySpec.ingress) && Objects.equals(this.policyTypes, v1NetworkPolicySpec.policyTypes);
    }

    public int hashCode() {
        return Objects.hash(this.podSelector, this.egress, this.ingress, this.policyTypes);
    }

    public String toString() {
        return "V1NetworkPolicySpec(podSelector: " + String.valueOf(this.getPodSelector()) + ", egress: " + String.valueOf(this.getEgress()) + ", ingress: " + String.valueOf(this.getIngress()) + ", policyTypes: " + String.valueOf(this.getPolicyTypes()) + ")";
    }
}

