/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V1ManagedFieldsEntry;
import io.micronaut.kubernetes.client.openapi.model.V1OwnerReference;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"annotations", "creationTimestamp", "deletionGracePeriodSeconds", "deletionTimestamp", "finalizers", "generateName", "generation", "labels", "managedFields", "name", "namespace", "ownerReferences", "resourceVersion", "selfLink", "uid"})
public class V1ObjectMeta {
    public static final String JSON_PROPERTY_ANNOTATIONS = "annotations";
    public static final String JSON_PROPERTY_CREATION_TIMESTAMP = "creationTimestamp";
    public static final String JSON_PROPERTY_DELETION_GRACE_PERIOD_SECONDS = "deletionGracePeriodSeconds";
    public static final String JSON_PROPERTY_DELETION_TIMESTAMP = "deletionTimestamp";
    public static final String JSON_PROPERTY_FINALIZERS = "finalizers";
    public static final String JSON_PROPERTY_GENERATE_NAME = "generateName";
    public static final String JSON_PROPERTY_GENERATION = "generation";
    public static final String JSON_PROPERTY_LABELS = "labels";
    public static final String JSON_PROPERTY_MANAGED_FIELDS = "managedFields";
    public static final String JSON_PROPERTY_NAME = "name";
    public static final String JSON_PROPERTY_NAMESPACE = "namespace";
    public static final String JSON_PROPERTY_OWNER_REFERENCES = "ownerReferences";
    public static final String JSON_PROPERTY_RESOURCE_VERSION = "resourceVersion";
    public static final String JSON_PROPERTY_SELF_LINK = "selfLink";
    public static final String JSON_PROPERTY_UID = "uid";
    @Nullable
    @JsonProperty(value="annotations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable Map<String, @NotNull String> annotations;
    @Nullable
    @JsonProperty(value="creationTimestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss[.SSSSSS]'Z'")
    private OffsetDateTime creationTimestamp;
    @Nullable
    @JsonProperty(value="deletionGracePeriodSeconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Long deletionGracePeriodSeconds;
    @Nullable
    @JsonProperty(value="deletionTimestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss[.SSSSSS]'Z'")
    private OffsetDateTime deletionTimestamp;
    @Nullable
    @JsonProperty(value="finalizers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@NotNull String> finalizers;
    @Nullable
    @JsonProperty(value="generateName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String generateName;
    @Nullable
    @JsonProperty(value="generation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Long generation;
    @Nullable
    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable Map<String, @NotNull String> labels;
    @Nullable
    @JsonProperty(value="managedFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1ManagedFieldsEntry> managedFields;
    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String name;
    @Nullable
    @JsonProperty(value="namespace")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String namespace;
    @Nullable
    @JsonProperty(value="ownerReferences")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1OwnerReference> ownerReferences;
    @Nullable
    @JsonProperty(value="resourceVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String resourceVersion;
    @Nullable
    @JsonProperty(value="selfLink")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String selfLink;
    @Nullable
    @JsonProperty(value="uid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String uid;

    public Map<String, @NotNull String> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Map<String, @NotNull String> annotations) {
        this.annotations = annotations;
    }

    public V1ObjectMeta annotations(Map<String, @NotNull String> annotations) {
        this.annotations = annotations;
        return this;
    }

    public V1ObjectMeta putAnnotationsItem(String key, String annotationsItem) {
        if (this.annotations == null) {
            this.annotations = new HashMap<String, String>();
        }
        this.annotations.put(key, annotationsItem);
        return this;
    }

    public OffsetDateTime getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public void setCreationTimestamp(OffsetDateTime creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    public V1ObjectMeta creationTimestamp(OffsetDateTime creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
        return this;
    }

    public Long getDeletionGracePeriodSeconds() {
        return this.deletionGracePeriodSeconds;
    }

    public void setDeletionGracePeriodSeconds(Long deletionGracePeriodSeconds) {
        this.deletionGracePeriodSeconds = deletionGracePeriodSeconds;
    }

    public V1ObjectMeta deletionGracePeriodSeconds(Long deletionGracePeriodSeconds) {
        this.deletionGracePeriodSeconds = deletionGracePeriodSeconds;
        return this;
    }

    public OffsetDateTime getDeletionTimestamp() {
        return this.deletionTimestamp;
    }

    public void setDeletionTimestamp(OffsetDateTime deletionTimestamp) {
        this.deletionTimestamp = deletionTimestamp;
    }

    public V1ObjectMeta deletionTimestamp(OffsetDateTime deletionTimestamp) {
        this.deletionTimestamp = deletionTimestamp;
        return this;
    }

    public List<@NotNull String> getFinalizers() {
        return this.finalizers;
    }

    public void setFinalizers(List<@NotNull String> finalizers) {
        this.finalizers = finalizers;
    }

    public V1ObjectMeta finalizers(List<@NotNull String> finalizers) {
        this.finalizers = finalizers;
        return this;
    }

    public V1ObjectMeta addFinalizersItem(String finalizersItem) {
        if (this.finalizers == null) {
            this.finalizers = new ArrayList<String>();
        }
        this.finalizers.add(finalizersItem);
        return this;
    }

    public String getGenerateName() {
        return this.generateName;
    }

    public void setGenerateName(String generateName) {
        this.generateName = generateName;
    }

    public V1ObjectMeta generateName(String generateName) {
        this.generateName = generateName;
        return this;
    }

    public Long getGeneration() {
        return this.generation;
    }

    public void setGeneration(Long generation) {
        this.generation = generation;
    }

    public V1ObjectMeta generation(Long generation) {
        this.generation = generation;
        return this;
    }

    public Map<String, @NotNull String> getLabels() {
        return this.labels;
    }

    public void setLabels(Map<String, @NotNull String> labels) {
        this.labels = labels;
    }

    public V1ObjectMeta labels(Map<String, @NotNull String> labels) {
        this.labels = labels;
        return this;
    }

    public V1ObjectMeta putLabelsItem(String key, String labelsItem) {
        if (this.labels == null) {
            this.labels = new HashMap<String, String>();
        }
        this.labels.put(key, labelsItem);
        return this;
    }

    public List<@Valid V1ManagedFieldsEntry> getManagedFields() {
        return this.managedFields;
    }

    public void setManagedFields(List<@Valid V1ManagedFieldsEntry> managedFields) {
        this.managedFields = managedFields;
    }

    public V1ObjectMeta managedFields(List<@Valid V1ManagedFieldsEntry> managedFields) {
        this.managedFields = managedFields;
        return this;
    }

    public V1ObjectMeta addManagedFieldsItem(V1ManagedFieldsEntry managedFieldsItem) {
        if (this.managedFields == null) {
            this.managedFields = new ArrayList<V1ManagedFieldsEntry>();
        }
        this.managedFields.add(managedFieldsItem);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1ObjectMeta name(String name) {
        this.name = name;
        return this;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public V1ObjectMeta namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public List<@Valid V1OwnerReference> getOwnerReferences() {
        return this.ownerReferences;
    }

    public void setOwnerReferences(List<@Valid V1OwnerReference> ownerReferences) {
        this.ownerReferences = ownerReferences;
    }

    public V1ObjectMeta ownerReferences(List<@Valid V1OwnerReference> ownerReferences) {
        this.ownerReferences = ownerReferences;
        return this;
    }

    public V1ObjectMeta addOwnerReferencesItem(V1OwnerReference ownerReferencesItem) {
        if (this.ownerReferences == null) {
            this.ownerReferences = new ArrayList<V1OwnerReference>();
        }
        this.ownerReferences.add(ownerReferencesItem);
        return this;
    }

    public String getResourceVersion() {
        return this.resourceVersion;
    }

    public void setResourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
    }

    public V1ObjectMeta resourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
        return this;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public void setSelfLink(String selfLink) {
        this.selfLink = selfLink;
    }

    public V1ObjectMeta selfLink(String selfLink) {
        this.selfLink = selfLink;
        return this;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public V1ObjectMeta uid(String uid) {
        this.uid = uid;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ObjectMeta v1ObjectMeta = (V1ObjectMeta)o;
        return Objects.equals(this.annotations, v1ObjectMeta.annotations) && Objects.equals(this.creationTimestamp, v1ObjectMeta.creationTimestamp) && Objects.equals(this.deletionGracePeriodSeconds, v1ObjectMeta.deletionGracePeriodSeconds) && Objects.equals(this.deletionTimestamp, v1ObjectMeta.deletionTimestamp) && Objects.equals(this.finalizers, v1ObjectMeta.finalizers) && Objects.equals(this.generateName, v1ObjectMeta.generateName) && Objects.equals(this.generation, v1ObjectMeta.generation) && Objects.equals(this.labels, v1ObjectMeta.labels) && Objects.equals(this.managedFields, v1ObjectMeta.managedFields) && Objects.equals(this.name, v1ObjectMeta.name) && Objects.equals(this.namespace, v1ObjectMeta.namespace) && Objects.equals(this.ownerReferences, v1ObjectMeta.ownerReferences) && Objects.equals(this.resourceVersion, v1ObjectMeta.resourceVersion) && Objects.equals(this.selfLink, v1ObjectMeta.selfLink) && Objects.equals(this.uid, v1ObjectMeta.uid);
    }

    public int hashCode() {
        return Objects.hash(this.annotations, this.creationTimestamp, this.deletionGracePeriodSeconds, this.deletionTimestamp, this.finalizers, this.generateName, this.generation, this.labels, this.managedFields, this.name, this.namespace, this.ownerReferences, this.resourceVersion, this.selfLink, this.uid);
    }

    public String toString() {
        return "V1ObjectMeta(annotations: " + String.valueOf(this.getAnnotations()) + ", creationTimestamp: " + String.valueOf(this.getCreationTimestamp()) + ", deletionGracePeriodSeconds: " + this.getDeletionGracePeriodSeconds() + ", deletionTimestamp: " + String.valueOf(this.getDeletionTimestamp()) + ", finalizers: " + String.valueOf(this.getFinalizers()) + ", generateName: " + this.getGenerateName() + ", generation: " + this.getGeneration() + ", labels: " + String.valueOf(this.getLabels()) + ", managedFields: " + String.valueOf(this.getManagedFields()) + ", name: " + this.getName() + ", namespace: " + this.getNamespace() + ", ownerReferences: " + String.valueOf(this.getOwnerReferences()) + ", resourceVersion: " + this.getResourceVersion() + ", selfLink: " + this.getSelfLink() + ", uid: " + this.getUid() + ")";
    }
}

