/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.FlowcontrolV1Subject;
import io.micronaut.kubernetes.client.openapi.model.V1NonResourcePolicyRule;
import io.micronaut.kubernetes.client.openapi.model.V1ResourcePolicyRule;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"subjects", "nonResourceRules", "resourceRules"})
public class V1PolicyRulesWithSubjects {
    public static final String JSON_PROPERTY_SUBJECTS = "subjects";
    public static final String JSON_PROPERTY_NON_RESOURCE_RULES = "nonResourceRules";
    public static final String JSON_PROPERTY_RESOURCE_RULES = "resourceRules";
    @NotNull
    @JsonProperty(value="subjects")
    private @NotNull List<@Valid FlowcontrolV1Subject> subjects;
    @Nullable
    @JsonProperty(value="nonResourceRules")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1NonResourcePolicyRule> nonResourceRules;
    @Nullable
    @JsonProperty(value="resourceRules")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1ResourcePolicyRule> resourceRules;

    public V1PolicyRulesWithSubjects(List<@Valid FlowcontrolV1Subject> subjects) {
        this.subjects = subjects;
    }

    public List<@Valid FlowcontrolV1Subject> getSubjects() {
        return this.subjects;
    }

    public void setSubjects(List<@Valid FlowcontrolV1Subject> subjects) {
        this.subjects = subjects;
    }

    public V1PolicyRulesWithSubjects subjects(List<@Valid FlowcontrolV1Subject> subjects) {
        this.subjects = subjects;
        return this;
    }

    public V1PolicyRulesWithSubjects addSubjectsItem(FlowcontrolV1Subject subjectsItem) {
        this.subjects.add(subjectsItem);
        return this;
    }

    public List<@Valid V1NonResourcePolicyRule> getNonResourceRules() {
        return this.nonResourceRules;
    }

    public void setNonResourceRules(List<@Valid V1NonResourcePolicyRule> nonResourceRules) {
        this.nonResourceRules = nonResourceRules;
    }

    public V1PolicyRulesWithSubjects nonResourceRules(List<@Valid V1NonResourcePolicyRule> nonResourceRules) {
        this.nonResourceRules = nonResourceRules;
        return this;
    }

    public V1PolicyRulesWithSubjects addNonResourceRulesItem(V1NonResourcePolicyRule nonResourceRulesItem) {
        if (this.nonResourceRules == null) {
            this.nonResourceRules = new ArrayList<V1NonResourcePolicyRule>();
        }
        this.nonResourceRules.add(nonResourceRulesItem);
        return this;
    }

    public List<@Valid V1ResourcePolicyRule> getResourceRules() {
        return this.resourceRules;
    }

    public void setResourceRules(List<@Valid V1ResourcePolicyRule> resourceRules) {
        this.resourceRules = resourceRules;
    }

    public V1PolicyRulesWithSubjects resourceRules(List<@Valid V1ResourcePolicyRule> resourceRules) {
        this.resourceRules = resourceRules;
        return this;
    }

    public V1PolicyRulesWithSubjects addResourceRulesItem(V1ResourcePolicyRule resourceRulesItem) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList<V1ResourcePolicyRule>();
        }
        this.resourceRules.add(resourceRulesItem);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PolicyRulesWithSubjects v1PolicyRulesWithSubjects = (V1PolicyRulesWithSubjects)o;
        return Objects.equals(this.subjects, v1PolicyRulesWithSubjects.subjects) && Objects.equals(this.nonResourceRules, v1PolicyRulesWithSubjects.nonResourceRules) && Objects.equals(this.resourceRules, v1PolicyRulesWithSubjects.resourceRules);
    }

    public int hashCode() {
        return Objects.hash(this.subjects, this.nonResourceRules, this.resourceRules);
    }

    public String toString() {
        return "V1PolicyRulesWithSubjects(subjects: " + String.valueOf(this.getSubjects()) + ", nonResourceRules: " + String.valueOf(this.getNonResourceRules()) + ", resourceRules: " + String.valueOf(this.getResourceRules()) + ")";
    }
}

