/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V1ResourceHealth;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"name", "resources"})
public class V1ResourceStatus {
    public static final String JSON_PROPERTY_NAME = "name";
    public static final String JSON_PROPERTY_RESOURCES = "resources";
    @NotNull
    @JsonProperty(value="name")
    private String name;
    @Nullable
    @JsonProperty(value="resources")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1ResourceHealth> resources;

    public V1ResourceStatus(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1ResourceStatus name(String name) {
        this.name = name;
        return this;
    }

    public List<@Valid V1ResourceHealth> getResources() {
        return this.resources;
    }

    public void setResources(List<@Valid V1ResourceHealth> resources) {
        this.resources = resources;
    }

    public V1ResourceStatus resources(List<@Valid V1ResourceHealth> resources) {
        this.resources = resources;
        return this;
    }

    public V1ResourceStatus addResourcesItem(V1ResourceHealth resourcesItem) {
        if (this.resources == null) {
            this.resources = new ArrayList<V1ResourceHealth>();
        }
        this.resources.add(resourcesItem);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ResourceStatus v1ResourceStatus = (V1ResourceStatus)o;
        return Objects.equals(this.name, v1ResourceStatus.name) && Objects.equals(this.resources, v1ResourceStatus.resources);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.resources);
    }

    public String toString() {
        return "V1ResourceStatus(name: " + this.getName() + ", resources: " + String.valueOf(this.getResources()) + ")";
    }
}

