/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.common.KubernetesObject;
import io.micronaut.kubernetes.client.openapi.model.V1LocalObjectReference;
import io.micronaut.kubernetes.client.openapi.model.V1ObjectMeta;
import io.micronaut.kubernetes.client.openapi.model.V1ObjectReference;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"apiVersion", "automountServiceAccountToken", "imagePullSecrets", "kind", "metadata", "secrets"})
public class V1ServiceAccount
implements KubernetesObject {
    public static final String JSON_PROPERTY_API_VERSION = "apiVersion";
    public static final String JSON_PROPERTY_AUTOMOUNT_SERVICE_ACCOUNT_TOKEN = "automountServiceAccountToken";
    public static final String JSON_PROPERTY_IMAGE_PULL_SECRETS = "imagePullSecrets";
    public static final String JSON_PROPERTY_KIND = "kind";
    public static final String JSON_PROPERTY_METADATA = "metadata";
    public static final String JSON_PROPERTY_SECRETS = "secrets";
    @Nullable
    @JsonProperty(value="apiVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String apiVersion;
    @Nullable
    @JsonProperty(value="automountServiceAccountToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Boolean automountServiceAccountToken;
    @Nullable
    @JsonProperty(value="imagePullSecrets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1LocalObjectReference> imagePullSecrets;
    @Nullable
    @JsonProperty(value="kind")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String kind;
    @Nullable
    @Valid
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1ObjectMeta metadata;
    @Nullable
    @JsonProperty(value="secrets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1ObjectReference> secrets;

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1ServiceAccount apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public Boolean getAutomountServiceAccountToken() {
        return this.automountServiceAccountToken;
    }

    public void setAutomountServiceAccountToken(Boolean automountServiceAccountToken) {
        this.automountServiceAccountToken = automountServiceAccountToken;
    }

    public V1ServiceAccount automountServiceAccountToken(Boolean automountServiceAccountToken) {
        this.automountServiceAccountToken = automountServiceAccountToken;
        return this;
    }

    public List<@Valid V1LocalObjectReference> getImagePullSecrets() {
        return this.imagePullSecrets;
    }

    public void setImagePullSecrets(List<@Valid V1LocalObjectReference> imagePullSecrets) {
        this.imagePullSecrets = imagePullSecrets;
    }

    public V1ServiceAccount imagePullSecrets(List<@Valid V1LocalObjectReference> imagePullSecrets) {
        this.imagePullSecrets = imagePullSecrets;
        return this;
    }

    public V1ServiceAccount addImagePullSecretsItem(V1LocalObjectReference imagePullSecretsItem) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<V1LocalObjectReference>();
        }
        this.imagePullSecrets.add(imagePullSecretsItem);
        return this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1ServiceAccount kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Override
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1ServiceAccount metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    public List<@Valid V1ObjectReference> getSecrets() {
        return this.secrets;
    }

    public void setSecrets(List<@Valid V1ObjectReference> secrets) {
        this.secrets = secrets;
    }

    public V1ServiceAccount secrets(List<@Valid V1ObjectReference> secrets) {
        this.secrets = secrets;
        return this;
    }

    public V1ServiceAccount addSecretsItem(V1ObjectReference secretsItem) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<V1ObjectReference>();
        }
        this.secrets.add(secretsItem);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ServiceAccount v1ServiceAccount = (V1ServiceAccount)o;
        return Objects.equals(this.apiVersion, v1ServiceAccount.apiVersion) && Objects.equals(this.automountServiceAccountToken, v1ServiceAccount.automountServiceAccountToken) && Objects.equals(this.imagePullSecrets, v1ServiceAccount.imagePullSecrets) && Objects.equals(this.kind, v1ServiceAccount.kind) && Objects.equals(this.metadata, v1ServiceAccount.metadata) && Objects.equals(this.secrets, v1ServiceAccount.secrets);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.automountServiceAccountToken, this.imagePullSecrets, this.kind, this.metadata, this.secrets);
    }

    public String toString() {
        return "V1ServiceAccount(apiVersion: " + this.getApiVersion() + ", automountServiceAccountToken: " + this.getAutomountServiceAccountToken() + ", imagePullSecrets: " + String.valueOf(this.getImagePullSecrets()) + ", kind: " + this.getKind() + ", metadata: " + String.valueOf(this.getMetadata()) + ", secrets: " + String.valueOf(this.getSecrets()) + ")";
    }
}

