/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V1LabelSelector;
import io.micronaut.kubernetes.client.openapi.model.V1PersistentVolumeClaim;
import io.micronaut.kubernetes.client.openapi.model.V1PodTemplateSpec;
import io.micronaut.kubernetes.client.openapi.model.V1StatefulSetOrdinals;
import io.micronaut.kubernetes.client.openapi.model.V1StatefulSetPersistentVolumeClaimRetentionPolicy;
import io.micronaut.kubernetes.client.openapi.model.V1StatefulSetUpdateStrategy;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"selector", "serviceName", "template", "minReadySeconds", "ordinals", "persistentVolumeClaimRetentionPolicy", "podManagementPolicy", "replicas", "revisionHistoryLimit", "updateStrategy", "volumeClaimTemplates"})
public class V1StatefulSetSpec {
    public static final String JSON_PROPERTY_SELECTOR = "selector";
    public static final String JSON_PROPERTY_SERVICE_NAME = "serviceName";
    public static final String JSON_PROPERTY_TEMPLATE = "template";
    public static final String JSON_PROPERTY_MIN_READY_SECONDS = "minReadySeconds";
    public static final String JSON_PROPERTY_ORDINALS = "ordinals";
    public static final String JSON_PROPERTY_PERSISTENT_VOLUME_CLAIM_RETENTION_POLICY = "persistentVolumeClaimRetentionPolicy";
    public static final String JSON_PROPERTY_POD_MANAGEMENT_POLICY = "podManagementPolicy";
    public static final String JSON_PROPERTY_REPLICAS = "replicas";
    public static final String JSON_PROPERTY_REVISION_HISTORY_LIMIT = "revisionHistoryLimit";
    public static final String JSON_PROPERTY_UPDATE_STRATEGY = "updateStrategy";
    public static final String JSON_PROPERTY_VOLUME_CLAIM_TEMPLATES = "volumeClaimTemplates";
    @NotNull
    @Valid
    @JsonProperty(value="selector")
    private V1LabelSelector selector;
    @NotNull
    @JsonProperty(value="serviceName")
    private String serviceName;
    @NotNull
    @Valid
    @JsonProperty(value="template")
    private V1PodTemplateSpec template;
    @Nullable
    @JsonProperty(value="minReadySeconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Integer minReadySeconds;
    @Nullable
    @Valid
    @JsonProperty(value="ordinals")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1StatefulSetOrdinals ordinals;
    @Nullable
    @Valid
    @JsonProperty(value="persistentVolumeClaimRetentionPolicy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1StatefulSetPersistentVolumeClaimRetentionPolicy persistentVolumeClaimRetentionPolicy;
    @Nullable
    @JsonProperty(value="podManagementPolicy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String podManagementPolicy;
    @Nullable
    @JsonProperty(value="replicas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Integer replicas;
    @Nullable
    @JsonProperty(value="revisionHistoryLimit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Integer revisionHistoryLimit;
    @Nullable
    @Valid
    @JsonProperty(value="updateStrategy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1StatefulSetUpdateStrategy updateStrategy;
    @Nullable
    @JsonProperty(value="volumeClaimTemplates")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1PersistentVolumeClaim> volumeClaimTemplates;

    public V1StatefulSetSpec(V1LabelSelector selector, String serviceName, V1PodTemplateSpec template) {
        this.selector = selector;
        this.serviceName = serviceName;
        this.template = template;
    }

    public V1LabelSelector getSelector() {
        return this.selector;
    }

    public void setSelector(V1LabelSelector selector) {
        this.selector = selector;
    }

    public V1StatefulSetSpec selector(V1LabelSelector selector) {
        this.selector = selector;
        return this;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public V1StatefulSetSpec serviceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public V1PodTemplateSpec getTemplate() {
        return this.template;
    }

    public void setTemplate(V1PodTemplateSpec template) {
        this.template = template;
    }

    public V1StatefulSetSpec template(V1PodTemplateSpec template) {
        this.template = template;
        return this;
    }

    public Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    public void setMinReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
    }

    public V1StatefulSetSpec minReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return this;
    }

    public V1StatefulSetOrdinals getOrdinals() {
        return this.ordinals;
    }

    public void setOrdinals(V1StatefulSetOrdinals ordinals) {
        this.ordinals = ordinals;
    }

    public V1StatefulSetSpec ordinals(V1StatefulSetOrdinals ordinals) {
        this.ordinals = ordinals;
        return this;
    }

    public V1StatefulSetPersistentVolumeClaimRetentionPolicy getPersistentVolumeClaimRetentionPolicy() {
        return this.persistentVolumeClaimRetentionPolicy;
    }

    public void setPersistentVolumeClaimRetentionPolicy(V1StatefulSetPersistentVolumeClaimRetentionPolicy persistentVolumeClaimRetentionPolicy) {
        this.persistentVolumeClaimRetentionPolicy = persistentVolumeClaimRetentionPolicy;
    }

    public V1StatefulSetSpec persistentVolumeClaimRetentionPolicy(V1StatefulSetPersistentVolumeClaimRetentionPolicy persistentVolumeClaimRetentionPolicy) {
        this.persistentVolumeClaimRetentionPolicy = persistentVolumeClaimRetentionPolicy;
        return this;
    }

    public String getPodManagementPolicy() {
        return this.podManagementPolicy;
    }

    public void setPodManagementPolicy(String podManagementPolicy) {
        this.podManagementPolicy = podManagementPolicy;
    }

    public V1StatefulSetSpec podManagementPolicy(String podManagementPolicy) {
        this.podManagementPolicy = podManagementPolicy;
        return this;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public V1StatefulSetSpec replicas(Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    public Integer getRevisionHistoryLimit() {
        return this.revisionHistoryLimit;
    }

    public void setRevisionHistoryLimit(Integer revisionHistoryLimit) {
        this.revisionHistoryLimit = revisionHistoryLimit;
    }

    public V1StatefulSetSpec revisionHistoryLimit(Integer revisionHistoryLimit) {
        this.revisionHistoryLimit = revisionHistoryLimit;
        return this;
    }

    public V1StatefulSetUpdateStrategy getUpdateStrategy() {
        return this.updateStrategy;
    }

    public void setUpdateStrategy(V1StatefulSetUpdateStrategy updateStrategy) {
        this.updateStrategy = updateStrategy;
    }

    public V1StatefulSetSpec updateStrategy(V1StatefulSetUpdateStrategy updateStrategy) {
        this.updateStrategy = updateStrategy;
        return this;
    }

    public List<@Valid V1PersistentVolumeClaim> getVolumeClaimTemplates() {
        return this.volumeClaimTemplates;
    }

    public void setVolumeClaimTemplates(List<@Valid V1PersistentVolumeClaim> volumeClaimTemplates) {
        this.volumeClaimTemplates = volumeClaimTemplates;
    }

    public V1StatefulSetSpec volumeClaimTemplates(List<@Valid V1PersistentVolumeClaim> volumeClaimTemplates) {
        this.volumeClaimTemplates = volumeClaimTemplates;
        return this;
    }

    public V1StatefulSetSpec addVolumeClaimTemplatesItem(V1PersistentVolumeClaim volumeClaimTemplatesItem) {
        if (this.volumeClaimTemplates == null) {
            this.volumeClaimTemplates = new ArrayList<V1PersistentVolumeClaim>();
        }
        this.volumeClaimTemplates.add(volumeClaimTemplatesItem);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1StatefulSetSpec v1StatefulSetSpec = (V1StatefulSetSpec)o;
        return Objects.equals(this.selector, v1StatefulSetSpec.selector) && Objects.equals(this.serviceName, v1StatefulSetSpec.serviceName) && Objects.equals(this.template, v1StatefulSetSpec.template) && Objects.equals(this.minReadySeconds, v1StatefulSetSpec.minReadySeconds) && Objects.equals(this.ordinals, v1StatefulSetSpec.ordinals) && Objects.equals(this.persistentVolumeClaimRetentionPolicy, v1StatefulSetSpec.persistentVolumeClaimRetentionPolicy) && Objects.equals(this.podManagementPolicy, v1StatefulSetSpec.podManagementPolicy) && Objects.equals(this.replicas, v1StatefulSetSpec.replicas) && Objects.equals(this.revisionHistoryLimit, v1StatefulSetSpec.revisionHistoryLimit) && Objects.equals(this.updateStrategy, v1StatefulSetSpec.updateStrategy) && Objects.equals(this.volumeClaimTemplates, v1StatefulSetSpec.volumeClaimTemplates);
    }

    public int hashCode() {
        return Objects.hash(this.selector, this.serviceName, this.template, this.minReadySeconds, this.ordinals, this.persistentVolumeClaimRetentionPolicy, this.podManagementPolicy, this.replicas, this.revisionHistoryLimit, this.updateStrategy, this.volumeClaimTemplates);
    }

    public String toString() {
        return "V1StatefulSetSpec(selector: " + String.valueOf(this.getSelector()) + ", serviceName: " + this.getServiceName() + ", template: " + String.valueOf(this.getTemplate()) + ", minReadySeconds: " + this.getMinReadySeconds() + ", ordinals: " + String.valueOf(this.getOrdinals()) + ", persistentVolumeClaimRetentionPolicy: " + String.valueOf(this.getPersistentVolumeClaimRetentionPolicy()) + ", podManagementPolicy: " + this.getPodManagementPolicy() + ", replicas: " + this.getReplicas() + ", revisionHistoryLimit: " + this.getRevisionHistoryLimit() + ", updateStrategy: " + String.valueOf(this.getUpdateStrategy()) + ", volumeClaimTemplates: " + String.valueOf(this.getVolumeClaimTemplates()) + ")";
    }
}

