/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.common.KubernetesObject;
import io.micronaut.kubernetes.client.openapi.model.V1ObjectMeta;
import io.micronaut.kubernetes.client.openapi.model.V1TopologySelectorTerm;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"provisioner", "allowVolumeExpansion", "allowedTopologies", "apiVersion", "kind", "metadata", "mountOptions", "parameters", "reclaimPolicy", "volumeBindingMode"})
public class V1StorageClass
implements KubernetesObject {
    public static final String JSON_PROPERTY_PROVISIONER = "provisioner";
    public static final String JSON_PROPERTY_ALLOW_VOLUME_EXPANSION = "allowVolumeExpansion";
    public static final String JSON_PROPERTY_ALLOWED_TOPOLOGIES = "allowedTopologies";
    public static final String JSON_PROPERTY_API_VERSION = "apiVersion";
    public static final String JSON_PROPERTY_KIND = "kind";
    public static final String JSON_PROPERTY_METADATA = "metadata";
    public static final String JSON_PROPERTY_MOUNT_OPTIONS = "mountOptions";
    public static final String JSON_PROPERTY_PARAMETERS = "parameters";
    public static final String JSON_PROPERTY_RECLAIM_POLICY = "reclaimPolicy";
    public static final String JSON_PROPERTY_VOLUME_BINDING_MODE = "volumeBindingMode";
    @NotNull
    @JsonProperty(value="provisioner")
    private String provisioner;
    @Nullable
    @JsonProperty(value="allowVolumeExpansion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Boolean allowVolumeExpansion;
    @Nullable
    @JsonProperty(value="allowedTopologies")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1TopologySelectorTerm> allowedTopologies;
    @Nullable
    @JsonProperty(value="apiVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String apiVersion;
    @Nullable
    @JsonProperty(value="kind")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String kind;
    @Nullable
    @Valid
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1ObjectMeta metadata;
    @Nullable
    @JsonProperty(value="mountOptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@NotNull String> mountOptions;
    @Nullable
    @JsonProperty(value="parameters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable Map<String, @NotNull String> parameters;
    @Nullable
    @JsonProperty(value="reclaimPolicy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String reclaimPolicy;
    @Nullable
    @JsonProperty(value="volumeBindingMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String volumeBindingMode;

    public V1StorageClass(String provisioner) {
        this.provisioner = provisioner;
    }

    public String getProvisioner() {
        return this.provisioner;
    }

    public void setProvisioner(String provisioner) {
        this.provisioner = provisioner;
    }

    public V1StorageClass provisioner(String provisioner) {
        this.provisioner = provisioner;
        return this;
    }

    public Boolean getAllowVolumeExpansion() {
        return this.allowVolumeExpansion;
    }

    public void setAllowVolumeExpansion(Boolean allowVolumeExpansion) {
        this.allowVolumeExpansion = allowVolumeExpansion;
    }

    public V1StorageClass allowVolumeExpansion(Boolean allowVolumeExpansion) {
        this.allowVolumeExpansion = allowVolumeExpansion;
        return this;
    }

    public List<@Valid V1TopologySelectorTerm> getAllowedTopologies() {
        return this.allowedTopologies;
    }

    public void setAllowedTopologies(List<@Valid V1TopologySelectorTerm> allowedTopologies) {
        this.allowedTopologies = allowedTopologies;
    }

    public V1StorageClass allowedTopologies(List<@Valid V1TopologySelectorTerm> allowedTopologies) {
        this.allowedTopologies = allowedTopologies;
        return this;
    }

    public V1StorageClass addAllowedTopologiesItem(V1TopologySelectorTerm allowedTopologiesItem) {
        if (this.allowedTopologies == null) {
            this.allowedTopologies = new ArrayList<V1TopologySelectorTerm>();
        }
        this.allowedTopologies.add(allowedTopologiesItem);
        return this;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1StorageClass apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1StorageClass kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Override
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1StorageClass metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    public List<@NotNull String> getMountOptions() {
        return this.mountOptions;
    }

    public void setMountOptions(List<@NotNull String> mountOptions) {
        this.mountOptions = mountOptions;
    }

    public V1StorageClass mountOptions(List<@NotNull String> mountOptions) {
        this.mountOptions = mountOptions;
        return this;
    }

    public V1StorageClass addMountOptionsItem(String mountOptionsItem) {
        if (this.mountOptions == null) {
            this.mountOptions = new ArrayList<String>();
        }
        this.mountOptions.add(mountOptionsItem);
        return this;
    }

    public Map<String, @NotNull String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, @NotNull String> parameters) {
        this.parameters = parameters;
    }

    public V1StorageClass parameters(Map<String, @NotNull String> parameters) {
        this.parameters = parameters;
        return this;
    }

    public V1StorageClass putParametersItem(String key, String parametersItem) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        this.parameters.put(key, parametersItem);
        return this;
    }

    public String getReclaimPolicy() {
        return this.reclaimPolicy;
    }

    public void setReclaimPolicy(String reclaimPolicy) {
        this.reclaimPolicy = reclaimPolicy;
    }

    public V1StorageClass reclaimPolicy(String reclaimPolicy) {
        this.reclaimPolicy = reclaimPolicy;
        return this;
    }

    public String getVolumeBindingMode() {
        return this.volumeBindingMode;
    }

    public void setVolumeBindingMode(String volumeBindingMode) {
        this.volumeBindingMode = volumeBindingMode;
    }

    public V1StorageClass volumeBindingMode(String volumeBindingMode) {
        this.volumeBindingMode = volumeBindingMode;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1StorageClass v1StorageClass = (V1StorageClass)o;
        return Objects.equals(this.provisioner, v1StorageClass.provisioner) && Objects.equals(this.allowVolumeExpansion, v1StorageClass.allowVolumeExpansion) && Objects.equals(this.allowedTopologies, v1StorageClass.allowedTopologies) && Objects.equals(this.apiVersion, v1StorageClass.apiVersion) && Objects.equals(this.kind, v1StorageClass.kind) && Objects.equals(this.metadata, v1StorageClass.metadata) && Objects.equals(this.mountOptions, v1StorageClass.mountOptions) && Objects.equals(this.parameters, v1StorageClass.parameters) && Objects.equals(this.reclaimPolicy, v1StorageClass.reclaimPolicy) && Objects.equals(this.volumeBindingMode, v1StorageClass.volumeBindingMode);
    }

    public int hashCode() {
        return Objects.hash(this.provisioner, this.allowVolumeExpansion, this.allowedTopologies, this.apiVersion, this.kind, this.metadata, this.mountOptions, this.parameters, this.reclaimPolicy, this.volumeBindingMode);
    }

    public String toString() {
        return "V1StorageClass(provisioner: " + this.getProvisioner() + ", allowVolumeExpansion: " + this.getAllowVolumeExpansion() + ", allowedTopologies: " + String.valueOf(this.getAllowedTopologies()) + ", apiVersion: " + this.getApiVersion() + ", kind: " + this.getKind() + ", metadata: " + String.valueOf(this.getMetadata()) + ", mountOptions: " + String.valueOf(this.getMountOptions()) + ", parameters: " + String.valueOf(this.getParameters()) + ", reclaimPolicy: " + this.getReclaimPolicy() + ", volumeBindingMode: " + this.getVolumeBindingMode() + ")";
    }
}

