/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V1NonResourceRule;
import io.micronaut.kubernetes.client.openapi.model.V1ResourceRule;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"incomplete", "nonResourceRules", "resourceRules", "evaluationError"})
public class V1SubjectRulesReviewStatus {
    public static final String JSON_PROPERTY_INCOMPLETE = "incomplete";
    public static final String JSON_PROPERTY_NON_RESOURCE_RULES = "nonResourceRules";
    public static final String JSON_PROPERTY_RESOURCE_RULES = "resourceRules";
    public static final String JSON_PROPERTY_EVALUATION_ERROR = "evaluationError";
    @NotNull
    @JsonProperty(value="incomplete")
    private Boolean incomplete;
    @NotNull
    @JsonProperty(value="nonResourceRules")
    private @NotNull List<@Valid V1NonResourceRule> nonResourceRules;
    @NotNull
    @JsonProperty(value="resourceRules")
    private @NotNull List<@Valid V1ResourceRule> resourceRules;
    @Nullable
    @JsonProperty(value="evaluationError")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String evaluationError;

    public V1SubjectRulesReviewStatus(Boolean incomplete, List<@Valid V1NonResourceRule> nonResourceRules, List<@Valid V1ResourceRule> resourceRules) {
        this.incomplete = incomplete;
        this.nonResourceRules = nonResourceRules;
        this.resourceRules = resourceRules;
    }

    public Boolean getIncomplete() {
        return this.incomplete;
    }

    public void setIncomplete(Boolean incomplete) {
        this.incomplete = incomplete;
    }

    public V1SubjectRulesReviewStatus incomplete(Boolean incomplete) {
        this.incomplete = incomplete;
        return this;
    }

    public List<@Valid V1NonResourceRule> getNonResourceRules() {
        return this.nonResourceRules;
    }

    public void setNonResourceRules(List<@Valid V1NonResourceRule> nonResourceRules) {
        this.nonResourceRules = nonResourceRules;
    }

    public V1SubjectRulesReviewStatus nonResourceRules(List<@Valid V1NonResourceRule> nonResourceRules) {
        this.nonResourceRules = nonResourceRules;
        return this;
    }

    public V1SubjectRulesReviewStatus addNonResourceRulesItem(V1NonResourceRule nonResourceRulesItem) {
        this.nonResourceRules.add(nonResourceRulesItem);
        return this;
    }

    public List<@Valid V1ResourceRule> getResourceRules() {
        return this.resourceRules;
    }

    public void setResourceRules(List<@Valid V1ResourceRule> resourceRules) {
        this.resourceRules = resourceRules;
    }

    public V1SubjectRulesReviewStatus resourceRules(List<@Valid V1ResourceRule> resourceRules) {
        this.resourceRules = resourceRules;
        return this;
    }

    public V1SubjectRulesReviewStatus addResourceRulesItem(V1ResourceRule resourceRulesItem) {
        this.resourceRules.add(resourceRulesItem);
        return this;
    }

    public String getEvaluationError() {
        return this.evaluationError;
    }

    public void setEvaluationError(String evaluationError) {
        this.evaluationError = evaluationError;
    }

    public V1SubjectRulesReviewStatus evaluationError(String evaluationError) {
        this.evaluationError = evaluationError;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1SubjectRulesReviewStatus v1SubjectRulesReviewStatus = (V1SubjectRulesReviewStatus)o;
        return Objects.equals(this.incomplete, v1SubjectRulesReviewStatus.incomplete) && Objects.equals(this.nonResourceRules, v1SubjectRulesReviewStatus.nonResourceRules) && Objects.equals(this.resourceRules, v1SubjectRulesReviewStatus.resourceRules) && Objects.equals(this.evaluationError, v1SubjectRulesReviewStatus.evaluationError);
    }

    public int hashCode() {
        return Objects.hash(this.incomplete, this.nonResourceRules, this.resourceRules, this.evaluationError);
    }

    public String toString() {
        return "V1SubjectRulesReviewStatus(incomplete: " + this.getIncomplete() + ", nonResourceRules: " + String.valueOf(this.getNonResourceRules()) + ", resourceRules: " + String.valueOf(this.getResourceRules()) + ", evaluationError: " + this.getEvaluationError() + ")";
    }
}

