/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.AdmissionregistrationV1WebhookClientConfig;
import io.micronaut.kubernetes.client.openapi.model.V1LabelSelector;
import io.micronaut.kubernetes.client.openapi.model.V1MatchCondition;
import io.micronaut.kubernetes.client.openapi.model.V1RuleWithOperations;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"admissionReviewVersions", "clientConfig", "name", "sideEffects", "failurePolicy", "matchConditions", "matchPolicy", "namespaceSelector", "objectSelector", "rules", "timeoutSeconds"})
public class V1ValidatingWebhook {
    public static final String JSON_PROPERTY_ADMISSION_REVIEW_VERSIONS = "admissionReviewVersions";
    public static final String JSON_PROPERTY_CLIENT_CONFIG = "clientConfig";
    public static final String JSON_PROPERTY_NAME = "name";
    public static final String JSON_PROPERTY_SIDE_EFFECTS = "sideEffects";
    public static final String JSON_PROPERTY_FAILURE_POLICY = "failurePolicy";
    public static final String JSON_PROPERTY_MATCH_CONDITIONS = "matchConditions";
    public static final String JSON_PROPERTY_MATCH_POLICY = "matchPolicy";
    public static final String JSON_PROPERTY_NAMESPACE_SELECTOR = "namespaceSelector";
    public static final String JSON_PROPERTY_OBJECT_SELECTOR = "objectSelector";
    public static final String JSON_PROPERTY_RULES = "rules";
    public static final String JSON_PROPERTY_TIMEOUT_SECONDS = "timeoutSeconds";
    @NotNull
    @JsonProperty(value="admissionReviewVersions")
    private @NotNull List<@NotNull String> admissionReviewVersions;
    @NotNull
    @Valid
    @JsonProperty(value="clientConfig")
    private AdmissionregistrationV1WebhookClientConfig clientConfig;
    @NotNull
    @JsonProperty(value="name")
    private String name;
    @NotNull
    @JsonProperty(value="sideEffects")
    private String sideEffects;
    @Nullable
    @JsonProperty(value="failurePolicy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String failurePolicy;
    @Nullable
    @JsonProperty(value="matchConditions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1MatchCondition> matchConditions;
    @Nullable
    @JsonProperty(value="matchPolicy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String matchPolicy;
    @Nullable
    @Valid
    @JsonProperty(value="namespaceSelector")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1LabelSelector namespaceSelector;
    @Nullable
    @Valid
    @JsonProperty(value="objectSelector")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1LabelSelector objectSelector;
    @Nullable
    @JsonProperty(value="rules")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1RuleWithOperations> rules;
    @Nullable
    @JsonProperty(value="timeoutSeconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Integer timeoutSeconds;

    public V1ValidatingWebhook(List<@NotNull String> admissionReviewVersions, AdmissionregistrationV1WebhookClientConfig clientConfig, String name, String sideEffects) {
        this.admissionReviewVersions = admissionReviewVersions;
        this.clientConfig = clientConfig;
        this.name = name;
        this.sideEffects = sideEffects;
    }

    public List<@NotNull String> getAdmissionReviewVersions() {
        return this.admissionReviewVersions;
    }

    public void setAdmissionReviewVersions(List<@NotNull String> admissionReviewVersions) {
        this.admissionReviewVersions = admissionReviewVersions;
    }

    public V1ValidatingWebhook admissionReviewVersions(List<@NotNull String> admissionReviewVersions) {
        this.admissionReviewVersions = admissionReviewVersions;
        return this;
    }

    public V1ValidatingWebhook addAdmissionReviewVersionsItem(String admissionReviewVersionsItem) {
        this.admissionReviewVersions.add(admissionReviewVersionsItem);
        return this;
    }

    public AdmissionregistrationV1WebhookClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public void setClientConfig(AdmissionregistrationV1WebhookClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public V1ValidatingWebhook clientConfig(AdmissionregistrationV1WebhookClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1ValidatingWebhook name(String name) {
        this.name = name;
        return this;
    }

    public String getSideEffects() {
        return this.sideEffects;
    }

    public void setSideEffects(String sideEffects) {
        this.sideEffects = sideEffects;
    }

    public V1ValidatingWebhook sideEffects(String sideEffects) {
        this.sideEffects = sideEffects;
        return this;
    }

    public String getFailurePolicy() {
        return this.failurePolicy;
    }

    public void setFailurePolicy(String failurePolicy) {
        this.failurePolicy = failurePolicy;
    }

    public V1ValidatingWebhook failurePolicy(String failurePolicy) {
        this.failurePolicy = failurePolicy;
        return this;
    }

    public List<@Valid V1MatchCondition> getMatchConditions() {
        return this.matchConditions;
    }

    public void setMatchConditions(List<@Valid V1MatchCondition> matchConditions) {
        this.matchConditions = matchConditions;
    }

    public V1ValidatingWebhook matchConditions(List<@Valid V1MatchCondition> matchConditions) {
        this.matchConditions = matchConditions;
        return this;
    }

    public V1ValidatingWebhook addMatchConditionsItem(V1MatchCondition matchConditionsItem) {
        if (this.matchConditions == null) {
            this.matchConditions = new ArrayList<V1MatchCondition>();
        }
        this.matchConditions.add(matchConditionsItem);
        return this;
    }

    public String getMatchPolicy() {
        return this.matchPolicy;
    }

    public void setMatchPolicy(String matchPolicy) {
        this.matchPolicy = matchPolicy;
    }

    public V1ValidatingWebhook matchPolicy(String matchPolicy) {
        this.matchPolicy = matchPolicy;
        return this;
    }

    public V1LabelSelector getNamespaceSelector() {
        return this.namespaceSelector;
    }

    public void setNamespaceSelector(V1LabelSelector namespaceSelector) {
        this.namespaceSelector = namespaceSelector;
    }

    public V1ValidatingWebhook namespaceSelector(V1LabelSelector namespaceSelector) {
        this.namespaceSelector = namespaceSelector;
        return this;
    }

    public V1LabelSelector getObjectSelector() {
        return this.objectSelector;
    }

    public void setObjectSelector(V1LabelSelector objectSelector) {
        this.objectSelector = objectSelector;
    }

    public V1ValidatingWebhook objectSelector(V1LabelSelector objectSelector) {
        this.objectSelector = objectSelector;
        return this;
    }

    public List<@Valid V1RuleWithOperations> getRules() {
        return this.rules;
    }

    public void setRules(List<@Valid V1RuleWithOperations> rules) {
        this.rules = rules;
    }

    public V1ValidatingWebhook rules(List<@Valid V1RuleWithOperations> rules) {
        this.rules = rules;
        return this;
    }

    public V1ValidatingWebhook addRulesItem(V1RuleWithOperations rulesItem) {
        if (this.rules == null) {
            this.rules = new ArrayList<V1RuleWithOperations>();
        }
        this.rules.add(rulesItem);
        return this;
    }

    public Integer getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public void setTimeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public V1ValidatingWebhook timeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ValidatingWebhook v1ValidatingWebhook = (V1ValidatingWebhook)o;
        return Objects.equals(this.admissionReviewVersions, v1ValidatingWebhook.admissionReviewVersions) && Objects.equals(this.clientConfig, v1ValidatingWebhook.clientConfig) && Objects.equals(this.name, v1ValidatingWebhook.name) && Objects.equals(this.sideEffects, v1ValidatingWebhook.sideEffects) && Objects.equals(this.failurePolicy, v1ValidatingWebhook.failurePolicy) && Objects.equals(this.matchConditions, v1ValidatingWebhook.matchConditions) && Objects.equals(this.matchPolicy, v1ValidatingWebhook.matchPolicy) && Objects.equals(this.namespaceSelector, v1ValidatingWebhook.namespaceSelector) && Objects.equals(this.objectSelector, v1ValidatingWebhook.objectSelector) && Objects.equals(this.rules, v1ValidatingWebhook.rules) && Objects.equals(this.timeoutSeconds, v1ValidatingWebhook.timeoutSeconds);
    }

    public int hashCode() {
        return Objects.hash(this.admissionReviewVersions, this.clientConfig, this.name, this.sideEffects, this.failurePolicy, this.matchConditions, this.matchPolicy, this.namespaceSelector, this.objectSelector, this.rules, this.timeoutSeconds);
    }

    public String toString() {
        return "V1ValidatingWebhook(admissionReviewVersions: " + String.valueOf(this.getAdmissionReviewVersions()) + ", clientConfig: " + String.valueOf(this.getClientConfig()) + ", name: " + this.getName() + ", sideEffects: " + this.getSideEffects() + ", failurePolicy: " + this.getFailurePolicy() + ", matchConditions: " + String.valueOf(this.getMatchConditions()) + ", matchPolicy: " + this.getMatchPolicy() + ", namespaceSelector: " + String.valueOf(this.getNamespaceSelector()) + ", objectSelector: " + String.valueOf(this.getObjectSelector()) + ", rules: " + String.valueOf(this.getRules()) + ", timeoutSeconds: " + this.getTimeoutSeconds() + ")";
    }
}

