/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.common.KubernetesObject;
import io.micronaut.kubernetes.client.openapi.model.V1ObjectMeta;
import io.micronaut.kubernetes.client.openapi.model.V1VolumeAttachmentSpec;
import io.micronaut.kubernetes.client.openapi.model.V1VolumeAttachmentStatus;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"spec", "apiVersion", "kind", "metadata", "status"})
public class V1VolumeAttachment
implements KubernetesObject {
    public static final String JSON_PROPERTY_SPEC = "spec";
    public static final String JSON_PROPERTY_API_VERSION = "apiVersion";
    public static final String JSON_PROPERTY_KIND = "kind";
    public static final String JSON_PROPERTY_METADATA = "metadata";
    public static final String JSON_PROPERTY_STATUS = "status";
    @NotNull
    @Valid
    @JsonProperty(value="spec")
    private V1VolumeAttachmentSpec spec;
    @Nullable
    @JsonProperty(value="apiVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String apiVersion;
    @Nullable
    @JsonProperty(value="kind")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String kind;
    @Nullable
    @Valid
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1ObjectMeta metadata;
    @Nullable
    @Valid
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1VolumeAttachmentStatus status;

    public V1VolumeAttachment(V1VolumeAttachmentSpec spec) {
        this.spec = spec;
    }

    public V1VolumeAttachmentSpec getSpec() {
        return this.spec;
    }

    public void setSpec(V1VolumeAttachmentSpec spec) {
        this.spec = spec;
    }

    public V1VolumeAttachment spec(V1VolumeAttachmentSpec spec) {
        this.spec = spec;
        return this;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1VolumeAttachment apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1VolumeAttachment kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Override
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1VolumeAttachment metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    public V1VolumeAttachmentStatus getStatus() {
        return this.status;
    }

    public void setStatus(V1VolumeAttachmentStatus status) {
        this.status = status;
    }

    public V1VolumeAttachment status(V1VolumeAttachmentStatus status) {
        this.status = status;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1VolumeAttachment v1VolumeAttachment = (V1VolumeAttachment)o;
        return Objects.equals(this.spec, v1VolumeAttachment.spec) && Objects.equals(this.apiVersion, v1VolumeAttachment.apiVersion) && Objects.equals(this.kind, v1VolumeAttachment.kind) && Objects.equals(this.metadata, v1VolumeAttachment.metadata) && Objects.equals(this.status, v1VolumeAttachment.status);
    }

    public int hashCode() {
        return Objects.hash(this.spec, this.apiVersion, this.kind, this.metadata, this.status);
    }

    public String toString() {
        return "V1VolumeAttachment(spec: " + String.valueOf(this.getSpec()) + ", apiVersion: " + this.getApiVersion() + ", kind: " + this.getKind() + ", metadata: " + String.valueOf(this.getMetadata()) + ", status: " + String.valueOf(this.getStatus()) + ")";
    }
}

