/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.resolver;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.core.util.StringUtils;
import io.micronaut.kubernetes.client.openapi.config.KubernetesClientConfiguration;
import io.micronaut.kubernetes.client.openapi.resolver.NamespaceResolver;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@BootstrapContextCompatible
@Requirements(value={@Requires(env={"k8s"}), @Requires(beans={KubernetesClientConfiguration.class})})
final class DefaultNamespaceResolver
implements NamespaceResolver {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultNamespaceResolver.class);
    public static final String DEFAULT_NAMESPACE = "default";
    private final String namespace;

    DefaultNamespaceResolver(ResourceResolver resourceResolver, KubernetesClientConfiguration kubernetesClientConfiguration) {
        String resolvedNamespace = kubernetesClientConfiguration.getNamespace();
        if (StringUtils.isEmpty((CharSequence)resolvedNamespace)) {
            String namespacePath = kubernetesClientConfiguration.getServiceAccount().getNamespacePath();
            LOG.debug("Trying to read the Kubernetes namespace from the file: {}", (Object)namespacePath);
            Optional inputStreamOpt = resourceResolver.getResourceAsStream(namespacePath);
            if (inputStreamOpt.isPresent()) {
                InputStream inputStream = (InputStream)inputStreamOpt.get();
                try {
                    resolvedNamespace = new String(inputStream.readAllBytes());
                }
                catch (IOException e) {
                    LOG.error("Failed to read '{}' file so setting the Kubernetes namespace to: {}", (Object)namespacePath, (Object)DEFAULT_NAMESPACE);
                    resolvedNamespace = DEFAULT_NAMESPACE;
                }
            } else {
                LOG.info("The Kubernetes namespace not found in configuration files and there is no '{}' file, so setting the namespace to: {}", (Object)namespacePath, (Object)DEFAULT_NAMESPACE);
                resolvedNamespace = DEFAULT_NAMESPACE;
            }
        }
        this.namespace = resolvedNamespace;
    }

    @Override
    public String resolveNamespace() {
        return this.namespace;
    }
}

