/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.ssl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.http.client.netty.ssl.NettyClientSslBuilder;
import io.micronaut.http.ssl.ClientSslConfiguration;
import io.micronaut.http.ssl.SslConfiguration;
import io.micronaut.kubernetes.client.openapi.config.KubeConfig;
import io.micronaut.kubernetes.client.openapi.config.KubernetesClientConfiguration;
import io.micronaut.kubernetes.client.openapi.config.model.AuthInfo;
import io.micronaut.kubernetes.client.openapi.config.model.Cluster;
import io.micronaut.kubernetes.client.openapi.ssl.KubernetesPrivateKeyLoader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Optional;

@Internal
public final class KubernetesClientSslBuilder
extends NettyClientSslBuilder {
    private static final String X509_CERTIFICATE_TYPE = "X509";
    private final ResourceResolver resourceResolver;
    private final KubeConfig kubeConfig;
    private final KubernetesPrivateKeyLoader kubernetesPrivateKeyLoader;
    private final KubernetesClientConfiguration kubernetesClientConfiguration;

    public KubernetesClientSslBuilder(ResourceResolver resourceResolver, KubeConfig kubeConfig, KubernetesPrivateKeyLoader kubernetesPrivateKeyLoader, KubernetesClientConfiguration kubernetesClientConfiguration) {
        super(resourceResolver);
        this.resourceResolver = resourceResolver;
        this.kubeConfig = kubeConfig;
        this.kubernetesPrivateKeyLoader = kubernetesPrivateKeyLoader;
        this.kubernetesClientConfiguration = kubernetesClientConfiguration;
    }

    protected Optional<KeyStore> getKeyStore(SslConfiguration ssl) throws Exception {
        String keyPass;
        if (this.kubeConfig == null || this.kubeConfig.getUser() == null) {
            return Optional.empty();
        }
        AuthInfo user = this.kubeConfig.getUser();
        byte[] clientCert = user.clientCertificateData();
        byte[] clientKey = user.clientKeyData();
        if (clientCert == null || clientKey == null) {
            return Optional.empty();
        }
        CertificateFactory certFactory = CertificateFactory.getInstance(X509_CERTIFICATE_TYPE);
        Collection<? extends Certificate> certs = certFactory.generateCertificates(new ByteArrayInputStream(clientCert));
        Optional keyAliasOpt = ssl.getKey().getAlias();
        String keyAlias = keyAliasOpt.isPresent() ? (String)keyAliasOpt.get() : ((X509Certificate)certs.iterator().next()).getSubjectX500Principal().getName();
        PrivateKey privateKey = this.kubernetesPrivateKeyLoader.loadPrivateKey(clientKey);
        Optional keyPassOpt = ssl.getKey().getPassword();
        Optional keyStorePassOpt = ssl.getKeyStore().getPassword();
        if (keyPassOpt.isPresent()) {
            keyPass = (String)keyPassOpt.get();
        } else if (keyStorePassOpt.isPresent()) {
            keyPass = (String)keyStorePassOpt.get();
        } else {
            keyPass = "";
            ssl.getKey().setPassword("");
        }
        KeyStore keyStore = KeyStore.getInstance(ssl.getKeyStore().getType().orElse("JKS"));
        keyStore.load(null);
        keyStore.setKeyEntry(keyAlias, privateKey, keyPass.toCharArray(), certs.toArray(new X509Certificate[0]));
        return Optional.of(keyStore);
    }

    protected Optional<KeyStore> getTrustStore(SslConfiguration ssl) throws Exception {
        byte[] caBytes = null;
        if (this.kubeConfig != null) {
            Cluster cluster = this.kubeConfig.getCluster();
            Boolean insecureSkipTlsVerify = cluster.insecureSkipTlsVerify();
            if (insecureSkipTlsVerify != null && insecureSkipTlsVerify.booleanValue()) {
                ((ClientSslConfiguration)ssl).setInsecureTrustAllCertificates(true);
                return Optional.empty();
            }
            caBytes = cluster.certificateAuthorityData();
        } else if (this.kubernetesClientConfiguration.getServiceAccount().isEnabled()) {
            String caPath = this.kubernetesClientConfiguration.getServiceAccount().getCertificateAuthorityPath();
            Optional inputStreamOpt = this.resourceResolver.getResourceAsStream(caPath);
            if (inputStreamOpt.isEmpty()) {
                return Optional.empty();
            }
            InputStream inputStream = (InputStream)inputStreamOpt.get();
            caBytes = inputStream.readAllBytes();
        }
        if (caBytes == null) {
            return Optional.empty();
        }
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        Collection<? extends Certificate> certs = certificateFactory.generateCertificates(new ByteArrayInputStream(caBytes));
        if (certs.isEmpty()) {
            throw new IllegalArgumentException("Expected non-empty set of trusted certificates");
        }
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, null);
        int i = 0;
        for (Certificate certificate : certs) {
            keyStore.setCertificateEntry("ca" + i, certificate);
            ++i;
        }
        return Optional.of(keyStore);
    }
}

