/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.api;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Delete;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Patch;
import io.micronaut.http.annotation.PathVariable;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Put;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.http.client.annotation.Client;
import io.micronaut.kubernetes.client.openapi.model.V1APIResourceList;
import io.micronaut.kubernetes.client.openapi.model.V1ControllerRevision;
import io.micronaut.kubernetes.client.openapi.model.V1ControllerRevisionList;
import io.micronaut.kubernetes.client.openapi.model.V1DaemonSet;
import io.micronaut.kubernetes.client.openapi.model.V1DaemonSetList;
import io.micronaut.kubernetes.client.openapi.model.V1DeleteOptions;
import io.micronaut.kubernetes.client.openapi.model.V1Deployment;
import io.micronaut.kubernetes.client.openapi.model.V1DeploymentList;
import io.micronaut.kubernetes.client.openapi.model.V1ReplicaSet;
import io.micronaut.kubernetes.client.openapi.model.V1ReplicaSetList;
import io.micronaut.kubernetes.client.openapi.model.V1Scale;
import io.micronaut.kubernetes.client.openapi.model.V1StatefulSet;
import io.micronaut.kubernetes.client.openapi.model.V1StatefulSetList;
import io.micronaut.kubernetes.client.openapi.model.V1Status;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;

@BootstrapContextCompatible
@Client(value="kubernetes")
public interface AppsV1Api {
    @Post(value="/apis/apps/v1/namespaces/{namespace}/controllerrevisions")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1ControllerRevision createNamespacedControllerRevision(@PathVariable(value="namespace") @NotNull String var1, @Body @NotNull @Valid V1ControllerRevision var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldManager") @Nullable String var5, @QueryValue(value="fieldValidation") @Nullable String var6);

    @Post(value="/apis/apps/v1/namespaces/{namespace}/daemonsets")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1DaemonSet createNamespacedDaemonSet(@PathVariable(value="namespace") @NotNull String var1, @Body @NotNull @Valid V1DaemonSet var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldManager") @Nullable String var5, @QueryValue(value="fieldValidation") @Nullable String var6);

    @Post(value="/apis/apps/v1/namespaces/{namespace}/deployments")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Deployment createNamespacedDeployment(@PathVariable(value="namespace") @NotNull String var1, @Body @NotNull @Valid V1Deployment var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldManager") @Nullable String var5, @QueryValue(value="fieldValidation") @Nullable String var6);

    @Post(value="/apis/apps/v1/namespaces/{namespace}/replicasets")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1ReplicaSet createNamespacedReplicaSet(@PathVariable(value="namespace") @NotNull String var1, @Body @NotNull @Valid V1ReplicaSet var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldManager") @Nullable String var5, @QueryValue(value="fieldValidation") @Nullable String var6);

    @Post(value="/apis/apps/v1/namespaces/{namespace}/statefulsets")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1StatefulSet createNamespacedStatefulSet(@PathVariable(value="namespace") @NotNull String var1, @Body @NotNull @Valid V1StatefulSet var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldManager") @Nullable String var5, @QueryValue(value="fieldValidation") @Nullable String var6);

    @Delete(value="/apis/apps/v1/namespaces/{namespace}/controllerrevisions")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Status deleteCollectionNamespacedControllerRevision(@PathVariable(value="namespace") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="continue") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldSelector") @Nullable String var5, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var6, @QueryValue(value="labelSelector") @Nullable String var7, @QueryValue(value="limit") @Nullable Integer var8, @QueryValue(value="orphanDependents") @Nullable Boolean var9, @QueryValue(value="propagationPolicy") @Nullable String var10, @QueryValue(value="resourceVersion") @Nullable String var11, @QueryValue(value="resourceVersionMatch") @Nullable String var12, @QueryValue(value="sendInitialEvents") @Nullable Boolean var13, @QueryValue(value="timeoutSeconds") @Nullable Integer var14, @Body @Nullable @Valid V1DeleteOptions var15);

    @Delete(value="/apis/apps/v1/namespaces/{namespace}/daemonsets")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Status deleteCollectionNamespacedDaemonSet(@PathVariable(value="namespace") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="continue") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldSelector") @Nullable String var5, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var6, @QueryValue(value="labelSelector") @Nullable String var7, @QueryValue(value="limit") @Nullable Integer var8, @QueryValue(value="orphanDependents") @Nullable Boolean var9, @QueryValue(value="propagationPolicy") @Nullable String var10, @QueryValue(value="resourceVersion") @Nullable String var11, @QueryValue(value="resourceVersionMatch") @Nullable String var12, @QueryValue(value="sendInitialEvents") @Nullable Boolean var13, @QueryValue(value="timeoutSeconds") @Nullable Integer var14, @Body @Nullable @Valid V1DeleteOptions var15);

    @Delete(value="/apis/apps/v1/namespaces/{namespace}/deployments")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Status deleteCollectionNamespacedDeployment(@PathVariable(value="namespace") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="continue") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldSelector") @Nullable String var5, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var6, @QueryValue(value="labelSelector") @Nullable String var7, @QueryValue(value="limit") @Nullable Integer var8, @QueryValue(value="orphanDependents") @Nullable Boolean var9, @QueryValue(value="propagationPolicy") @Nullable String var10, @QueryValue(value="resourceVersion") @Nullable String var11, @QueryValue(value="resourceVersionMatch") @Nullable String var12, @QueryValue(value="sendInitialEvents") @Nullable Boolean var13, @QueryValue(value="timeoutSeconds") @Nullable Integer var14, @Body @Nullable @Valid V1DeleteOptions var15);

    @Delete(value="/apis/apps/v1/namespaces/{namespace}/replicasets")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Status deleteCollectionNamespacedReplicaSet(@PathVariable(value="namespace") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="continue") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldSelector") @Nullable String var5, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var6, @QueryValue(value="labelSelector") @Nullable String var7, @QueryValue(value="limit") @Nullable Integer var8, @QueryValue(value="orphanDependents") @Nullable Boolean var9, @QueryValue(value="propagationPolicy") @Nullable String var10, @QueryValue(value="resourceVersion") @Nullable String var11, @QueryValue(value="resourceVersionMatch") @Nullable String var12, @QueryValue(value="sendInitialEvents") @Nullable Boolean var13, @QueryValue(value="timeoutSeconds") @Nullable Integer var14, @Body @Nullable @Valid V1DeleteOptions var15);

    @Delete(value="/apis/apps/v1/namespaces/{namespace}/statefulsets")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Status deleteCollectionNamespacedStatefulSet(@PathVariable(value="namespace") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="continue") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldSelector") @Nullable String var5, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var6, @QueryValue(value="labelSelector") @Nullable String var7, @QueryValue(value="limit") @Nullable Integer var8, @QueryValue(value="orphanDependents") @Nullable Boolean var9, @QueryValue(value="propagationPolicy") @Nullable String var10, @QueryValue(value="resourceVersion") @Nullable String var11, @QueryValue(value="resourceVersionMatch") @Nullable String var12, @QueryValue(value="sendInitialEvents") @Nullable Boolean var13, @QueryValue(value="timeoutSeconds") @Nullable Integer var14, @Body @Nullable @Valid V1DeleteOptions var15);

    @Delete(value="/apis/apps/v1/namespaces/{namespace}/controllerrevisions/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Status deleteNamespacedControllerRevision(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var5, @QueryValue(value="orphanDependents") @Nullable Boolean var6, @QueryValue(value="propagationPolicy") @Nullable String var7, @Body @Nullable @Valid V1DeleteOptions var8);

    @Delete(value="/apis/apps/v1/namespaces/{namespace}/daemonsets/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Status deleteNamespacedDaemonSet(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var5, @QueryValue(value="orphanDependents") @Nullable Boolean var6, @QueryValue(value="propagationPolicy") @Nullable String var7, @Body @Nullable @Valid V1DeleteOptions var8);

    @Delete(value="/apis/apps/v1/namespaces/{namespace}/deployments/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Status deleteNamespacedDeployment(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var5, @QueryValue(value="orphanDependents") @Nullable Boolean var6, @QueryValue(value="propagationPolicy") @Nullable String var7, @Body @Nullable @Valid V1DeleteOptions var8);

    @Delete(value="/apis/apps/v1/namespaces/{namespace}/replicasets/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Status deleteNamespacedReplicaSet(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var5, @QueryValue(value="orphanDependents") @Nullable Boolean var6, @QueryValue(value="propagationPolicy") @Nullable String var7, @Body @Nullable @Valid V1DeleteOptions var8);

    @Delete(value="/apis/apps/v1/namespaces/{namespace}/statefulsets/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Status deleteNamespacedStatefulSet(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var5, @QueryValue(value="orphanDependents") @Nullable Boolean var6, @QueryValue(value="propagationPolicy") @Nullable String var7, @Body @Nullable @Valid V1DeleteOptions var8);

    @Get(value="/apis/apps/v1/")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1APIResourceList getAPIResources();

    @Get(value="/apis/apps/v1/controllerrevisions")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})
    public V1ControllerRevisionList listControllerRevisionForAllNamespaces(@QueryValue(value="allowWatchBookmarks") @Nullable Boolean var1, @QueryValue(value="continue") @Nullable String var2, @QueryValue(value="fieldSelector") @Nullable String var3, @QueryValue(value="labelSelector") @Nullable String var4, @QueryValue(value="limit") @Nullable Integer var5, @QueryValue(value="pretty") @Nullable String var6, @QueryValue(value="resourceVersion") @Nullable String var7, @QueryValue(value="resourceVersionMatch") @Nullable String var8, @QueryValue(value="sendInitialEvents") @Nullable Boolean var9, @QueryValue(value="timeoutSeconds") @Nullable Integer var10, @QueryValue(value="watch") @Nullable Boolean var11);

    @Get(value="/apis/apps/v1/daemonsets")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})
    public V1DaemonSetList listDaemonSetForAllNamespaces(@QueryValue(value="allowWatchBookmarks") @Nullable Boolean var1, @QueryValue(value="continue") @Nullable String var2, @QueryValue(value="fieldSelector") @Nullable String var3, @QueryValue(value="labelSelector") @Nullable String var4, @QueryValue(value="limit") @Nullable Integer var5, @QueryValue(value="pretty") @Nullable String var6, @QueryValue(value="resourceVersion") @Nullable String var7, @QueryValue(value="resourceVersionMatch") @Nullable String var8, @QueryValue(value="sendInitialEvents") @Nullable Boolean var9, @QueryValue(value="timeoutSeconds") @Nullable Integer var10, @QueryValue(value="watch") @Nullable Boolean var11);

    @Get(value="/apis/apps/v1/deployments")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})
    public V1DeploymentList listDeploymentForAllNamespaces(@QueryValue(value="allowWatchBookmarks") @Nullable Boolean var1, @QueryValue(value="continue") @Nullable String var2, @QueryValue(value="fieldSelector") @Nullable String var3, @QueryValue(value="labelSelector") @Nullable String var4, @QueryValue(value="limit") @Nullable Integer var5, @QueryValue(value="pretty") @Nullable String var6, @QueryValue(value="resourceVersion") @Nullable String var7, @QueryValue(value="resourceVersionMatch") @Nullable String var8, @QueryValue(value="sendInitialEvents") @Nullable Boolean var9, @QueryValue(value="timeoutSeconds") @Nullable Integer var10, @QueryValue(value="watch") @Nullable Boolean var11);

    @Get(value="/apis/apps/v1/namespaces/{namespace}/controllerrevisions")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})
    public V1ControllerRevisionList listNamespacedControllerRevision(@PathVariable(value="namespace") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="allowWatchBookmarks") @Nullable Boolean var3, @QueryValue(value="continue") @Nullable String var4, @QueryValue(value="fieldSelector") @Nullable String var5, @QueryValue(value="labelSelector") @Nullable String var6, @QueryValue(value="limit") @Nullable Integer var7, @QueryValue(value="resourceVersion") @Nullable String var8, @QueryValue(value="resourceVersionMatch") @Nullable String var9, @QueryValue(value="sendInitialEvents") @Nullable Boolean var10, @QueryValue(value="timeoutSeconds") @Nullable Integer var11, @QueryValue(value="watch") @Nullable Boolean var12);

    @Get(value="/apis/apps/v1/namespaces/{namespace}/daemonsets")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})
    public V1DaemonSetList listNamespacedDaemonSet(@PathVariable(value="namespace") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="allowWatchBookmarks") @Nullable Boolean var3, @QueryValue(value="continue") @Nullable String var4, @QueryValue(value="fieldSelector") @Nullable String var5, @QueryValue(value="labelSelector") @Nullable String var6, @QueryValue(value="limit") @Nullable Integer var7, @QueryValue(value="resourceVersion") @Nullable String var8, @QueryValue(value="resourceVersionMatch") @Nullable String var9, @QueryValue(value="sendInitialEvents") @Nullable Boolean var10, @QueryValue(value="timeoutSeconds") @Nullable Integer var11, @QueryValue(value="watch") @Nullable Boolean var12);

    @Get(value="/apis/apps/v1/namespaces/{namespace}/deployments")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})
    public V1DeploymentList listNamespacedDeployment(@PathVariable(value="namespace") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="allowWatchBookmarks") @Nullable Boolean var3, @QueryValue(value="continue") @Nullable String var4, @QueryValue(value="fieldSelector") @Nullable String var5, @QueryValue(value="labelSelector") @Nullable String var6, @QueryValue(value="limit") @Nullable Integer var7, @QueryValue(value="resourceVersion") @Nullable String var8, @QueryValue(value="resourceVersionMatch") @Nullable String var9, @QueryValue(value="sendInitialEvents") @Nullable Boolean var10, @QueryValue(value="timeoutSeconds") @Nullable Integer var11, @QueryValue(value="watch") @Nullable Boolean var12);

    @Get(value="/apis/apps/v1/namespaces/{namespace}/replicasets")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})
    public V1ReplicaSetList listNamespacedReplicaSet(@PathVariable(value="namespace") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="allowWatchBookmarks") @Nullable Boolean var3, @QueryValue(value="continue") @Nullable String var4, @QueryValue(value="fieldSelector") @Nullable String var5, @QueryValue(value="labelSelector") @Nullable String var6, @QueryValue(value="limit") @Nullable Integer var7, @QueryValue(value="resourceVersion") @Nullable String var8, @QueryValue(value="resourceVersionMatch") @Nullable String var9, @QueryValue(value="sendInitialEvents") @Nullable Boolean var10, @QueryValue(value="timeoutSeconds") @Nullable Integer var11, @QueryValue(value="watch") @Nullable Boolean var12);

    @Get(value="/apis/apps/v1/namespaces/{namespace}/statefulsets")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})
    public V1StatefulSetList listNamespacedStatefulSet(@PathVariable(value="namespace") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="allowWatchBookmarks") @Nullable Boolean var3, @QueryValue(value="continue") @Nullable String var4, @QueryValue(value="fieldSelector") @Nullable String var5, @QueryValue(value="labelSelector") @Nullable String var6, @QueryValue(value="limit") @Nullable Integer var7, @QueryValue(value="resourceVersion") @Nullable String var8, @QueryValue(value="resourceVersionMatch") @Nullable String var9, @QueryValue(value="sendInitialEvents") @Nullable Boolean var10, @QueryValue(value="timeoutSeconds") @Nullable Integer var11, @QueryValue(value="watch") @Nullable Boolean var12);

    @Get(value="/apis/apps/v1/replicasets")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})
    public V1ReplicaSetList listReplicaSetForAllNamespaces(@QueryValue(value="allowWatchBookmarks") @Nullable Boolean var1, @QueryValue(value="continue") @Nullable String var2, @QueryValue(value="fieldSelector") @Nullable String var3, @QueryValue(value="labelSelector") @Nullable String var4, @QueryValue(value="limit") @Nullable Integer var5, @QueryValue(value="pretty") @Nullable String var6, @QueryValue(value="resourceVersion") @Nullable String var7, @QueryValue(value="resourceVersionMatch") @Nullable String var8, @QueryValue(value="sendInitialEvents") @Nullable Boolean var9, @QueryValue(value="timeoutSeconds") @Nullable Integer var10, @QueryValue(value="watch") @Nullable Boolean var11);

    @Get(value="/apis/apps/v1/statefulsets")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})
    public V1StatefulSetList listStatefulSetForAllNamespaces(@QueryValue(value="allowWatchBookmarks") @Nullable Boolean var1, @QueryValue(value="continue") @Nullable String var2, @QueryValue(value="fieldSelector") @Nullable String var3, @QueryValue(value="labelSelector") @Nullable String var4, @QueryValue(value="limit") @Nullable Integer var5, @QueryValue(value="pretty") @Nullable String var6, @QueryValue(value="resourceVersion") @Nullable String var7, @QueryValue(value="resourceVersionMatch") @Nullable String var8, @QueryValue(value="sendInitialEvents") @Nullable Boolean var9, @QueryValue(value="timeoutSeconds") @Nullable Integer var10, @QueryValue(value="watch") @Nullable Boolean var11);

    @Patch(value="/apis/apps/v1/namespaces/{namespace}/controllerrevisions/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1ControllerRevision patchNamespacedControllerRevision(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull String var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7, @QueryValue(value="force") @Nullable Boolean var8);

    @Patch(value="/apis/apps/v1/namespaces/{namespace}/daemonsets/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1DaemonSet patchNamespacedDaemonSet(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull String var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7, @QueryValue(value="force") @Nullable Boolean var8);

    @Patch(value="/apis/apps/v1/namespaces/{namespace}/daemonsets/{name}/status")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1DaemonSet patchNamespacedDaemonSetStatus(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull String var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7, @QueryValue(value="force") @Nullable Boolean var8);

    @Patch(value="/apis/apps/v1/namespaces/{namespace}/deployments/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Deployment patchNamespacedDeployment(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull String var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7, @QueryValue(value="force") @Nullable Boolean var8);

    @Patch(value="/apis/apps/v1/namespaces/{namespace}/deployments/{name}/scale")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Scale patchNamespacedDeploymentScale(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull String var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7, @QueryValue(value="force") @Nullable Boolean var8);

    @Patch(value="/apis/apps/v1/namespaces/{namespace}/deployments/{name}/status")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Deployment patchNamespacedDeploymentStatus(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull String var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7, @QueryValue(value="force") @Nullable Boolean var8);

    @Patch(value="/apis/apps/v1/namespaces/{namespace}/replicasets/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1ReplicaSet patchNamespacedReplicaSet(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull String var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7, @QueryValue(value="force") @Nullable Boolean var8);

    @Patch(value="/apis/apps/v1/namespaces/{namespace}/replicasets/{name}/scale")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Scale patchNamespacedReplicaSetScale(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull String var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7, @QueryValue(value="force") @Nullable Boolean var8);

    @Patch(value="/apis/apps/v1/namespaces/{namespace}/replicasets/{name}/status")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1ReplicaSet patchNamespacedReplicaSetStatus(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull String var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7, @QueryValue(value="force") @Nullable Boolean var8);

    @Patch(value="/apis/apps/v1/namespaces/{namespace}/statefulsets/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1StatefulSet patchNamespacedStatefulSet(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull String var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7, @QueryValue(value="force") @Nullable Boolean var8);

    @Patch(value="/apis/apps/v1/namespaces/{namespace}/statefulsets/{name}/scale")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Scale patchNamespacedStatefulSetScale(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull String var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7, @QueryValue(value="force") @Nullable Boolean var8);

    @Patch(value="/apis/apps/v1/namespaces/{namespace}/statefulsets/{name}/status")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1StatefulSet patchNamespacedStatefulSetStatus(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull String var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7, @QueryValue(value="force") @Nullable Boolean var8);

    @Get(value="/apis/apps/v1/namespaces/{namespace}/controllerrevisions/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1ControllerRevision readNamespacedControllerRevision(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3);

    @Get(value="/apis/apps/v1/namespaces/{namespace}/daemonsets/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1DaemonSet readNamespacedDaemonSet(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3);

    @Get(value="/apis/apps/v1/namespaces/{namespace}/daemonsets/{name}/status")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1DaemonSet readNamespacedDaemonSetStatus(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3);

    @Get(value="/apis/apps/v1/namespaces/{namespace}/deployments/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Deployment readNamespacedDeployment(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3);

    @Get(value="/apis/apps/v1/namespaces/{namespace}/deployments/{name}/scale")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Scale readNamespacedDeploymentScale(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3);

    @Get(value="/apis/apps/v1/namespaces/{namespace}/deployments/{name}/status")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Deployment readNamespacedDeploymentStatus(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3);

    @Get(value="/apis/apps/v1/namespaces/{namespace}/replicasets/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1ReplicaSet readNamespacedReplicaSet(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3);

    @Get(value="/apis/apps/v1/namespaces/{namespace}/replicasets/{name}/scale")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Scale readNamespacedReplicaSetScale(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3);

    @Get(value="/apis/apps/v1/namespaces/{namespace}/replicasets/{name}/status")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1ReplicaSet readNamespacedReplicaSetStatus(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3);

    @Get(value="/apis/apps/v1/namespaces/{namespace}/statefulsets/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1StatefulSet readNamespacedStatefulSet(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3);

    @Get(value="/apis/apps/v1/namespaces/{namespace}/statefulsets/{name}/scale")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Scale readNamespacedStatefulSetScale(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3);

    @Get(value="/apis/apps/v1/namespaces/{namespace}/statefulsets/{name}/status")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1StatefulSet readNamespacedStatefulSetStatus(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3);

    @Put(value="/apis/apps/v1/namespaces/{namespace}/controllerrevisions/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1ControllerRevision replaceNamespacedControllerRevision(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull @Valid V1ControllerRevision var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7);

    @Put(value="/apis/apps/v1/namespaces/{namespace}/daemonsets/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1DaemonSet replaceNamespacedDaemonSet(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull @Valid V1DaemonSet var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7);

    @Put(value="/apis/apps/v1/namespaces/{namespace}/daemonsets/{name}/status")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1DaemonSet replaceNamespacedDaemonSetStatus(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull @Valid V1DaemonSet var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7);

    @Put(value="/apis/apps/v1/namespaces/{namespace}/deployments/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Deployment replaceNamespacedDeployment(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull @Valid V1Deployment var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7);

    @Put(value="/apis/apps/v1/namespaces/{namespace}/deployments/{name}/scale")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Scale replaceNamespacedDeploymentScale(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull @Valid V1Scale var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7);

    @Put(value="/apis/apps/v1/namespaces/{namespace}/deployments/{name}/status")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Deployment replaceNamespacedDeploymentStatus(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull @Valid V1Deployment var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7);

    @Put(value="/apis/apps/v1/namespaces/{namespace}/replicasets/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1ReplicaSet replaceNamespacedReplicaSet(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull @Valid V1ReplicaSet var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7);

    @Put(value="/apis/apps/v1/namespaces/{namespace}/replicasets/{name}/scale")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Scale replaceNamespacedReplicaSetScale(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull @Valid V1Scale var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7);

    @Put(value="/apis/apps/v1/namespaces/{namespace}/replicasets/{name}/status")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1ReplicaSet replaceNamespacedReplicaSetStatus(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull @Valid V1ReplicaSet var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7);

    @Put(value="/apis/apps/v1/namespaces/{namespace}/statefulsets/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1StatefulSet replaceNamespacedStatefulSet(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull @Valid V1StatefulSet var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7);

    @Put(value="/apis/apps/v1/namespaces/{namespace}/statefulsets/{name}/scale")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Scale replaceNamespacedStatefulSetScale(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull @Valid V1Scale var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7);

    @Put(value="/apis/apps/v1/namespaces/{namespace}/statefulsets/{name}/status")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1StatefulSet replaceNamespacedStatefulSetStatus(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull @Valid V1StatefulSet var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7);
}

