/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.api;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Delete;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Patch;
import io.micronaut.http.annotation.PathVariable;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Put;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.http.client.annotation.Client;
import io.micronaut.kubernetes.client.openapi.model.V1APIResourceList;
import io.micronaut.kubernetes.client.openapi.model.V1DeleteOptions;
import io.micronaut.kubernetes.client.openapi.model.V1HorizontalPodAutoscaler;
import io.micronaut.kubernetes.client.openapi.model.V1HorizontalPodAutoscalerList;
import io.micronaut.kubernetes.client.openapi.model.V1Status;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;

@BootstrapContextCompatible
@Client(value="kubernetes")
public interface AutoscalingV1Api {
    @Post(value="/apis/autoscaling/v1/namespaces/{namespace}/horizontalpodautoscalers")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1HorizontalPodAutoscaler createNamespacedHorizontalPodAutoscaler(@PathVariable(value="namespace") @NotNull String var1, @Body @NotNull @Valid V1HorizontalPodAutoscaler var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldManager") @Nullable String var5, @QueryValue(value="fieldValidation") @Nullable String var6);

    @Delete(value="/apis/autoscaling/v1/namespaces/{namespace}/horizontalpodautoscalers")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Status deleteCollectionNamespacedHorizontalPodAutoscaler(@PathVariable(value="namespace") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="continue") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldSelector") @Nullable String var5, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var6, @QueryValue(value="labelSelector") @Nullable String var7, @QueryValue(value="limit") @Nullable Integer var8, @QueryValue(value="orphanDependents") @Nullable Boolean var9, @QueryValue(value="propagationPolicy") @Nullable String var10, @QueryValue(value="resourceVersion") @Nullable String var11, @QueryValue(value="resourceVersionMatch") @Nullable String var12, @QueryValue(value="sendInitialEvents") @Nullable Boolean var13, @QueryValue(value="timeoutSeconds") @Nullable Integer var14, @Body @Nullable @Valid V1DeleteOptions var15);

    @Delete(value="/apis/autoscaling/v1/namespaces/{namespace}/horizontalpodautoscalers/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Status deleteNamespacedHorizontalPodAutoscaler(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var5, @QueryValue(value="orphanDependents") @Nullable Boolean var6, @QueryValue(value="propagationPolicy") @Nullable String var7, @Body @Nullable @Valid V1DeleteOptions var8);

    @Get(value="/apis/autoscaling/v1/")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1APIResourceList getAPIResources();

    @Get(value="/apis/autoscaling/v1/horizontalpodautoscalers")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})
    public V1HorizontalPodAutoscalerList listHorizontalPodAutoscalerForAllNamespaces(@QueryValue(value="allowWatchBookmarks") @Nullable Boolean var1, @QueryValue(value="continue") @Nullable String var2, @QueryValue(value="fieldSelector") @Nullable String var3, @QueryValue(value="labelSelector") @Nullable String var4, @QueryValue(value="limit") @Nullable Integer var5, @QueryValue(value="pretty") @Nullable String var6, @QueryValue(value="resourceVersion") @Nullable String var7, @QueryValue(value="resourceVersionMatch") @Nullable String var8, @QueryValue(value="sendInitialEvents") @Nullable Boolean var9, @QueryValue(value="timeoutSeconds") @Nullable Integer var10, @QueryValue(value="watch") @Nullable Boolean var11);

    @Get(value="/apis/autoscaling/v1/namespaces/{namespace}/horizontalpodautoscalers")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})
    public V1HorizontalPodAutoscalerList listNamespacedHorizontalPodAutoscaler(@PathVariable(value="namespace") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="allowWatchBookmarks") @Nullable Boolean var3, @QueryValue(value="continue") @Nullable String var4, @QueryValue(value="fieldSelector") @Nullable String var5, @QueryValue(value="labelSelector") @Nullable String var6, @QueryValue(value="limit") @Nullable Integer var7, @QueryValue(value="resourceVersion") @Nullable String var8, @QueryValue(value="resourceVersionMatch") @Nullable String var9, @QueryValue(value="sendInitialEvents") @Nullable Boolean var10, @QueryValue(value="timeoutSeconds") @Nullable Integer var11, @QueryValue(value="watch") @Nullable Boolean var12);

    @Patch(value="/apis/autoscaling/v1/namespaces/{namespace}/horizontalpodautoscalers/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1HorizontalPodAutoscaler patchNamespacedHorizontalPodAutoscaler(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull String var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7, @QueryValue(value="force") @Nullable Boolean var8);

    @Patch(value="/apis/autoscaling/v1/namespaces/{namespace}/horizontalpodautoscalers/{name}/status")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1HorizontalPodAutoscaler patchNamespacedHorizontalPodAutoscalerStatus(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull String var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7, @QueryValue(value="force") @Nullable Boolean var8);

    @Get(value="/apis/autoscaling/v1/namespaces/{namespace}/horizontalpodautoscalers/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1HorizontalPodAutoscaler readNamespacedHorizontalPodAutoscaler(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3);

    @Get(value="/apis/autoscaling/v1/namespaces/{namespace}/horizontalpodautoscalers/{name}/status")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1HorizontalPodAutoscaler readNamespacedHorizontalPodAutoscalerStatus(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3);

    @Put(value="/apis/autoscaling/v1/namespaces/{namespace}/horizontalpodautoscalers/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1HorizontalPodAutoscaler replaceNamespacedHorizontalPodAutoscaler(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull @Valid V1HorizontalPodAutoscaler var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7);

    @Put(value="/apis/autoscaling/v1/namespaces/{namespace}/horizontalpodautoscalers/{name}/status")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1HorizontalPodAutoscaler replaceNamespacedHorizontalPodAutoscalerStatus(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull @Valid V1HorizontalPodAutoscaler var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7);
}

