/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.api;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Delete;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Patch;
import io.micronaut.http.annotation.PathVariable;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Put;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.http.client.annotation.Client;
import io.micronaut.kubernetes.client.openapi.model.V1APIResourceList;
import io.micronaut.kubernetes.client.openapi.model.V1CronJob;
import io.micronaut.kubernetes.client.openapi.model.V1CronJobList;
import io.micronaut.kubernetes.client.openapi.model.V1DeleteOptions;
import io.micronaut.kubernetes.client.openapi.model.V1Job;
import io.micronaut.kubernetes.client.openapi.model.V1JobList;
import io.micronaut.kubernetes.client.openapi.model.V1Status;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;

@BootstrapContextCompatible
@Client(value="kubernetes")
public interface BatchV1Api {
    @Post(value="/apis/batch/v1/namespaces/{namespace}/cronjobs")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1CronJob createNamespacedCronJob(@PathVariable(value="namespace") @NotNull String var1, @Body @NotNull @Valid V1CronJob var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldManager") @Nullable String var5, @QueryValue(value="fieldValidation") @Nullable String var6);

    @Post(value="/apis/batch/v1/namespaces/{namespace}/jobs")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Job createNamespacedJob(@PathVariable(value="namespace") @NotNull String var1, @Body @NotNull @Valid V1Job var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldManager") @Nullable String var5, @QueryValue(value="fieldValidation") @Nullable String var6);

    @Delete(value="/apis/batch/v1/namespaces/{namespace}/cronjobs")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Status deleteCollectionNamespacedCronJob(@PathVariable(value="namespace") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="continue") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldSelector") @Nullable String var5, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var6, @QueryValue(value="labelSelector") @Nullable String var7, @QueryValue(value="limit") @Nullable Integer var8, @QueryValue(value="orphanDependents") @Nullable Boolean var9, @QueryValue(value="propagationPolicy") @Nullable String var10, @QueryValue(value="resourceVersion") @Nullable String var11, @QueryValue(value="resourceVersionMatch") @Nullable String var12, @QueryValue(value="sendInitialEvents") @Nullable Boolean var13, @QueryValue(value="timeoutSeconds") @Nullable Integer var14, @Body @Nullable @Valid V1DeleteOptions var15);

    @Delete(value="/apis/batch/v1/namespaces/{namespace}/jobs")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Status deleteCollectionNamespacedJob(@PathVariable(value="namespace") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="continue") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldSelector") @Nullable String var5, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var6, @QueryValue(value="labelSelector") @Nullable String var7, @QueryValue(value="limit") @Nullable Integer var8, @QueryValue(value="orphanDependents") @Nullable Boolean var9, @QueryValue(value="propagationPolicy") @Nullable String var10, @QueryValue(value="resourceVersion") @Nullable String var11, @QueryValue(value="resourceVersionMatch") @Nullable String var12, @QueryValue(value="sendInitialEvents") @Nullable Boolean var13, @QueryValue(value="timeoutSeconds") @Nullable Integer var14, @Body @Nullable @Valid V1DeleteOptions var15);

    @Delete(value="/apis/batch/v1/namespaces/{namespace}/cronjobs/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Status deleteNamespacedCronJob(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var5, @QueryValue(value="orphanDependents") @Nullable Boolean var6, @QueryValue(value="propagationPolicy") @Nullable String var7, @Body @Nullable @Valid V1DeleteOptions var8);

    @Delete(value="/apis/batch/v1/namespaces/{namespace}/jobs/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Status deleteNamespacedJob(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var5, @QueryValue(value="orphanDependents") @Nullable Boolean var6, @QueryValue(value="propagationPolicy") @Nullable String var7, @Body @Nullable @Valid V1DeleteOptions var8);

    @Get(value="/apis/batch/v1/")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1APIResourceList getAPIResources();

    @Get(value="/apis/batch/v1/cronjobs")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})
    public V1CronJobList listCronJobForAllNamespaces(@QueryValue(value="allowWatchBookmarks") @Nullable Boolean var1, @QueryValue(value="continue") @Nullable String var2, @QueryValue(value="fieldSelector") @Nullable String var3, @QueryValue(value="labelSelector") @Nullable String var4, @QueryValue(value="limit") @Nullable Integer var5, @QueryValue(value="pretty") @Nullable String var6, @QueryValue(value="resourceVersion") @Nullable String var7, @QueryValue(value="resourceVersionMatch") @Nullable String var8, @QueryValue(value="sendInitialEvents") @Nullable Boolean var9, @QueryValue(value="timeoutSeconds") @Nullable Integer var10, @QueryValue(value="watch") @Nullable Boolean var11);

    @Get(value="/apis/batch/v1/jobs")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})
    public V1JobList listJobForAllNamespaces(@QueryValue(value="allowWatchBookmarks") @Nullable Boolean var1, @QueryValue(value="continue") @Nullable String var2, @QueryValue(value="fieldSelector") @Nullable String var3, @QueryValue(value="labelSelector") @Nullable String var4, @QueryValue(value="limit") @Nullable Integer var5, @QueryValue(value="pretty") @Nullable String var6, @QueryValue(value="resourceVersion") @Nullable String var7, @QueryValue(value="resourceVersionMatch") @Nullable String var8, @QueryValue(value="sendInitialEvents") @Nullable Boolean var9, @QueryValue(value="timeoutSeconds") @Nullable Integer var10, @QueryValue(value="watch") @Nullable Boolean var11);

    @Get(value="/apis/batch/v1/namespaces/{namespace}/cronjobs")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})
    public V1CronJobList listNamespacedCronJob(@PathVariable(value="namespace") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="allowWatchBookmarks") @Nullable Boolean var3, @QueryValue(value="continue") @Nullable String var4, @QueryValue(value="fieldSelector") @Nullable String var5, @QueryValue(value="labelSelector") @Nullable String var6, @QueryValue(value="limit") @Nullable Integer var7, @QueryValue(value="resourceVersion") @Nullable String var8, @QueryValue(value="resourceVersionMatch") @Nullable String var9, @QueryValue(value="sendInitialEvents") @Nullable Boolean var10, @QueryValue(value="timeoutSeconds") @Nullable Integer var11, @QueryValue(value="watch") @Nullable Boolean var12);

    @Get(value="/apis/batch/v1/namespaces/{namespace}/jobs")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})
    public V1JobList listNamespacedJob(@PathVariable(value="namespace") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="allowWatchBookmarks") @Nullable Boolean var3, @QueryValue(value="continue") @Nullable String var4, @QueryValue(value="fieldSelector") @Nullable String var5, @QueryValue(value="labelSelector") @Nullable String var6, @QueryValue(value="limit") @Nullable Integer var7, @QueryValue(value="resourceVersion") @Nullable String var8, @QueryValue(value="resourceVersionMatch") @Nullable String var9, @QueryValue(value="sendInitialEvents") @Nullable Boolean var10, @QueryValue(value="timeoutSeconds") @Nullable Integer var11, @QueryValue(value="watch") @Nullable Boolean var12);

    @Patch(value="/apis/batch/v1/namespaces/{namespace}/cronjobs/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1CronJob patchNamespacedCronJob(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull String var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7, @QueryValue(value="force") @Nullable Boolean var8);

    @Patch(value="/apis/batch/v1/namespaces/{namespace}/cronjobs/{name}/status")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1CronJob patchNamespacedCronJobStatus(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull String var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7, @QueryValue(value="force") @Nullable Boolean var8);

    @Patch(value="/apis/batch/v1/namespaces/{namespace}/jobs/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Job patchNamespacedJob(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull String var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7, @QueryValue(value="force") @Nullable Boolean var8);

    @Patch(value="/apis/batch/v1/namespaces/{namespace}/jobs/{name}/status")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Job patchNamespacedJobStatus(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull String var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7, @QueryValue(value="force") @Nullable Boolean var8);

    @Get(value="/apis/batch/v1/namespaces/{namespace}/cronjobs/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1CronJob readNamespacedCronJob(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3);

    @Get(value="/apis/batch/v1/namespaces/{namespace}/cronjobs/{name}/status")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1CronJob readNamespacedCronJobStatus(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3);

    @Get(value="/apis/batch/v1/namespaces/{namespace}/jobs/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Job readNamespacedJob(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3);

    @Get(value="/apis/batch/v1/namespaces/{namespace}/jobs/{name}/status")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Job readNamespacedJobStatus(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3);

    @Put(value="/apis/batch/v1/namespaces/{namespace}/cronjobs/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1CronJob replaceNamespacedCronJob(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull @Valid V1CronJob var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7);

    @Put(value="/apis/batch/v1/namespaces/{namespace}/cronjobs/{name}/status")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1CronJob replaceNamespacedCronJobStatus(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull @Valid V1CronJob var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7);

    @Put(value="/apis/batch/v1/namespaces/{namespace}/jobs/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Job replaceNamespacedJob(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull @Valid V1Job var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7);

    @Put(value="/apis/batch/v1/namespaces/{namespace}/jobs/{name}/status")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Job replaceNamespacedJobStatus(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull @Valid V1Job var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7);
}

