/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.api;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Delete;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Patch;
import io.micronaut.http.annotation.PathVariable;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Put;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.http.client.annotation.Client;
import io.micronaut.kubernetes.client.openapi.model.V1APIResourceList;
import io.micronaut.kubernetes.client.openapi.model.V1DeleteOptions;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;

@BootstrapContextCompatible
@Client(value="kubernetes")
public interface CustomObjectsApi {
    @Post(value="/apis/{group}/{version}/{plural}")
    public Object createClusterCustomObject(@PathVariable(value="group") @NotNull String var1, @PathVariable(value="version") @NotNull String var2, @PathVariable(value="plural") @NotNull String var3, @Body @NotNull Object var4, @QueryValue(value="pretty") @Nullable String var5, @QueryValue(value="dryRun") @Nullable String var6, @QueryValue(value="fieldManager") @Nullable String var7, @QueryValue(value="fieldValidation") @Nullable String var8);

    @Post(value="/apis/{group}/{version}/namespaces/{namespace}/{plural}")
    public Object createNamespacedCustomObject(@PathVariable(value="group") @NotNull String var1, @PathVariable(value="version") @NotNull String var2, @PathVariable(value="namespace") @NotNull String var3, @PathVariable(value="plural") @NotNull String var4, @Body @NotNull Object var5, @QueryValue(value="pretty") @Nullable String var6, @QueryValue(value="dryRun") @Nullable String var7, @QueryValue(value="fieldManager") @Nullable String var8, @QueryValue(value="fieldValidation") @Nullable String var9);

    @Delete(value="/apis/{group}/{version}/{plural}/{name}")
    public Object deleteClusterCustomObject(@PathVariable(value="group") @NotNull String var1, @PathVariable(value="version") @NotNull String var2, @PathVariable(value="plural") @NotNull String var3, @PathVariable(value="name") @NotNull String var4, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var5, @QueryValue(value="orphanDependents") @Nullable Boolean var6, @QueryValue(value="propagationPolicy") @Nullable String var7, @QueryValue(value="dryRun") @Nullable String var8, @Body @Nullable @Valid V1DeleteOptions var9);

    @Delete(value="/apis/{group}/{version}/{plural}")
    public Object deleteCollectionClusterCustomObject(@PathVariable(value="group") @NotNull String var1, @PathVariable(value="version") @NotNull String var2, @PathVariable(value="plural") @NotNull String var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="labelSelector") @Nullable String var5, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var6, @QueryValue(value="orphanDependents") @Nullable Boolean var7, @QueryValue(value="propagationPolicy") @Nullable String var8, @QueryValue(value="dryRun") @Nullable String var9, @Body @Nullable @Valid V1DeleteOptions var10);

    @Delete(value="/apis/{group}/{version}/namespaces/{namespace}/{plural}")
    public Object deleteCollectionNamespacedCustomObject(@PathVariable(value="group") @NotNull String var1, @PathVariable(value="version") @NotNull String var2, @PathVariable(value="namespace") @NotNull String var3, @PathVariable(value="plural") @NotNull String var4, @QueryValue(value="pretty") @Nullable String var5, @QueryValue(value="labelSelector") @Nullable String var6, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var7, @QueryValue(value="orphanDependents") @Nullable Boolean var8, @QueryValue(value="propagationPolicy") @Nullable String var9, @QueryValue(value="dryRun") @Nullable String var10, @QueryValue(value="fieldSelector") @Nullable String var11, @Body @Nullable @Valid V1DeleteOptions var12);

    @Delete(value="/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}")
    public Object deleteNamespacedCustomObject(@PathVariable(value="group") @NotNull String var1, @PathVariable(value="version") @NotNull String var2, @PathVariable(value="namespace") @NotNull String var3, @PathVariable(value="plural") @NotNull String var4, @PathVariable(value="name") @NotNull String var5, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var6, @QueryValue(value="orphanDependents") @Nullable Boolean var7, @QueryValue(value="propagationPolicy") @Nullable String var8, @QueryValue(value="dryRun") @Nullable String var9, @Body @Nullable @Valid V1DeleteOptions var10);

    @Get(value="/apis/{group}/{version}")
    public V1APIResourceList getAPIResources(@PathVariable(value="group") @NotNull String var1, @PathVariable(value="version") @NotNull String var2);

    @Get(value="/apis/{group}/{version}/{plural}/{name}")
    public Object getClusterCustomObject(@PathVariable(value="group") @NotNull String var1, @PathVariable(value="version") @NotNull String var2, @PathVariable(value="plural") @NotNull String var3, @PathVariable(value="name") @NotNull String var4);

    @Get(value="/apis/{group}/{version}/{plural}/{name}/scale")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public Object getClusterCustomObjectScale(@PathVariable(value="group") @NotNull String var1, @PathVariable(value="version") @NotNull String var2, @PathVariable(value="plural") @NotNull String var3, @PathVariable(value="name") @NotNull String var4);

    @Get(value="/apis/{group}/{version}/{plural}/{name}/status")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public Object getClusterCustomObjectStatus(@PathVariable(value="group") @NotNull String var1, @PathVariable(value="version") @NotNull String var2, @PathVariable(value="plural") @NotNull String var3, @PathVariable(value="name") @NotNull String var4);

    @Get(value="/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}")
    public Object getNamespacedCustomObject(@PathVariable(value="group") @NotNull String var1, @PathVariable(value="version") @NotNull String var2, @PathVariable(value="namespace") @NotNull String var3, @PathVariable(value="plural") @NotNull String var4, @PathVariable(value="name") @NotNull String var5);

    @Get(value="/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/scale")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public Object getNamespacedCustomObjectScale(@PathVariable(value="group") @NotNull String var1, @PathVariable(value="version") @NotNull String var2, @PathVariable(value="namespace") @NotNull String var3, @PathVariable(value="plural") @NotNull String var4, @PathVariable(value="name") @NotNull String var5);

    @Get(value="/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/status")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public Object getNamespacedCustomObjectStatus(@PathVariable(value="group") @NotNull String var1, @PathVariable(value="version") @NotNull String var2, @PathVariable(value="namespace") @NotNull String var3, @PathVariable(value="plural") @NotNull String var4, @PathVariable(value="name") @NotNull String var5);

    @Get(value="/apis/{group}/{version}/{plural}")
    @Consumes(value={"application/json", "application/json;stream=watch"})
    public Object listClusterCustomObject(@PathVariable(value="group") @NotNull String var1, @PathVariable(value="version") @NotNull String var2, @PathVariable(value="plural") @NotNull String var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="allowWatchBookmarks") @Nullable Boolean var5, @QueryValue(value="continue") @Nullable String var6, @QueryValue(value="fieldSelector") @Nullable String var7, @QueryValue(value="labelSelector") @Nullable String var8, @QueryValue(value="limit") @Nullable Integer var9, @QueryValue(value="resourceVersion") @Nullable String var10, @QueryValue(value="resourceVersionMatch") @Nullable String var11, @QueryValue(value="timeoutSeconds") @Nullable Integer var12, @QueryValue(value="watch") @Nullable Boolean var13);

    @Get(value="/apis/{group}/{version}/{resource_plural}")
    @Consumes(value={"application/json", "application/json;stream=watch"})
    public Object listCustomObjectForAllNamespaces(@PathVariable(value="group") @NotNull String var1, @PathVariable(value="version") @NotNull String var2, @PathVariable(value="resource_plural") @NotNull String var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="allowWatchBookmarks") @Nullable Boolean var5, @QueryValue(value="continue") @Nullable String var6, @QueryValue(value="fieldSelector") @Nullable String var7, @QueryValue(value="labelSelector") @Nullable String var8, @QueryValue(value="limit") @Nullable Integer var9, @QueryValue(value="resourceVersion") @Nullable String var10, @QueryValue(value="resourceVersionMatch") @Nullable String var11, @QueryValue(value="timeoutSeconds") @Nullable Integer var12, @QueryValue(value="watch") @Nullable Boolean var13);

    @Get(value="/apis/{group}/{version}/namespaces/{namespace}/{plural}")
    @Consumes(value={"application/json", "application/json;stream=watch"})
    public Object listNamespacedCustomObject(@PathVariable(value="group") @NotNull String var1, @PathVariable(value="version") @NotNull String var2, @PathVariable(value="namespace") @NotNull String var3, @PathVariable(value="plural") @NotNull String var4, @QueryValue(value="pretty") @Nullable String var5, @QueryValue(value="allowWatchBookmarks") @Nullable Boolean var6, @QueryValue(value="continue") @Nullable String var7, @QueryValue(value="fieldSelector") @Nullable String var8, @QueryValue(value="labelSelector") @Nullable String var9, @QueryValue(value="limit") @Nullable Integer var10, @QueryValue(value="resourceVersion") @Nullable String var11, @QueryValue(value="resourceVersionMatch") @Nullable String var12, @QueryValue(value="timeoutSeconds") @Nullable Integer var13, @QueryValue(value="watch") @Nullable Boolean var14);

    @Patch(value="/apis/{group}/{version}/{plural}/{name}")
    public Object patchClusterCustomObject(@PathVariable(value="group") @NotNull String var1, @PathVariable(value="version") @NotNull String var2, @PathVariable(value="plural") @NotNull String var3, @PathVariable(value="name") @NotNull String var4, @Body @NotNull Object var5, @QueryValue(value="dryRun") @Nullable String var6, @QueryValue(value="fieldManager") @Nullable String var7, @QueryValue(value="fieldValidation") @Nullable String var8, @QueryValue(value="force") @Nullable Boolean var9);

    @Patch(value="/apis/{group}/{version}/{plural}/{name}/scale")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public Object patchClusterCustomObjectScale(@PathVariable(value="group") @NotNull String var1, @PathVariable(value="version") @NotNull String var2, @PathVariable(value="plural") @NotNull String var3, @PathVariable(value="name") @NotNull String var4, @Body @NotNull Object var5, @QueryValue(value="dryRun") @Nullable String var6, @QueryValue(value="fieldManager") @Nullable String var7, @QueryValue(value="fieldValidation") @Nullable String var8, @QueryValue(value="force") @Nullable Boolean var9);

    @Patch(value="/apis/{group}/{version}/{plural}/{name}/status")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public Object patchClusterCustomObjectStatus(@PathVariable(value="group") @NotNull String var1, @PathVariable(value="version") @NotNull String var2, @PathVariable(value="plural") @NotNull String var3, @PathVariable(value="name") @NotNull String var4, @Body @NotNull Object var5, @QueryValue(value="dryRun") @Nullable String var6, @QueryValue(value="fieldManager") @Nullable String var7, @QueryValue(value="fieldValidation") @Nullable String var8, @QueryValue(value="force") @Nullable Boolean var9);

    @Patch(value="/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}")
    public Object patchNamespacedCustomObject(@PathVariable(value="group") @NotNull String var1, @PathVariable(value="version") @NotNull String var2, @PathVariable(value="namespace") @NotNull String var3, @PathVariable(value="plural") @NotNull String var4, @PathVariable(value="name") @NotNull String var5, @Body @NotNull Object var6, @QueryValue(value="dryRun") @Nullable String var7, @QueryValue(value="fieldManager") @Nullable String var8, @QueryValue(value="fieldValidation") @Nullable String var9, @QueryValue(value="force") @Nullable Boolean var10);

    @Patch(value="/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/scale")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public Object patchNamespacedCustomObjectScale(@PathVariable(value="group") @NotNull String var1, @PathVariable(value="version") @NotNull String var2, @PathVariable(value="namespace") @NotNull String var3, @PathVariable(value="plural") @NotNull String var4, @PathVariable(value="name") @NotNull String var5, @Body @NotNull Object var6, @QueryValue(value="dryRun") @Nullable String var7, @QueryValue(value="fieldManager") @Nullable String var8, @QueryValue(value="fieldValidation") @Nullable String var9, @QueryValue(value="force") @Nullable Boolean var10);

    @Patch(value="/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/status")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public Object patchNamespacedCustomObjectStatus(@PathVariable(value="group") @NotNull String var1, @PathVariable(value="version") @NotNull String var2, @PathVariable(value="namespace") @NotNull String var3, @PathVariable(value="plural") @NotNull String var4, @PathVariable(value="name") @NotNull String var5, @Body @NotNull Object var6, @QueryValue(value="dryRun") @Nullable String var7, @QueryValue(value="fieldManager") @Nullable String var8, @QueryValue(value="fieldValidation") @Nullable String var9, @QueryValue(value="force") @Nullable Boolean var10);

    @Put(value="/apis/{group}/{version}/{plural}/{name}")
    public Object replaceClusterCustomObject(@PathVariable(value="group") @NotNull String var1, @PathVariable(value="version") @NotNull String var2, @PathVariable(value="plural") @NotNull String var3, @PathVariable(value="name") @NotNull String var4, @Body @NotNull Object var5, @QueryValue(value="dryRun") @Nullable String var6, @QueryValue(value="fieldManager") @Nullable String var7, @QueryValue(value="fieldValidation") @Nullable String var8);

    @Put(value="/apis/{group}/{version}/{plural}/{name}/scale")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public Object replaceClusterCustomObjectScale(@PathVariable(value="group") @NotNull String var1, @PathVariable(value="version") @NotNull String var2, @PathVariable(value="plural") @NotNull String var3, @PathVariable(value="name") @NotNull String var4, @Body @NotNull Object var5, @QueryValue(value="dryRun") @Nullable String var6, @QueryValue(value="fieldManager") @Nullable String var7, @QueryValue(value="fieldValidation") @Nullable String var8);

    @Put(value="/apis/{group}/{version}/{plural}/{name}/status")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public Object replaceClusterCustomObjectStatus(@PathVariable(value="group") @NotNull String var1, @PathVariable(value="version") @NotNull String var2, @PathVariable(value="plural") @NotNull String var3, @PathVariable(value="name") @NotNull String var4, @Body @NotNull Object var5, @QueryValue(value="dryRun") @Nullable String var6, @QueryValue(value="fieldManager") @Nullable String var7, @QueryValue(value="fieldValidation") @Nullable String var8);

    @Put(value="/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}")
    public Object replaceNamespacedCustomObject(@PathVariable(value="group") @NotNull String var1, @PathVariable(value="version") @NotNull String var2, @PathVariable(value="namespace") @NotNull String var3, @PathVariable(value="plural") @NotNull String var4, @PathVariable(value="name") @NotNull String var5, @Body @NotNull Object var6, @QueryValue(value="dryRun") @Nullable String var7, @QueryValue(value="fieldManager") @Nullable String var8, @QueryValue(value="fieldValidation") @Nullable String var9);

    @Put(value="/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/scale")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public Object replaceNamespacedCustomObjectScale(@PathVariable(value="group") @NotNull String var1, @PathVariable(value="version") @NotNull String var2, @PathVariable(value="namespace") @NotNull String var3, @PathVariable(value="plural") @NotNull String var4, @PathVariable(value="name") @NotNull String var5, @Body @NotNull Object var6, @QueryValue(value="dryRun") @Nullable String var7, @QueryValue(value="fieldManager") @Nullable String var8, @QueryValue(value="fieldValidation") @Nullable String var9);

    @Put(value="/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/status")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public Object replaceNamespacedCustomObjectStatus(@PathVariable(value="group") @NotNull String var1, @PathVariable(value="version") @NotNull String var2, @PathVariable(value="namespace") @NotNull String var3, @PathVariable(value="plural") @NotNull String var4, @PathVariable(value="name") @NotNull String var5, @Body @NotNull Object var6, @QueryValue(value="dryRun") @Nullable String var7, @QueryValue(value="fieldManager") @Nullable String var8, @QueryValue(value="fieldValidation") @Nullable String var9);
}

