/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.api;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Delete;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Patch;
import io.micronaut.http.annotation.PathVariable;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Put;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.http.client.annotation.Client;
import io.micronaut.kubernetes.client.openapi.model.V1APIResourceList;
import io.micronaut.kubernetes.client.openapi.model.V1DeleteOptions;
import io.micronaut.kubernetes.client.openapi.model.V1FlowSchema;
import io.micronaut.kubernetes.client.openapi.model.V1FlowSchemaList;
import io.micronaut.kubernetes.client.openapi.model.V1PriorityLevelConfiguration;
import io.micronaut.kubernetes.client.openapi.model.V1PriorityLevelConfigurationList;
import io.micronaut.kubernetes.client.openapi.model.V1Status;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;

@BootstrapContextCompatible
@Client(value="kubernetes")
public interface FlowcontrolApiserverV1Api {
    @Post(value="/apis/flowcontrol.apiserver.k8s.io/v1/flowschemas")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1FlowSchema createFlowSchema(@Body @NotNull @Valid V1FlowSchema var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="dryRun") @Nullable String var3, @QueryValue(value="fieldManager") @Nullable String var4, @QueryValue(value="fieldValidation") @Nullable String var5);

    @Post(value="/apis/flowcontrol.apiserver.k8s.io/v1/prioritylevelconfigurations")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1PriorityLevelConfiguration createPriorityLevelConfiguration(@Body @NotNull @Valid V1PriorityLevelConfiguration var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="dryRun") @Nullable String var3, @QueryValue(value="fieldManager") @Nullable String var4, @QueryValue(value="fieldValidation") @Nullable String var5);

    @Delete(value="/apis/flowcontrol.apiserver.k8s.io/v1/flowschemas")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Status deleteCollectionFlowSchema(@QueryValue(value="pretty") @Nullable String var1, @QueryValue(value="continue") @Nullable String var2, @QueryValue(value="dryRun") @Nullable String var3, @QueryValue(value="fieldSelector") @Nullable String var4, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var5, @QueryValue(value="labelSelector") @Nullable String var6, @QueryValue(value="limit") @Nullable Integer var7, @QueryValue(value="orphanDependents") @Nullable Boolean var8, @QueryValue(value="propagationPolicy") @Nullable String var9, @QueryValue(value="resourceVersion") @Nullable String var10, @QueryValue(value="resourceVersionMatch") @Nullable String var11, @QueryValue(value="sendInitialEvents") @Nullable Boolean var12, @QueryValue(value="timeoutSeconds") @Nullable Integer var13, @Body @Nullable @Valid V1DeleteOptions var14);

    @Delete(value="/apis/flowcontrol.apiserver.k8s.io/v1/prioritylevelconfigurations")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Status deleteCollectionPriorityLevelConfiguration(@QueryValue(value="pretty") @Nullable String var1, @QueryValue(value="continue") @Nullable String var2, @QueryValue(value="dryRun") @Nullable String var3, @QueryValue(value="fieldSelector") @Nullable String var4, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var5, @QueryValue(value="labelSelector") @Nullable String var6, @QueryValue(value="limit") @Nullable Integer var7, @QueryValue(value="orphanDependents") @Nullable Boolean var8, @QueryValue(value="propagationPolicy") @Nullable String var9, @QueryValue(value="resourceVersion") @Nullable String var10, @QueryValue(value="resourceVersionMatch") @Nullable String var11, @QueryValue(value="sendInitialEvents") @Nullable Boolean var12, @QueryValue(value="timeoutSeconds") @Nullable Integer var13, @Body @Nullable @Valid V1DeleteOptions var14);

    @Delete(value="/apis/flowcontrol.apiserver.k8s.io/v1/flowschemas/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Status deleteFlowSchema(@PathVariable(value="name") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="dryRun") @Nullable String var3, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var4, @QueryValue(value="orphanDependents") @Nullable Boolean var5, @QueryValue(value="propagationPolicy") @Nullable String var6, @Body @Nullable @Valid V1DeleteOptions var7);

    @Delete(value="/apis/flowcontrol.apiserver.k8s.io/v1/prioritylevelconfigurations/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Status deletePriorityLevelConfiguration(@PathVariable(value="name") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="dryRun") @Nullable String var3, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var4, @QueryValue(value="orphanDependents") @Nullable Boolean var5, @QueryValue(value="propagationPolicy") @Nullable String var6, @Body @Nullable @Valid V1DeleteOptions var7);

    @Get(value="/apis/flowcontrol.apiserver.k8s.io/v1/")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1APIResourceList getAPIResources();

    @Get(value="/apis/flowcontrol.apiserver.k8s.io/v1/flowschemas")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})
    public V1FlowSchemaList listFlowSchema(@QueryValue(value="pretty") @Nullable String var1, @QueryValue(value="allowWatchBookmarks") @Nullable Boolean var2, @QueryValue(value="continue") @Nullable String var3, @QueryValue(value="fieldSelector") @Nullable String var4, @QueryValue(value="labelSelector") @Nullable String var5, @QueryValue(value="limit") @Nullable Integer var6, @QueryValue(value="resourceVersion") @Nullable String var7, @QueryValue(value="resourceVersionMatch") @Nullable String var8, @QueryValue(value="sendInitialEvents") @Nullable Boolean var9, @QueryValue(value="timeoutSeconds") @Nullable Integer var10, @QueryValue(value="watch") @Nullable Boolean var11);

    @Get(value="/apis/flowcontrol.apiserver.k8s.io/v1/prioritylevelconfigurations")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})
    public V1PriorityLevelConfigurationList listPriorityLevelConfiguration(@QueryValue(value="pretty") @Nullable String var1, @QueryValue(value="allowWatchBookmarks") @Nullable Boolean var2, @QueryValue(value="continue") @Nullable String var3, @QueryValue(value="fieldSelector") @Nullable String var4, @QueryValue(value="labelSelector") @Nullable String var5, @QueryValue(value="limit") @Nullable Integer var6, @QueryValue(value="resourceVersion") @Nullable String var7, @QueryValue(value="resourceVersionMatch") @Nullable String var8, @QueryValue(value="sendInitialEvents") @Nullable Boolean var9, @QueryValue(value="timeoutSeconds") @Nullable Integer var10, @QueryValue(value="watch") @Nullable Boolean var11);

    @Patch(value="/apis/flowcontrol.apiserver.k8s.io/v1/flowschemas/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1FlowSchema patchFlowSchema(@PathVariable(value="name") @NotNull String var1, @Body @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldManager") @Nullable String var5, @QueryValue(value="fieldValidation") @Nullable String var6, @QueryValue(value="force") @Nullable Boolean var7);

    @Patch(value="/apis/flowcontrol.apiserver.k8s.io/v1/flowschemas/{name}/status")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1FlowSchema patchFlowSchemaStatus(@PathVariable(value="name") @NotNull String var1, @Body @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldManager") @Nullable String var5, @QueryValue(value="fieldValidation") @Nullable String var6, @QueryValue(value="force") @Nullable Boolean var7);

    @Patch(value="/apis/flowcontrol.apiserver.k8s.io/v1/prioritylevelconfigurations/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1PriorityLevelConfiguration patchPriorityLevelConfiguration(@PathVariable(value="name") @NotNull String var1, @Body @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldManager") @Nullable String var5, @QueryValue(value="fieldValidation") @Nullable String var6, @QueryValue(value="force") @Nullable Boolean var7);

    @Patch(value="/apis/flowcontrol.apiserver.k8s.io/v1/prioritylevelconfigurations/{name}/status")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1PriorityLevelConfiguration patchPriorityLevelConfigurationStatus(@PathVariable(value="name") @NotNull String var1, @Body @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldManager") @Nullable String var5, @QueryValue(value="fieldValidation") @Nullable String var6, @QueryValue(value="force") @Nullable Boolean var7);

    @Get(value="/apis/flowcontrol.apiserver.k8s.io/v1/flowschemas/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1FlowSchema readFlowSchema(@PathVariable(value="name") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2);

    @Get(value="/apis/flowcontrol.apiserver.k8s.io/v1/flowschemas/{name}/status")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1FlowSchema readFlowSchemaStatus(@PathVariable(value="name") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2);

    @Get(value="/apis/flowcontrol.apiserver.k8s.io/v1/prioritylevelconfigurations/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1PriorityLevelConfiguration readPriorityLevelConfiguration(@PathVariable(value="name") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2);

    @Get(value="/apis/flowcontrol.apiserver.k8s.io/v1/prioritylevelconfigurations/{name}/status")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1PriorityLevelConfiguration readPriorityLevelConfigurationStatus(@PathVariable(value="name") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2);

    @Put(value="/apis/flowcontrol.apiserver.k8s.io/v1/flowschemas/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1FlowSchema replaceFlowSchema(@PathVariable(value="name") @NotNull String var1, @Body @NotNull @Valid V1FlowSchema var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldManager") @Nullable String var5, @QueryValue(value="fieldValidation") @Nullable String var6);

    @Put(value="/apis/flowcontrol.apiserver.k8s.io/v1/flowschemas/{name}/status")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1FlowSchema replaceFlowSchemaStatus(@PathVariable(value="name") @NotNull String var1, @Body @NotNull @Valid V1FlowSchema var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldManager") @Nullable String var5, @QueryValue(value="fieldValidation") @Nullable String var6);

    @Put(value="/apis/flowcontrol.apiserver.k8s.io/v1/prioritylevelconfigurations/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1PriorityLevelConfiguration replacePriorityLevelConfiguration(@PathVariable(value="name") @NotNull String var1, @Body @NotNull @Valid V1PriorityLevelConfiguration var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldManager") @Nullable String var5, @QueryValue(value="fieldValidation") @Nullable String var6);

    @Put(value="/apis/flowcontrol.apiserver.k8s.io/v1/prioritylevelconfigurations/{name}/status")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1PriorityLevelConfiguration replacePriorityLevelConfigurationStatus(@PathVariable(value="name") @NotNull String var1, @Body @NotNull @Valid V1PriorityLevelConfiguration var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldManager") @Nullable String var5, @QueryValue(value="fieldValidation") @Nullable String var6);
}

