/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.api;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Delete;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Patch;
import io.micronaut.http.annotation.PathVariable;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Put;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.http.client.annotation.Client;
import io.micronaut.kubernetes.client.openapi.model.V1APIResourceList;
import io.micronaut.kubernetes.client.openapi.model.V1DeleteOptions;
import io.micronaut.kubernetes.client.openapi.model.V1Ingress;
import io.micronaut.kubernetes.client.openapi.model.V1IngressClass;
import io.micronaut.kubernetes.client.openapi.model.V1IngressClassList;
import io.micronaut.kubernetes.client.openapi.model.V1IngressList;
import io.micronaut.kubernetes.client.openapi.model.V1NetworkPolicy;
import io.micronaut.kubernetes.client.openapi.model.V1NetworkPolicyList;
import io.micronaut.kubernetes.client.openapi.model.V1Status;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;

@BootstrapContextCompatible
@Client(value="kubernetes")
public interface NetworkingV1Api {
    @Post(value="/apis/networking.k8s.io/v1/ingressclasses")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1IngressClass createIngressClass(@Body @NotNull @Valid V1IngressClass var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="dryRun") @Nullable String var3, @QueryValue(value="fieldManager") @Nullable String var4, @QueryValue(value="fieldValidation") @Nullable String var5);

    @Post(value="/apis/networking.k8s.io/v1/namespaces/{namespace}/ingresses")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Ingress createNamespacedIngress(@PathVariable(value="namespace") @NotNull String var1, @Body @NotNull @Valid V1Ingress var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldManager") @Nullable String var5, @QueryValue(value="fieldValidation") @Nullable String var6);

    @Post(value="/apis/networking.k8s.io/v1/namespaces/{namespace}/networkpolicies")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1NetworkPolicy createNamespacedNetworkPolicy(@PathVariable(value="namespace") @NotNull String var1, @Body @NotNull @Valid V1NetworkPolicy var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldManager") @Nullable String var5, @QueryValue(value="fieldValidation") @Nullable String var6);

    @Delete(value="/apis/networking.k8s.io/v1/ingressclasses")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Status deleteCollectionIngressClass(@QueryValue(value="pretty") @Nullable String var1, @QueryValue(value="continue") @Nullable String var2, @QueryValue(value="dryRun") @Nullable String var3, @QueryValue(value="fieldSelector") @Nullable String var4, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var5, @QueryValue(value="labelSelector") @Nullable String var6, @QueryValue(value="limit") @Nullable Integer var7, @QueryValue(value="orphanDependents") @Nullable Boolean var8, @QueryValue(value="propagationPolicy") @Nullable String var9, @QueryValue(value="resourceVersion") @Nullable String var10, @QueryValue(value="resourceVersionMatch") @Nullable String var11, @QueryValue(value="sendInitialEvents") @Nullable Boolean var12, @QueryValue(value="timeoutSeconds") @Nullable Integer var13, @Body @Nullable @Valid V1DeleteOptions var14);

    @Delete(value="/apis/networking.k8s.io/v1/namespaces/{namespace}/ingresses")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Status deleteCollectionNamespacedIngress(@PathVariable(value="namespace") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="continue") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldSelector") @Nullable String var5, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var6, @QueryValue(value="labelSelector") @Nullable String var7, @QueryValue(value="limit") @Nullable Integer var8, @QueryValue(value="orphanDependents") @Nullable Boolean var9, @QueryValue(value="propagationPolicy") @Nullable String var10, @QueryValue(value="resourceVersion") @Nullable String var11, @QueryValue(value="resourceVersionMatch") @Nullable String var12, @QueryValue(value="sendInitialEvents") @Nullable Boolean var13, @QueryValue(value="timeoutSeconds") @Nullable Integer var14, @Body @Nullable @Valid V1DeleteOptions var15);

    @Delete(value="/apis/networking.k8s.io/v1/namespaces/{namespace}/networkpolicies")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Status deleteCollectionNamespacedNetworkPolicy(@PathVariable(value="namespace") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="continue") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldSelector") @Nullable String var5, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var6, @QueryValue(value="labelSelector") @Nullable String var7, @QueryValue(value="limit") @Nullable Integer var8, @QueryValue(value="orphanDependents") @Nullable Boolean var9, @QueryValue(value="propagationPolicy") @Nullable String var10, @QueryValue(value="resourceVersion") @Nullable String var11, @QueryValue(value="resourceVersionMatch") @Nullable String var12, @QueryValue(value="sendInitialEvents") @Nullable Boolean var13, @QueryValue(value="timeoutSeconds") @Nullable Integer var14, @Body @Nullable @Valid V1DeleteOptions var15);

    @Delete(value="/apis/networking.k8s.io/v1/ingressclasses/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Status deleteIngressClass(@PathVariable(value="name") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="dryRun") @Nullable String var3, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var4, @QueryValue(value="orphanDependents") @Nullable Boolean var5, @QueryValue(value="propagationPolicy") @Nullable String var6, @Body @Nullable @Valid V1DeleteOptions var7);

    @Delete(value="/apis/networking.k8s.io/v1/namespaces/{namespace}/ingresses/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Status deleteNamespacedIngress(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var5, @QueryValue(value="orphanDependents") @Nullable Boolean var6, @QueryValue(value="propagationPolicy") @Nullable String var7, @Body @Nullable @Valid V1DeleteOptions var8);

    @Delete(value="/apis/networking.k8s.io/v1/namespaces/{namespace}/networkpolicies/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Status deleteNamespacedNetworkPolicy(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var5, @QueryValue(value="orphanDependents") @Nullable Boolean var6, @QueryValue(value="propagationPolicy") @Nullable String var7, @Body @Nullable @Valid V1DeleteOptions var8);

    @Get(value="/apis/networking.k8s.io/v1/")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1APIResourceList getAPIResources();

    @Get(value="/apis/networking.k8s.io/v1/ingressclasses")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})
    public V1IngressClassList listIngressClass(@QueryValue(value="pretty") @Nullable String var1, @QueryValue(value="allowWatchBookmarks") @Nullable Boolean var2, @QueryValue(value="continue") @Nullable String var3, @QueryValue(value="fieldSelector") @Nullable String var4, @QueryValue(value="labelSelector") @Nullable String var5, @QueryValue(value="limit") @Nullable Integer var6, @QueryValue(value="resourceVersion") @Nullable String var7, @QueryValue(value="resourceVersionMatch") @Nullable String var8, @QueryValue(value="sendInitialEvents") @Nullable Boolean var9, @QueryValue(value="timeoutSeconds") @Nullable Integer var10, @QueryValue(value="watch") @Nullable Boolean var11);

    @Get(value="/apis/networking.k8s.io/v1/ingresses")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})
    public V1IngressList listIngressForAllNamespaces(@QueryValue(value="allowWatchBookmarks") @Nullable Boolean var1, @QueryValue(value="continue") @Nullable String var2, @QueryValue(value="fieldSelector") @Nullable String var3, @QueryValue(value="labelSelector") @Nullable String var4, @QueryValue(value="limit") @Nullable Integer var5, @QueryValue(value="pretty") @Nullable String var6, @QueryValue(value="resourceVersion") @Nullable String var7, @QueryValue(value="resourceVersionMatch") @Nullable String var8, @QueryValue(value="sendInitialEvents") @Nullable Boolean var9, @QueryValue(value="timeoutSeconds") @Nullable Integer var10, @QueryValue(value="watch") @Nullable Boolean var11);

    @Get(value="/apis/networking.k8s.io/v1/namespaces/{namespace}/ingresses")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})
    public V1IngressList listNamespacedIngress(@PathVariable(value="namespace") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="allowWatchBookmarks") @Nullable Boolean var3, @QueryValue(value="continue") @Nullable String var4, @QueryValue(value="fieldSelector") @Nullable String var5, @QueryValue(value="labelSelector") @Nullable String var6, @QueryValue(value="limit") @Nullable Integer var7, @QueryValue(value="resourceVersion") @Nullable String var8, @QueryValue(value="resourceVersionMatch") @Nullable String var9, @QueryValue(value="sendInitialEvents") @Nullable Boolean var10, @QueryValue(value="timeoutSeconds") @Nullable Integer var11, @QueryValue(value="watch") @Nullable Boolean var12);

    @Get(value="/apis/networking.k8s.io/v1/namespaces/{namespace}/networkpolicies")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})
    public V1NetworkPolicyList listNamespacedNetworkPolicy(@PathVariable(value="namespace") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="allowWatchBookmarks") @Nullable Boolean var3, @QueryValue(value="continue") @Nullable String var4, @QueryValue(value="fieldSelector") @Nullable String var5, @QueryValue(value="labelSelector") @Nullable String var6, @QueryValue(value="limit") @Nullable Integer var7, @QueryValue(value="resourceVersion") @Nullable String var8, @QueryValue(value="resourceVersionMatch") @Nullable String var9, @QueryValue(value="sendInitialEvents") @Nullable Boolean var10, @QueryValue(value="timeoutSeconds") @Nullable Integer var11, @QueryValue(value="watch") @Nullable Boolean var12);

    @Get(value="/apis/networking.k8s.io/v1/networkpolicies")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})
    public V1NetworkPolicyList listNetworkPolicyForAllNamespaces(@QueryValue(value="allowWatchBookmarks") @Nullable Boolean var1, @QueryValue(value="continue") @Nullable String var2, @QueryValue(value="fieldSelector") @Nullable String var3, @QueryValue(value="labelSelector") @Nullable String var4, @QueryValue(value="limit") @Nullable Integer var5, @QueryValue(value="pretty") @Nullable String var6, @QueryValue(value="resourceVersion") @Nullable String var7, @QueryValue(value="resourceVersionMatch") @Nullable String var8, @QueryValue(value="sendInitialEvents") @Nullable Boolean var9, @QueryValue(value="timeoutSeconds") @Nullable Integer var10, @QueryValue(value="watch") @Nullable Boolean var11);

    @Patch(value="/apis/networking.k8s.io/v1/ingressclasses/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1IngressClass patchIngressClass(@PathVariable(value="name") @NotNull String var1, @Body @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldManager") @Nullable String var5, @QueryValue(value="fieldValidation") @Nullable String var6, @QueryValue(value="force") @Nullable Boolean var7);

    @Patch(value="/apis/networking.k8s.io/v1/namespaces/{namespace}/ingresses/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Ingress patchNamespacedIngress(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull String var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7, @QueryValue(value="force") @Nullable Boolean var8);

    @Patch(value="/apis/networking.k8s.io/v1/namespaces/{namespace}/ingresses/{name}/status")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Ingress patchNamespacedIngressStatus(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull String var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7, @QueryValue(value="force") @Nullable Boolean var8);

    @Patch(value="/apis/networking.k8s.io/v1/namespaces/{namespace}/networkpolicies/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1NetworkPolicy patchNamespacedNetworkPolicy(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull String var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7, @QueryValue(value="force") @Nullable Boolean var8);

    @Get(value="/apis/networking.k8s.io/v1/ingressclasses/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1IngressClass readIngressClass(@PathVariable(value="name") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2);

    @Get(value="/apis/networking.k8s.io/v1/namespaces/{namespace}/ingresses/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Ingress readNamespacedIngress(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3);

    @Get(value="/apis/networking.k8s.io/v1/namespaces/{namespace}/ingresses/{name}/status")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Ingress readNamespacedIngressStatus(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3);

    @Get(value="/apis/networking.k8s.io/v1/namespaces/{namespace}/networkpolicies/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1NetworkPolicy readNamespacedNetworkPolicy(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3);

    @Put(value="/apis/networking.k8s.io/v1/ingressclasses/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1IngressClass replaceIngressClass(@PathVariable(value="name") @NotNull String var1, @Body @NotNull @Valid V1IngressClass var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldManager") @Nullable String var5, @QueryValue(value="fieldValidation") @Nullable String var6);

    @Put(value="/apis/networking.k8s.io/v1/namespaces/{namespace}/ingresses/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Ingress replaceNamespacedIngress(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull @Valid V1Ingress var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7);

    @Put(value="/apis/networking.k8s.io/v1/namespaces/{namespace}/ingresses/{name}/status")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Ingress replaceNamespacedIngressStatus(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull @Valid V1Ingress var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7);

    @Put(value="/apis/networking.k8s.io/v1/namespaces/{namespace}/networkpolicies/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1NetworkPolicy replaceNamespacedNetworkPolicy(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull @Valid V1NetworkPolicy var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7);
}

