/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.api;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Delete;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Patch;
import io.micronaut.http.annotation.PathVariable;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Put;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.http.client.annotation.Client;
import io.micronaut.kubernetes.client.openapi.model.V1APIResourceList;
import io.micronaut.kubernetes.client.openapi.model.V1ClusterRole;
import io.micronaut.kubernetes.client.openapi.model.V1ClusterRoleBinding;
import io.micronaut.kubernetes.client.openapi.model.V1ClusterRoleBindingList;
import io.micronaut.kubernetes.client.openapi.model.V1ClusterRoleList;
import io.micronaut.kubernetes.client.openapi.model.V1DeleteOptions;
import io.micronaut.kubernetes.client.openapi.model.V1Role;
import io.micronaut.kubernetes.client.openapi.model.V1RoleBinding;
import io.micronaut.kubernetes.client.openapi.model.V1RoleBindingList;
import io.micronaut.kubernetes.client.openapi.model.V1RoleList;
import io.micronaut.kubernetes.client.openapi.model.V1Status;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;

@BootstrapContextCompatible
@Client(value="kubernetes")
public interface RbacAuthorizationV1Api {
    @Post(value="/apis/rbac.authorization.k8s.io/v1/clusterroles")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1ClusterRole createClusterRole(@Body @NotNull @Valid V1ClusterRole var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="dryRun") @Nullable String var3, @QueryValue(value="fieldManager") @Nullable String var4, @QueryValue(value="fieldValidation") @Nullable String var5);

    @Post(value="/apis/rbac.authorization.k8s.io/v1/clusterrolebindings")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1ClusterRoleBinding createClusterRoleBinding(@Body @NotNull @Valid V1ClusterRoleBinding var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="dryRun") @Nullable String var3, @QueryValue(value="fieldManager") @Nullable String var4, @QueryValue(value="fieldValidation") @Nullable String var5);

    @Post(value="/apis/rbac.authorization.k8s.io/v1/namespaces/{namespace}/roles")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Role createNamespacedRole(@PathVariable(value="namespace") @NotNull String var1, @Body @NotNull @Valid V1Role var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldManager") @Nullable String var5, @QueryValue(value="fieldValidation") @Nullable String var6);

    @Post(value="/apis/rbac.authorization.k8s.io/v1/namespaces/{namespace}/rolebindings")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1RoleBinding createNamespacedRoleBinding(@PathVariable(value="namespace") @NotNull String var1, @Body @NotNull @Valid V1RoleBinding var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldManager") @Nullable String var5, @QueryValue(value="fieldValidation") @Nullable String var6);

    @Delete(value="/apis/rbac.authorization.k8s.io/v1/clusterroles/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Status deleteClusterRole(@PathVariable(value="name") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="dryRun") @Nullable String var3, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var4, @QueryValue(value="orphanDependents") @Nullable Boolean var5, @QueryValue(value="propagationPolicy") @Nullable String var6, @Body @Nullable @Valid V1DeleteOptions var7);

    @Delete(value="/apis/rbac.authorization.k8s.io/v1/clusterrolebindings/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Status deleteClusterRoleBinding(@PathVariable(value="name") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="dryRun") @Nullable String var3, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var4, @QueryValue(value="orphanDependents") @Nullable Boolean var5, @QueryValue(value="propagationPolicy") @Nullable String var6, @Body @Nullable @Valid V1DeleteOptions var7);

    @Delete(value="/apis/rbac.authorization.k8s.io/v1/clusterroles")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Status deleteCollectionClusterRole(@QueryValue(value="pretty") @Nullable String var1, @QueryValue(value="continue") @Nullable String var2, @QueryValue(value="dryRun") @Nullable String var3, @QueryValue(value="fieldSelector") @Nullable String var4, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var5, @QueryValue(value="labelSelector") @Nullable String var6, @QueryValue(value="limit") @Nullable Integer var7, @QueryValue(value="orphanDependents") @Nullable Boolean var8, @QueryValue(value="propagationPolicy") @Nullable String var9, @QueryValue(value="resourceVersion") @Nullable String var10, @QueryValue(value="resourceVersionMatch") @Nullable String var11, @QueryValue(value="sendInitialEvents") @Nullable Boolean var12, @QueryValue(value="timeoutSeconds") @Nullable Integer var13, @Body @Nullable @Valid V1DeleteOptions var14);

    @Delete(value="/apis/rbac.authorization.k8s.io/v1/clusterrolebindings")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Status deleteCollectionClusterRoleBinding(@QueryValue(value="pretty") @Nullable String var1, @QueryValue(value="continue") @Nullable String var2, @QueryValue(value="dryRun") @Nullable String var3, @QueryValue(value="fieldSelector") @Nullable String var4, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var5, @QueryValue(value="labelSelector") @Nullable String var6, @QueryValue(value="limit") @Nullable Integer var7, @QueryValue(value="orphanDependents") @Nullable Boolean var8, @QueryValue(value="propagationPolicy") @Nullable String var9, @QueryValue(value="resourceVersion") @Nullable String var10, @QueryValue(value="resourceVersionMatch") @Nullable String var11, @QueryValue(value="sendInitialEvents") @Nullable Boolean var12, @QueryValue(value="timeoutSeconds") @Nullable Integer var13, @Body @Nullable @Valid V1DeleteOptions var14);

    @Delete(value="/apis/rbac.authorization.k8s.io/v1/namespaces/{namespace}/roles")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Status deleteCollectionNamespacedRole(@PathVariable(value="namespace") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="continue") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldSelector") @Nullable String var5, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var6, @QueryValue(value="labelSelector") @Nullable String var7, @QueryValue(value="limit") @Nullable Integer var8, @QueryValue(value="orphanDependents") @Nullable Boolean var9, @QueryValue(value="propagationPolicy") @Nullable String var10, @QueryValue(value="resourceVersion") @Nullable String var11, @QueryValue(value="resourceVersionMatch") @Nullable String var12, @QueryValue(value="sendInitialEvents") @Nullable Boolean var13, @QueryValue(value="timeoutSeconds") @Nullable Integer var14, @Body @Nullable @Valid V1DeleteOptions var15);

    @Delete(value="/apis/rbac.authorization.k8s.io/v1/namespaces/{namespace}/rolebindings")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Status deleteCollectionNamespacedRoleBinding(@PathVariable(value="namespace") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="continue") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldSelector") @Nullable String var5, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var6, @QueryValue(value="labelSelector") @Nullable String var7, @QueryValue(value="limit") @Nullable Integer var8, @QueryValue(value="orphanDependents") @Nullable Boolean var9, @QueryValue(value="propagationPolicy") @Nullable String var10, @QueryValue(value="resourceVersion") @Nullable String var11, @QueryValue(value="resourceVersionMatch") @Nullable String var12, @QueryValue(value="sendInitialEvents") @Nullable Boolean var13, @QueryValue(value="timeoutSeconds") @Nullable Integer var14, @Body @Nullable @Valid V1DeleteOptions var15);

    @Delete(value="/apis/rbac.authorization.k8s.io/v1/namespaces/{namespace}/roles/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Status deleteNamespacedRole(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var5, @QueryValue(value="orphanDependents") @Nullable Boolean var6, @QueryValue(value="propagationPolicy") @Nullable String var7, @Body @Nullable @Valid V1DeleteOptions var8);

    @Delete(value="/apis/rbac.authorization.k8s.io/v1/namespaces/{namespace}/rolebindings/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Status deleteNamespacedRoleBinding(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var5, @QueryValue(value="orphanDependents") @Nullable Boolean var6, @QueryValue(value="propagationPolicy") @Nullable String var7, @Body @Nullable @Valid V1DeleteOptions var8);

    @Get(value="/apis/rbac.authorization.k8s.io/v1/")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1APIResourceList getAPIResources();

    @Get(value="/apis/rbac.authorization.k8s.io/v1/clusterroles")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})
    public V1ClusterRoleList listClusterRole(@QueryValue(value="pretty") @Nullable String var1, @QueryValue(value="allowWatchBookmarks") @Nullable Boolean var2, @QueryValue(value="continue") @Nullable String var3, @QueryValue(value="fieldSelector") @Nullable String var4, @QueryValue(value="labelSelector") @Nullable String var5, @QueryValue(value="limit") @Nullable Integer var6, @QueryValue(value="resourceVersion") @Nullable String var7, @QueryValue(value="resourceVersionMatch") @Nullable String var8, @QueryValue(value="sendInitialEvents") @Nullable Boolean var9, @QueryValue(value="timeoutSeconds") @Nullable Integer var10, @QueryValue(value="watch") @Nullable Boolean var11);

    @Get(value="/apis/rbac.authorization.k8s.io/v1/clusterrolebindings")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})
    public V1ClusterRoleBindingList listClusterRoleBinding(@QueryValue(value="pretty") @Nullable String var1, @QueryValue(value="allowWatchBookmarks") @Nullable Boolean var2, @QueryValue(value="continue") @Nullable String var3, @QueryValue(value="fieldSelector") @Nullable String var4, @QueryValue(value="labelSelector") @Nullable String var5, @QueryValue(value="limit") @Nullable Integer var6, @QueryValue(value="resourceVersion") @Nullable String var7, @QueryValue(value="resourceVersionMatch") @Nullable String var8, @QueryValue(value="sendInitialEvents") @Nullable Boolean var9, @QueryValue(value="timeoutSeconds") @Nullable Integer var10, @QueryValue(value="watch") @Nullable Boolean var11);

    @Get(value="/apis/rbac.authorization.k8s.io/v1/namespaces/{namespace}/roles")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})
    public V1RoleList listNamespacedRole(@PathVariable(value="namespace") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="allowWatchBookmarks") @Nullable Boolean var3, @QueryValue(value="continue") @Nullable String var4, @QueryValue(value="fieldSelector") @Nullable String var5, @QueryValue(value="labelSelector") @Nullable String var6, @QueryValue(value="limit") @Nullable Integer var7, @QueryValue(value="resourceVersion") @Nullable String var8, @QueryValue(value="resourceVersionMatch") @Nullable String var9, @QueryValue(value="sendInitialEvents") @Nullable Boolean var10, @QueryValue(value="timeoutSeconds") @Nullable Integer var11, @QueryValue(value="watch") @Nullable Boolean var12);

    @Get(value="/apis/rbac.authorization.k8s.io/v1/namespaces/{namespace}/rolebindings")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})
    public V1RoleBindingList listNamespacedRoleBinding(@PathVariable(value="namespace") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="allowWatchBookmarks") @Nullable Boolean var3, @QueryValue(value="continue") @Nullable String var4, @QueryValue(value="fieldSelector") @Nullable String var5, @QueryValue(value="labelSelector") @Nullable String var6, @QueryValue(value="limit") @Nullable Integer var7, @QueryValue(value="resourceVersion") @Nullable String var8, @QueryValue(value="resourceVersionMatch") @Nullable String var9, @QueryValue(value="sendInitialEvents") @Nullable Boolean var10, @QueryValue(value="timeoutSeconds") @Nullable Integer var11, @QueryValue(value="watch") @Nullable Boolean var12);

    @Get(value="/apis/rbac.authorization.k8s.io/v1/rolebindings")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})
    public V1RoleBindingList listRoleBindingForAllNamespaces(@QueryValue(value="allowWatchBookmarks") @Nullable Boolean var1, @QueryValue(value="continue") @Nullable String var2, @QueryValue(value="fieldSelector") @Nullable String var3, @QueryValue(value="labelSelector") @Nullable String var4, @QueryValue(value="limit") @Nullable Integer var5, @QueryValue(value="pretty") @Nullable String var6, @QueryValue(value="resourceVersion") @Nullable String var7, @QueryValue(value="resourceVersionMatch") @Nullable String var8, @QueryValue(value="sendInitialEvents") @Nullable Boolean var9, @QueryValue(value="timeoutSeconds") @Nullable Integer var10, @QueryValue(value="watch") @Nullable Boolean var11);

    @Get(value="/apis/rbac.authorization.k8s.io/v1/roles")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})
    public V1RoleList listRoleForAllNamespaces(@QueryValue(value="allowWatchBookmarks") @Nullable Boolean var1, @QueryValue(value="continue") @Nullable String var2, @QueryValue(value="fieldSelector") @Nullable String var3, @QueryValue(value="labelSelector") @Nullable String var4, @QueryValue(value="limit") @Nullable Integer var5, @QueryValue(value="pretty") @Nullable String var6, @QueryValue(value="resourceVersion") @Nullable String var7, @QueryValue(value="resourceVersionMatch") @Nullable String var8, @QueryValue(value="sendInitialEvents") @Nullable Boolean var9, @QueryValue(value="timeoutSeconds") @Nullable Integer var10, @QueryValue(value="watch") @Nullable Boolean var11);

    @Patch(value="/apis/rbac.authorization.k8s.io/v1/clusterroles/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1ClusterRole patchClusterRole(@PathVariable(value="name") @NotNull String var1, @Body @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldManager") @Nullable String var5, @QueryValue(value="fieldValidation") @Nullable String var6, @QueryValue(value="force") @Nullable Boolean var7);

    @Patch(value="/apis/rbac.authorization.k8s.io/v1/clusterrolebindings/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1ClusterRoleBinding patchClusterRoleBinding(@PathVariable(value="name") @NotNull String var1, @Body @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldManager") @Nullable String var5, @QueryValue(value="fieldValidation") @Nullable String var6, @QueryValue(value="force") @Nullable Boolean var7);

    @Patch(value="/apis/rbac.authorization.k8s.io/v1/namespaces/{namespace}/roles/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Role patchNamespacedRole(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull String var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7, @QueryValue(value="force") @Nullable Boolean var8);

    @Patch(value="/apis/rbac.authorization.k8s.io/v1/namespaces/{namespace}/rolebindings/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1RoleBinding patchNamespacedRoleBinding(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull String var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7, @QueryValue(value="force") @Nullable Boolean var8);

    @Get(value="/apis/rbac.authorization.k8s.io/v1/clusterroles/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1ClusterRole readClusterRole(@PathVariable(value="name") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2);

    @Get(value="/apis/rbac.authorization.k8s.io/v1/clusterrolebindings/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1ClusterRoleBinding readClusterRoleBinding(@PathVariable(value="name") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2);

    @Get(value="/apis/rbac.authorization.k8s.io/v1/namespaces/{namespace}/roles/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Role readNamespacedRole(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3);

    @Get(value="/apis/rbac.authorization.k8s.io/v1/namespaces/{namespace}/rolebindings/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1RoleBinding readNamespacedRoleBinding(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3);

    @Put(value="/apis/rbac.authorization.k8s.io/v1/clusterroles/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1ClusterRole replaceClusterRole(@PathVariable(value="name") @NotNull String var1, @Body @NotNull @Valid V1ClusterRole var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldManager") @Nullable String var5, @QueryValue(value="fieldValidation") @Nullable String var6);

    @Put(value="/apis/rbac.authorization.k8s.io/v1/clusterrolebindings/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1ClusterRoleBinding replaceClusterRoleBinding(@PathVariable(value="name") @NotNull String var1, @Body @NotNull @Valid V1ClusterRoleBinding var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldManager") @Nullable String var5, @QueryValue(value="fieldValidation") @Nullable String var6);

    @Put(value="/apis/rbac.authorization.k8s.io/v1/namespaces/{namespace}/roles/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Role replaceNamespacedRole(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull @Valid V1Role var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7);

    @Put(value="/apis/rbac.authorization.k8s.io/v1/namespaces/{namespace}/rolebindings/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1RoleBinding replaceNamespacedRoleBinding(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull @Valid V1RoleBinding var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7);
}

