/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.api;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Delete;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Patch;
import io.micronaut.http.annotation.PathVariable;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Put;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.http.client.annotation.Client;
import io.micronaut.kubernetes.client.openapi.model.V1APIResourceList;
import io.micronaut.kubernetes.client.openapi.model.V1CSIDriver;
import io.micronaut.kubernetes.client.openapi.model.V1CSIDriverList;
import io.micronaut.kubernetes.client.openapi.model.V1CSINode;
import io.micronaut.kubernetes.client.openapi.model.V1CSINodeList;
import io.micronaut.kubernetes.client.openapi.model.V1CSIStorageCapacity;
import io.micronaut.kubernetes.client.openapi.model.V1CSIStorageCapacityList;
import io.micronaut.kubernetes.client.openapi.model.V1DeleteOptions;
import io.micronaut.kubernetes.client.openapi.model.V1Status;
import io.micronaut.kubernetes.client.openapi.model.V1StorageClass;
import io.micronaut.kubernetes.client.openapi.model.V1StorageClassList;
import io.micronaut.kubernetes.client.openapi.model.V1VolumeAttachment;
import io.micronaut.kubernetes.client.openapi.model.V1VolumeAttachmentList;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;

@BootstrapContextCompatible
@Client(value="kubernetes")
public interface StorageV1Api {
    @Post(value="/apis/storage.k8s.io/v1/csidrivers")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1CSIDriver createCSIDriver(@Body @NotNull @Valid V1CSIDriver var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="dryRun") @Nullable String var3, @QueryValue(value="fieldManager") @Nullable String var4, @QueryValue(value="fieldValidation") @Nullable String var5);

    @Post(value="/apis/storage.k8s.io/v1/csinodes")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1CSINode createCSINode(@Body @NotNull @Valid V1CSINode var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="dryRun") @Nullable String var3, @QueryValue(value="fieldManager") @Nullable String var4, @QueryValue(value="fieldValidation") @Nullable String var5);

    @Post(value="/apis/storage.k8s.io/v1/namespaces/{namespace}/csistoragecapacities")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1CSIStorageCapacity createNamespacedCSIStorageCapacity(@PathVariable(value="namespace") @NotNull String var1, @Body @NotNull @Valid V1CSIStorageCapacity var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldManager") @Nullable String var5, @QueryValue(value="fieldValidation") @Nullable String var6);

    @Post(value="/apis/storage.k8s.io/v1/storageclasses")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1StorageClass createStorageClass(@Body @NotNull @Valid V1StorageClass var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="dryRun") @Nullable String var3, @QueryValue(value="fieldManager") @Nullable String var4, @QueryValue(value="fieldValidation") @Nullable String var5);

    @Post(value="/apis/storage.k8s.io/v1/volumeattachments")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1VolumeAttachment createVolumeAttachment(@Body @NotNull @Valid V1VolumeAttachment var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="dryRun") @Nullable String var3, @QueryValue(value="fieldManager") @Nullable String var4, @QueryValue(value="fieldValidation") @Nullable String var5);

    @Delete(value="/apis/storage.k8s.io/v1/csidrivers/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1CSIDriver deleteCSIDriver(@PathVariable(value="name") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="dryRun") @Nullable String var3, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var4, @QueryValue(value="orphanDependents") @Nullable Boolean var5, @QueryValue(value="propagationPolicy") @Nullable String var6, @Body @Nullable @Valid V1DeleteOptions var7);

    @Delete(value="/apis/storage.k8s.io/v1/csinodes/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1CSINode deleteCSINode(@PathVariable(value="name") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="dryRun") @Nullable String var3, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var4, @QueryValue(value="orphanDependents") @Nullable Boolean var5, @QueryValue(value="propagationPolicy") @Nullable String var6, @Body @Nullable @Valid V1DeleteOptions var7);

    @Delete(value="/apis/storage.k8s.io/v1/csidrivers")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Status deleteCollectionCSIDriver(@QueryValue(value="pretty") @Nullable String var1, @QueryValue(value="continue") @Nullable String var2, @QueryValue(value="dryRun") @Nullable String var3, @QueryValue(value="fieldSelector") @Nullable String var4, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var5, @QueryValue(value="labelSelector") @Nullable String var6, @QueryValue(value="limit") @Nullable Integer var7, @QueryValue(value="orphanDependents") @Nullable Boolean var8, @QueryValue(value="propagationPolicy") @Nullable String var9, @QueryValue(value="resourceVersion") @Nullable String var10, @QueryValue(value="resourceVersionMatch") @Nullable String var11, @QueryValue(value="sendInitialEvents") @Nullable Boolean var12, @QueryValue(value="timeoutSeconds") @Nullable Integer var13, @Body @Nullable @Valid V1DeleteOptions var14);

    @Delete(value="/apis/storage.k8s.io/v1/csinodes")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Status deleteCollectionCSINode(@QueryValue(value="pretty") @Nullable String var1, @QueryValue(value="continue") @Nullable String var2, @QueryValue(value="dryRun") @Nullable String var3, @QueryValue(value="fieldSelector") @Nullable String var4, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var5, @QueryValue(value="labelSelector") @Nullable String var6, @QueryValue(value="limit") @Nullable Integer var7, @QueryValue(value="orphanDependents") @Nullable Boolean var8, @QueryValue(value="propagationPolicy") @Nullable String var9, @QueryValue(value="resourceVersion") @Nullable String var10, @QueryValue(value="resourceVersionMatch") @Nullable String var11, @QueryValue(value="sendInitialEvents") @Nullable Boolean var12, @QueryValue(value="timeoutSeconds") @Nullable Integer var13, @Body @Nullable @Valid V1DeleteOptions var14);

    @Delete(value="/apis/storage.k8s.io/v1/namespaces/{namespace}/csistoragecapacities")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Status deleteCollectionNamespacedCSIStorageCapacity(@PathVariable(value="namespace") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="continue") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldSelector") @Nullable String var5, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var6, @QueryValue(value="labelSelector") @Nullable String var7, @QueryValue(value="limit") @Nullable Integer var8, @QueryValue(value="orphanDependents") @Nullable Boolean var9, @QueryValue(value="propagationPolicy") @Nullable String var10, @QueryValue(value="resourceVersion") @Nullable String var11, @QueryValue(value="resourceVersionMatch") @Nullable String var12, @QueryValue(value="sendInitialEvents") @Nullable Boolean var13, @QueryValue(value="timeoutSeconds") @Nullable Integer var14, @Body @Nullable @Valid V1DeleteOptions var15);

    @Delete(value="/apis/storage.k8s.io/v1/storageclasses")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Status deleteCollectionStorageClass(@QueryValue(value="pretty") @Nullable String var1, @QueryValue(value="continue") @Nullable String var2, @QueryValue(value="dryRun") @Nullable String var3, @QueryValue(value="fieldSelector") @Nullable String var4, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var5, @QueryValue(value="labelSelector") @Nullable String var6, @QueryValue(value="limit") @Nullable Integer var7, @QueryValue(value="orphanDependents") @Nullable Boolean var8, @QueryValue(value="propagationPolicy") @Nullable String var9, @QueryValue(value="resourceVersion") @Nullable String var10, @QueryValue(value="resourceVersionMatch") @Nullable String var11, @QueryValue(value="sendInitialEvents") @Nullable Boolean var12, @QueryValue(value="timeoutSeconds") @Nullable Integer var13, @Body @Nullable @Valid V1DeleteOptions var14);

    @Delete(value="/apis/storage.k8s.io/v1/volumeattachments")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Status deleteCollectionVolumeAttachment(@QueryValue(value="pretty") @Nullable String var1, @QueryValue(value="continue") @Nullable String var2, @QueryValue(value="dryRun") @Nullable String var3, @QueryValue(value="fieldSelector") @Nullable String var4, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var5, @QueryValue(value="labelSelector") @Nullable String var6, @QueryValue(value="limit") @Nullable Integer var7, @QueryValue(value="orphanDependents") @Nullable Boolean var8, @QueryValue(value="propagationPolicy") @Nullable String var9, @QueryValue(value="resourceVersion") @Nullable String var10, @QueryValue(value="resourceVersionMatch") @Nullable String var11, @QueryValue(value="sendInitialEvents") @Nullable Boolean var12, @QueryValue(value="timeoutSeconds") @Nullable Integer var13, @Body @Nullable @Valid V1DeleteOptions var14);

    @Delete(value="/apis/storage.k8s.io/v1/namespaces/{namespace}/csistoragecapacities/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1Status deleteNamespacedCSIStorageCapacity(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var5, @QueryValue(value="orphanDependents") @Nullable Boolean var6, @QueryValue(value="propagationPolicy") @Nullable String var7, @Body @Nullable @Valid V1DeleteOptions var8);

    @Delete(value="/apis/storage.k8s.io/v1/storageclasses/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1StorageClass deleteStorageClass(@PathVariable(value="name") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="dryRun") @Nullable String var3, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var4, @QueryValue(value="orphanDependents") @Nullable Boolean var5, @QueryValue(value="propagationPolicy") @Nullable String var6, @Body @Nullable @Valid V1DeleteOptions var7);

    @Delete(value="/apis/storage.k8s.io/v1/volumeattachments/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1VolumeAttachment deleteVolumeAttachment(@PathVariable(value="name") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="dryRun") @Nullable String var3, @QueryValue(value="gracePeriodSeconds") @Nullable Integer var4, @QueryValue(value="orphanDependents") @Nullable Boolean var5, @QueryValue(value="propagationPolicy") @Nullable String var6, @Body @Nullable @Valid V1DeleteOptions var7);

    @Get(value="/apis/storage.k8s.io/v1/")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1APIResourceList getAPIResources();

    @Get(value="/apis/storage.k8s.io/v1/csidrivers")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})
    public V1CSIDriverList listCSIDriver(@QueryValue(value="pretty") @Nullable String var1, @QueryValue(value="allowWatchBookmarks") @Nullable Boolean var2, @QueryValue(value="continue") @Nullable String var3, @QueryValue(value="fieldSelector") @Nullable String var4, @QueryValue(value="labelSelector") @Nullable String var5, @QueryValue(value="limit") @Nullable Integer var6, @QueryValue(value="resourceVersion") @Nullable String var7, @QueryValue(value="resourceVersionMatch") @Nullable String var8, @QueryValue(value="sendInitialEvents") @Nullable Boolean var9, @QueryValue(value="timeoutSeconds") @Nullable Integer var10, @QueryValue(value="watch") @Nullable Boolean var11);

    @Get(value="/apis/storage.k8s.io/v1/csinodes")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})
    public V1CSINodeList listCSINode(@QueryValue(value="pretty") @Nullable String var1, @QueryValue(value="allowWatchBookmarks") @Nullable Boolean var2, @QueryValue(value="continue") @Nullable String var3, @QueryValue(value="fieldSelector") @Nullable String var4, @QueryValue(value="labelSelector") @Nullable String var5, @QueryValue(value="limit") @Nullable Integer var6, @QueryValue(value="resourceVersion") @Nullable String var7, @QueryValue(value="resourceVersionMatch") @Nullable String var8, @QueryValue(value="sendInitialEvents") @Nullable Boolean var9, @QueryValue(value="timeoutSeconds") @Nullable Integer var10, @QueryValue(value="watch") @Nullable Boolean var11);

    @Get(value="/apis/storage.k8s.io/v1/csistoragecapacities")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})
    public V1CSIStorageCapacityList listCSIStorageCapacityForAllNamespaces(@QueryValue(value="allowWatchBookmarks") @Nullable Boolean var1, @QueryValue(value="continue") @Nullable String var2, @QueryValue(value="fieldSelector") @Nullable String var3, @QueryValue(value="labelSelector") @Nullable String var4, @QueryValue(value="limit") @Nullable Integer var5, @QueryValue(value="pretty") @Nullable String var6, @QueryValue(value="resourceVersion") @Nullable String var7, @QueryValue(value="resourceVersionMatch") @Nullable String var8, @QueryValue(value="sendInitialEvents") @Nullable Boolean var9, @QueryValue(value="timeoutSeconds") @Nullable Integer var10, @QueryValue(value="watch") @Nullable Boolean var11);

    @Get(value="/apis/storage.k8s.io/v1/namespaces/{namespace}/csistoragecapacities")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})
    public V1CSIStorageCapacityList listNamespacedCSIStorageCapacity(@PathVariable(value="namespace") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2, @QueryValue(value="allowWatchBookmarks") @Nullable Boolean var3, @QueryValue(value="continue") @Nullable String var4, @QueryValue(value="fieldSelector") @Nullable String var5, @QueryValue(value="labelSelector") @Nullable String var6, @QueryValue(value="limit") @Nullable Integer var7, @QueryValue(value="resourceVersion") @Nullable String var8, @QueryValue(value="resourceVersionMatch") @Nullable String var9, @QueryValue(value="sendInitialEvents") @Nullable Boolean var10, @QueryValue(value="timeoutSeconds") @Nullable Integer var11, @QueryValue(value="watch") @Nullable Boolean var12);

    @Get(value="/apis/storage.k8s.io/v1/storageclasses")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})
    public V1StorageClassList listStorageClass(@QueryValue(value="pretty") @Nullable String var1, @QueryValue(value="allowWatchBookmarks") @Nullable Boolean var2, @QueryValue(value="continue") @Nullable String var3, @QueryValue(value="fieldSelector") @Nullable String var4, @QueryValue(value="labelSelector") @Nullable String var5, @QueryValue(value="limit") @Nullable Integer var6, @QueryValue(value="resourceVersion") @Nullable String var7, @QueryValue(value="resourceVersionMatch") @Nullable String var8, @QueryValue(value="sendInitialEvents") @Nullable Boolean var9, @QueryValue(value="timeoutSeconds") @Nullable Integer var10, @QueryValue(value="watch") @Nullable Boolean var11);

    @Get(value="/apis/storage.k8s.io/v1/volumeattachments")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"})
    public V1VolumeAttachmentList listVolumeAttachment(@QueryValue(value="pretty") @Nullable String var1, @QueryValue(value="allowWatchBookmarks") @Nullable Boolean var2, @QueryValue(value="continue") @Nullable String var3, @QueryValue(value="fieldSelector") @Nullable String var4, @QueryValue(value="labelSelector") @Nullable String var5, @QueryValue(value="limit") @Nullable Integer var6, @QueryValue(value="resourceVersion") @Nullable String var7, @QueryValue(value="resourceVersionMatch") @Nullable String var8, @QueryValue(value="sendInitialEvents") @Nullable Boolean var9, @QueryValue(value="timeoutSeconds") @Nullable Integer var10, @QueryValue(value="watch") @Nullable Boolean var11);

    @Patch(value="/apis/storage.k8s.io/v1/csidrivers/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1CSIDriver patchCSIDriver(@PathVariable(value="name") @NotNull String var1, @Body @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldManager") @Nullable String var5, @QueryValue(value="fieldValidation") @Nullable String var6, @QueryValue(value="force") @Nullable Boolean var7);

    @Patch(value="/apis/storage.k8s.io/v1/csinodes/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1CSINode patchCSINode(@PathVariable(value="name") @NotNull String var1, @Body @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldManager") @Nullable String var5, @QueryValue(value="fieldValidation") @Nullable String var6, @QueryValue(value="force") @Nullable Boolean var7);

    @Patch(value="/apis/storage.k8s.io/v1/namespaces/{namespace}/csistoragecapacities/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1CSIStorageCapacity patchNamespacedCSIStorageCapacity(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull String var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7, @QueryValue(value="force") @Nullable Boolean var8);

    @Patch(value="/apis/storage.k8s.io/v1/storageclasses/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1StorageClass patchStorageClass(@PathVariable(value="name") @NotNull String var1, @Body @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldManager") @Nullable String var5, @QueryValue(value="fieldValidation") @Nullable String var6, @QueryValue(value="force") @Nullable Boolean var7);

    @Patch(value="/apis/storage.k8s.io/v1/volumeattachments/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1VolumeAttachment patchVolumeAttachment(@PathVariable(value="name") @NotNull String var1, @Body @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldManager") @Nullable String var5, @QueryValue(value="fieldValidation") @Nullable String var6, @QueryValue(value="force") @Nullable Boolean var7);

    @Patch(value="/apis/storage.k8s.io/v1/volumeattachments/{name}/status")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1VolumeAttachment patchVolumeAttachmentStatus(@PathVariable(value="name") @NotNull String var1, @Body @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldManager") @Nullable String var5, @QueryValue(value="fieldValidation") @Nullable String var6, @QueryValue(value="force") @Nullable Boolean var7);

    @Get(value="/apis/storage.k8s.io/v1/csidrivers/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1CSIDriver readCSIDriver(@PathVariable(value="name") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2);

    @Get(value="/apis/storage.k8s.io/v1/csinodes/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1CSINode readCSINode(@PathVariable(value="name") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2);

    @Get(value="/apis/storage.k8s.io/v1/namespaces/{namespace}/csistoragecapacities/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1CSIStorageCapacity readNamespacedCSIStorageCapacity(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @QueryValue(value="pretty") @Nullable String var3);

    @Get(value="/apis/storage.k8s.io/v1/storageclasses/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1StorageClass readStorageClass(@PathVariable(value="name") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2);

    @Get(value="/apis/storage.k8s.io/v1/volumeattachments/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1VolumeAttachment readVolumeAttachment(@PathVariable(value="name") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2);

    @Get(value="/apis/storage.k8s.io/v1/volumeattachments/{name}/status")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1VolumeAttachment readVolumeAttachmentStatus(@PathVariable(value="name") @NotNull String var1, @QueryValue(value="pretty") @Nullable String var2);

    @Put(value="/apis/storage.k8s.io/v1/csidrivers/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1CSIDriver replaceCSIDriver(@PathVariable(value="name") @NotNull String var1, @Body @NotNull @Valid V1CSIDriver var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldManager") @Nullable String var5, @QueryValue(value="fieldValidation") @Nullable String var6);

    @Put(value="/apis/storage.k8s.io/v1/csinodes/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1CSINode replaceCSINode(@PathVariable(value="name") @NotNull String var1, @Body @NotNull @Valid V1CSINode var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldManager") @Nullable String var5, @QueryValue(value="fieldValidation") @Nullable String var6);

    @Put(value="/apis/storage.k8s.io/v1/namespaces/{namespace}/csistoragecapacities/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1CSIStorageCapacity replaceNamespacedCSIStorageCapacity(@PathVariable(value="name") @NotNull String var1, @PathVariable(value="namespace") @NotNull String var2, @Body @NotNull @Valid V1CSIStorageCapacity var3, @QueryValue(value="pretty") @Nullable String var4, @QueryValue(value="dryRun") @Nullable String var5, @QueryValue(value="fieldManager") @Nullable String var6, @QueryValue(value="fieldValidation") @Nullable String var7);

    @Put(value="/apis/storage.k8s.io/v1/storageclasses/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1StorageClass replaceStorageClass(@PathVariable(value="name") @NotNull String var1, @Body @NotNull @Valid V1StorageClass var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldManager") @Nullable String var5, @QueryValue(value="fieldValidation") @Nullable String var6);

    @Put(value="/apis/storage.k8s.io/v1/volumeattachments/{name}")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1VolumeAttachment replaceVolumeAttachment(@PathVariable(value="name") @NotNull String var1, @Body @NotNull @Valid V1VolumeAttachment var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldManager") @Nullable String var5, @QueryValue(value="fieldValidation") @Nullable String var6);

    @Put(value="/apis/storage.k8s.io/v1/volumeattachments/{name}/status")
    @Consumes(value={"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"})
    public V1VolumeAttachment replaceVolumeAttachmentStatus(@PathVariable(value="name") @NotNull String var1, @Body @NotNull @Valid V1VolumeAttachment var2, @QueryValue(value="pretty") @Nullable String var3, @QueryValue(value="dryRun") @Nullable String var4, @QueryValue(value="fieldManager") @Nullable String var5, @QueryValue(value="fieldValidation") @Nullable String var6);
}

