/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.reactor;

import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.AdmissionregistrationV1beta1Api;
import io.kubernetes.client.openapi.models.V1APIResourceList;
import io.kubernetes.client.openapi.models.V1DeleteOptions;
import io.kubernetes.client.openapi.models.V1Status;
import io.kubernetes.client.openapi.models.V1beta1MutatingWebhookConfiguration;
import io.kubernetes.client.openapi.models.V1beta1MutatingWebhookConfigurationList;
import io.kubernetes.client.openapi.models.V1beta1ValidatingWebhookConfiguration;
import io.kubernetes.client.openapi.models.V1beta1ValidatingWebhookConfigurationList;
import io.micronaut.context.annotation.Requires;
import io.micronaut.kubernetes.client.reactor.AsyncCallbackSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(beans={AdmissionregistrationV1beta1Api.class})
@Singleton
public class AdmissionregistrationV1beta1ApiReactorClient {
    private final AdmissionregistrationV1beta1Api client;

    AdmissionregistrationV1beta1ApiReactorClient(AdmissionregistrationV1beta1Api client) {
        this.client = client;
    }

    public Mono<V1beta1MutatingWebhookConfiguration> createMutatingWebhookConfiguration(V1beta1MutatingWebhookConfiguration body, String pretty, String dryRun, String fieldManager) {
        return Mono.create(sink -> {
            try {
                this.client.createMutatingWebhookConfigurationAsync(body, pretty, dryRun, fieldManager, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1beta1ValidatingWebhookConfiguration> createValidatingWebhookConfiguration(V1beta1ValidatingWebhookConfiguration body, String pretty, String dryRun, String fieldManager) {
        return Mono.create(sink -> {
            try {
                this.client.createValidatingWebhookConfigurationAsync(body, pretty, dryRun, fieldManager, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Status> deleteCollectionMutatingWebhookConfiguration(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteCollectionMutatingWebhookConfigurationAsync(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, timeoutSeconds, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Status> deleteCollectionValidatingWebhookConfiguration(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteCollectionValidatingWebhookConfigurationAsync(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, timeoutSeconds, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Status> deleteMutatingWebhookConfiguration(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteMutatingWebhookConfigurationAsync(name, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Status> deleteValidatingWebhookConfiguration(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteValidatingWebhookConfigurationAsync(name, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1APIResourceList> getAPIResources() {
        return Mono.create(sink -> {
            try {
                this.client.getAPIResourcesAsync(new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1beta1MutatingWebhookConfigurationList> listMutatingWebhookConfiguration(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Mono.create(sink -> {
            try {
                this.client.listMutatingWebhookConfigurationAsync(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1beta1ValidatingWebhookConfigurationList> listValidatingWebhookConfiguration(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Mono.create(sink -> {
            try {
                this.client.listValidatingWebhookConfigurationAsync(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1beta1MutatingWebhookConfiguration> patchMutatingWebhookConfiguration(String name, V1Patch body, String pretty, String dryRun, String fieldManager, Boolean force) {
        return Mono.create(sink -> {
            try {
                this.client.patchMutatingWebhookConfigurationAsync(name, body, pretty, dryRun, fieldManager, force, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1beta1ValidatingWebhookConfiguration> patchValidatingWebhookConfiguration(String name, V1Patch body, String pretty, String dryRun, String fieldManager, Boolean force) {
        return Mono.create(sink -> {
            try {
                this.client.patchValidatingWebhookConfigurationAsync(name, body, pretty, dryRun, fieldManager, force, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1beta1MutatingWebhookConfiguration> readMutatingWebhookConfiguration(String name, String pretty, Boolean exact, Boolean export) {
        return Mono.create(sink -> {
            try {
                this.client.readMutatingWebhookConfigurationAsync(name, pretty, exact, export, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1beta1ValidatingWebhookConfiguration> readValidatingWebhookConfiguration(String name, String pretty, Boolean exact, Boolean export) {
        return Mono.create(sink -> {
            try {
                this.client.readValidatingWebhookConfigurationAsync(name, pretty, exact, export, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1beta1MutatingWebhookConfiguration> replaceMutatingWebhookConfiguration(String name, V1beta1MutatingWebhookConfiguration body, String pretty, String dryRun, String fieldManager) {
        return Mono.create(sink -> {
            try {
                this.client.replaceMutatingWebhookConfigurationAsync(name, body, pretty, dryRun, fieldManager, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1beta1ValidatingWebhookConfiguration> replaceValidatingWebhookConfiguration(String name, V1beta1ValidatingWebhookConfiguration body, String pretty, String dryRun, String fieldManager) {
        return Mono.create(sink -> {
            try {
                this.client.replaceValidatingWebhookConfigurationAsync(name, body, pretty, dryRun, fieldManager, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }
}

