/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.reactor;

import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.ApiregistrationV1Api;
import io.kubernetes.client.openapi.models.V1APIResourceList;
import io.kubernetes.client.openapi.models.V1APIService;
import io.kubernetes.client.openapi.models.V1APIServiceList;
import io.kubernetes.client.openapi.models.V1DeleteOptions;
import io.kubernetes.client.openapi.models.V1Status;
import io.micronaut.context.annotation.Requires;
import io.micronaut.kubernetes.client.reactor.AsyncCallbackSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(beans={ApiregistrationV1Api.class})
@Singleton
public class ApiregistrationV1ApiReactorClient {
    private final ApiregistrationV1Api client;

    ApiregistrationV1ApiReactorClient(ApiregistrationV1Api client) {
        this.client = client;
    }

    public Mono<V1APIService> createAPIService(V1APIService body, String pretty, String dryRun, String fieldManager) {
        return Mono.create(sink -> {
            try {
                this.client.createAPIServiceAsync(body, pretty, dryRun, fieldManager, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Status> deleteAPIService(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteAPIServiceAsync(name, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Status> deleteCollectionAPIService(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteCollectionAPIServiceAsync(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, timeoutSeconds, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1APIResourceList> getAPIResources() {
        return Mono.create(sink -> {
            try {
                this.client.getAPIResourcesAsync(new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1APIServiceList> listAPIService(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Mono.create(sink -> {
            try {
                this.client.listAPIServiceAsync(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1APIService> patchAPIService(String name, V1Patch body, String pretty, String dryRun, String fieldManager, Boolean force) {
        return Mono.create(sink -> {
            try {
                this.client.patchAPIServiceAsync(name, body, pretty, dryRun, fieldManager, force, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1APIService> patchAPIServiceStatus(String name, V1Patch body, String pretty, String dryRun, String fieldManager, Boolean force) {
        return Mono.create(sink -> {
            try {
                this.client.patchAPIServiceStatusAsync(name, body, pretty, dryRun, fieldManager, force, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1APIService> readAPIService(String name, String pretty, Boolean exact, Boolean export) {
        return Mono.create(sink -> {
            try {
                this.client.readAPIServiceAsync(name, pretty, exact, export, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1APIService> readAPIServiceStatus(String name, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.readAPIServiceStatusAsync(name, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1APIService> replaceAPIService(String name, V1APIService body, String pretty, String dryRun, String fieldManager) {
        return Mono.create(sink -> {
            try {
                this.client.replaceAPIServiceAsync(name, body, pretty, dryRun, fieldManager, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1APIService> replaceAPIServiceStatus(String name, V1APIService body, String pretty, String dryRun, String fieldManager) {
        return Mono.create(sink -> {
            try {
                this.client.replaceAPIServiceStatusAsync(name, body, pretty, dryRun, fieldManager, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }
}

