/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.reactor;

import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.InternalApiserverV1alpha1Api;
import io.kubernetes.client.openapi.models.V1APIResourceList;
import io.kubernetes.client.openapi.models.V1DeleteOptions;
import io.kubernetes.client.openapi.models.V1Status;
import io.kubernetes.client.openapi.models.V1alpha1StorageVersion;
import io.kubernetes.client.openapi.models.V1alpha1StorageVersionList;
import io.micronaut.context.annotation.Requires;
import io.micronaut.kubernetes.client.reactor.AsyncCallbackSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(beans={InternalApiserverV1alpha1Api.class})
@Singleton
public class InternalApiserverV1alpha1ApiReactorClient {
    private final InternalApiserverV1alpha1Api client;

    InternalApiserverV1alpha1ApiReactorClient(InternalApiserverV1alpha1Api client) {
        this.client = client;
    }

    public Mono<V1alpha1StorageVersion> createStorageVersion(V1alpha1StorageVersion body, String pretty, String dryRun, String fieldManager) {
        return Mono.create(sink -> {
            try {
                this.client.createStorageVersionAsync(body, pretty, dryRun, fieldManager, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Status> deleteCollectionStorageVersion(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteCollectionStorageVersionAsync(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, timeoutSeconds, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Status> deleteStorageVersion(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteStorageVersionAsync(name, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1APIResourceList> getAPIResources() {
        return Mono.create(sink -> {
            try {
                this.client.getAPIResourcesAsync(new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1alpha1StorageVersionList> listStorageVersion(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Mono.create(sink -> {
            try {
                this.client.listStorageVersionAsync(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1alpha1StorageVersion> patchStorageVersion(String name, V1Patch body, String pretty, String dryRun, String fieldManager, Boolean force) {
        return Mono.create(sink -> {
            try {
                this.client.patchStorageVersionAsync(name, body, pretty, dryRun, fieldManager, force, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1alpha1StorageVersion> patchStorageVersionStatus(String name, V1Patch body, String pretty, String dryRun, String fieldManager, Boolean force) {
        return Mono.create(sink -> {
            try {
                this.client.patchStorageVersionStatusAsync(name, body, pretty, dryRun, fieldManager, force, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1alpha1StorageVersion> readStorageVersion(String name, String pretty, Boolean exact, Boolean export) {
        return Mono.create(sink -> {
            try {
                this.client.readStorageVersionAsync(name, pretty, exact, export, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1alpha1StorageVersion> readStorageVersionStatus(String name, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.readStorageVersionStatusAsync(name, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1alpha1StorageVersion> replaceStorageVersion(String name, V1alpha1StorageVersion body, String pretty, String dryRun, String fieldManager) {
        return Mono.create(sink -> {
            try {
                this.client.replaceStorageVersionAsync(name, body, pretty, dryRun, fieldManager, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1alpha1StorageVersion> replaceStorageVersionStatus(String name, V1alpha1StorageVersion body, String pretty, String dryRun, String fieldManager) {
        return Mono.create(sink -> {
            try {
                this.client.replaceStorageVersionStatusAsync(name, body, pretty, dryRun, fieldManager, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }
}

