/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.reactor;

import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.LogsApi;
import io.micronaut.context.annotation.Requires;
import io.micronaut.kubernetes.client.reactor.AsyncCallbackSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(beans={LogsApi.class})
@Singleton
public class LogsApiReactorClient {
    private final LogsApi client;

    LogsApiReactorClient(LogsApi client) {
        this.client = client;
    }

    public Mono<Void> logFileHandler(String logpath) {
        return Mono.create(sink -> {
            try {
                this.client.logFileHandlerAsync(logpath, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<Void> logFileListHandler() {
        return Mono.create(sink -> {
            try {
                this.client.logFileListHandlerAsync(new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }
}

