/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.reactor;

import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.VersionApi;
import io.kubernetes.client.openapi.models.VersionInfo;
import io.micronaut.context.annotation.Requires;
import io.micronaut.kubernetes.client.reactor.AsyncCallbackSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(beans={VersionApi.class})
@Singleton
public class VersionApiReactorClient {
    private final VersionApi client;

    VersionApiReactorClient(VersionApi client) {
        this.client = client;
    }

    public Mono<VersionInfo> getCode() {
        return Mono.create(sink -> {
            try {
                this.client.getCodeAsync(new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }
}

