/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.reactor;

import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.AuthorizationV1beta1Api;
import io.kubernetes.client.openapi.models.V1APIResourceList;
import io.kubernetes.client.openapi.models.V1beta1LocalSubjectAccessReview;
import io.kubernetes.client.openapi.models.V1beta1SelfSubjectAccessReview;
import io.kubernetes.client.openapi.models.V1beta1SelfSubjectRulesReview;
import io.kubernetes.client.openapi.models.V1beta1SubjectAccessReview;
import io.micronaut.context.annotation.Requires;
import io.micronaut.kubernetes.client.reactor.AsyncCallbackSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(beans={AuthorizationV1beta1Api.class})
@Singleton
public class AuthorizationV1beta1ApiReactorClient {
    private final AuthorizationV1beta1Api client;

    AuthorizationV1beta1ApiReactorClient(AuthorizationV1beta1Api client) {
        this.client = client;
    }

    public Mono<V1beta1LocalSubjectAccessReview> createNamespacedLocalSubjectAccessReview(String namespace, V1beta1LocalSubjectAccessReview body, String dryRun, String fieldManager, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.createNamespacedLocalSubjectAccessReviewAsync(namespace, body, dryRun, fieldManager, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1beta1SelfSubjectAccessReview> createSelfSubjectAccessReview(V1beta1SelfSubjectAccessReview body, String dryRun, String fieldManager, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.createSelfSubjectAccessReviewAsync(body, dryRun, fieldManager, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1beta1SelfSubjectRulesReview> createSelfSubjectRulesReview(V1beta1SelfSubjectRulesReview body, String dryRun, String fieldManager, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.createSelfSubjectRulesReviewAsync(body, dryRun, fieldManager, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1beta1SubjectAccessReview> createSubjectAccessReview(V1beta1SubjectAccessReview body, String dryRun, String fieldManager, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.createSubjectAccessReviewAsync(body, dryRun, fieldManager, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1APIResourceList> getAPIResources() {
        return Mono.create(sink -> {
            try {
                this.client.getAPIResourcesAsync(new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }
}

