/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.reactor;

import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.AuthenticationV1beta1Api;
import io.kubernetes.client.openapi.models.V1APIResourceList;
import io.kubernetes.client.openapi.models.V1beta1TokenReview;
import io.micronaut.context.annotation.Requires;
import io.micronaut.kubernetes.client.reactor.AsyncCallbackSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(beans={AuthenticationV1beta1Api.class})
@Singleton
public class AuthenticationV1beta1ApiReactorClient {
    private final AuthenticationV1beta1Api client;

    AuthenticationV1beta1ApiReactorClient(AuthenticationV1beta1Api client) {
        this.client = client;
    }

    public Mono<V1beta1TokenReview> createTokenReview(V1beta1TokenReview body, String dryRun, String fieldManager, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.createTokenReviewAsync(body, dryRun, fieldManager, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1APIResourceList> getAPIResources() {
        return Mono.create(sink -> {
            try {
                this.client.getAPIResourcesAsync(new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }
}

