/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.reactor;

import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CoreApi;
import io.kubernetes.client.openapi.models.V1APIVersions;
import io.micronaut.context.annotation.Requires;
import io.micronaut.kubernetes.client.reactor.AsyncCallbackSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(beans={CoreApi.class})
@Singleton
public class CoreApiReactorClient {
    private final CoreApi client;

    CoreApiReactorClient(CoreApi client) {
        this.client = client;
    }

    public Mono<V1APIVersions> getAPIVersions() {
        return Mono.create(sink -> {
            try {
                this.client.getAPIVersionsAsync(new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }
}

