/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.reactor;

import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.EventsApi;
import io.kubernetes.client.openapi.models.V1APIGroup;
import io.micronaut.context.annotation.Requires;
import io.micronaut.kubernetes.client.reactor.AsyncCallbackSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(beans={EventsApi.class})
@Singleton
public class EventsApiReactorClient {
    private final EventsApi client;

    EventsApiReactorClient(EventsApi client) {
        this.client = client;
    }

    public Mono<V1APIGroup> getAPIGroup() {
        return Mono.create(sink -> {
            try {
                this.client.getAPIGroupAsync(new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }
}

