/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.reactor;

import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.ApisApi;
import io.kubernetes.client.openapi.models.V1APIGroupList;
import io.micronaut.context.annotation.Requires;
import io.micronaut.kubernetes.client.reactor.AsyncCallbackSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(beans={ApisApi.class})
@Singleton
public class ApisApiReactorClient {
    private final ApisApi client;

    ApisApiReactorClient(ApisApi client) {
        this.client = client;
    }

    public Mono<V1APIGroupList> getAPIVersions() {
        return Mono.create(sink -> {
            try {
                this.client.getAPIVersionsAsync(new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }
}

