/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.reactor;

import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.AuthorizationV1Api;
import io.kubernetes.client.openapi.models.V1APIResourceList;
import io.kubernetes.client.openapi.models.V1LocalSubjectAccessReview;
import io.kubernetes.client.openapi.models.V1SelfSubjectAccessReview;
import io.kubernetes.client.openapi.models.V1SelfSubjectRulesReview;
import io.kubernetes.client.openapi.models.V1SubjectAccessReview;
import io.micronaut.context.annotation.Requires;
import io.micronaut.kubernetes.client.reactor.AsyncCallbackSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(beans={AuthorizationV1Api.class})
@Singleton
public class AuthorizationV1ApiReactorClient {
    private final AuthorizationV1Api client;

    AuthorizationV1ApiReactorClient(AuthorizationV1Api client) {
        this.client = client;
    }

    public Mono<V1LocalSubjectAccessReview> createNamespacedLocalSubjectAccessReview(String namespace, V1LocalSubjectAccessReview body, String dryRun, String fieldManager, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.createNamespacedLocalSubjectAccessReviewAsync(namespace, body, dryRun, fieldManager, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1SelfSubjectAccessReview> createSelfSubjectAccessReview(V1SelfSubjectAccessReview body, String dryRun, String fieldManager, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.createSelfSubjectAccessReviewAsync(body, dryRun, fieldManager, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1SelfSubjectRulesReview> createSelfSubjectRulesReview(V1SelfSubjectRulesReview body, String dryRun, String fieldManager, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.createSelfSubjectRulesReviewAsync(body, dryRun, fieldManager, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1SubjectAccessReview> createSubjectAccessReview(V1SubjectAccessReview body, String dryRun, String fieldManager, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.createSubjectAccessReviewAsync(body, dryRun, fieldManager, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1APIResourceList> getAPIResources() {
        return Mono.create(sink -> {
            try {
                this.client.getAPIResourcesAsync(new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }
}

