/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.reactor;

import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CertificatesApi;
import io.kubernetes.client.openapi.models.V1APIGroup;
import io.micronaut.context.annotation.Requires;
import io.micronaut.kubernetes.client.reactor.AsyncCallbackSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(beans={CertificatesApi.class})
@Singleton
public class CertificatesApiReactorClient {
    private final CertificatesApi client;

    CertificatesApiReactorClient(CertificatesApi client) {
        this.client = client;
    }

    public Mono<V1APIGroup> getAPIGroup() {
        return Mono.create(sink -> {
            try {
                this.client.getAPIGroupAsync(new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }
}

