/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.reactor;

import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CustomObjectsApi;
import io.kubernetes.client.openapi.models.V1DeleteOptions;
import io.micronaut.context.annotation.Requires;
import io.micronaut.kubernetes.client.reactor.AsyncCallbackSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(beans={CustomObjectsApi.class})
@Singleton
public class CustomObjectsApiReactorClient {
    private final CustomObjectsApi client;

    CustomObjectsApiReactorClient(CustomObjectsApi client) {
        this.client = client;
    }

    public Mono<Object> createClusterCustomObject(String group, String version, String plural, Object body, String pretty, String dryRun, String fieldManager) {
        return Mono.create(sink -> {
            try {
                this.client.createClusterCustomObjectAsync(group, version, plural, body, pretty, dryRun, fieldManager, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<Object> createNamespacedCustomObject(String group, String version, String namespace, String plural, Object body, String pretty, String dryRun, String fieldManager) {
        return Mono.create(sink -> {
            try {
                this.client.createNamespacedCustomObjectAsync(group, version, namespace, plural, body, pretty, dryRun, fieldManager, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<Object> deleteClusterCustomObject(String group, String version, String plural, String name, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, String dryRun, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteClusterCustomObjectAsync(group, version, plural, name, gracePeriodSeconds, orphanDependents, propagationPolicy, dryRun, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<Object> deleteCollectionClusterCustomObject(String group, String version, String plural, String pretty, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, String dryRun, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteCollectionClusterCustomObjectAsync(group, version, plural, pretty, gracePeriodSeconds, orphanDependents, propagationPolicy, dryRun, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<Object> deleteCollectionNamespacedCustomObject(String group, String version, String namespace, String plural, String pretty, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, String dryRun, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteCollectionNamespacedCustomObjectAsync(group, version, namespace, plural, pretty, gracePeriodSeconds, orphanDependents, propagationPolicy, dryRun, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<Object> deleteNamespacedCustomObject(String group, String version, String namespace, String plural, String name, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, String dryRun, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteNamespacedCustomObjectAsync(group, version, namespace, plural, name, gracePeriodSeconds, orphanDependents, propagationPolicy, dryRun, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<Object> getClusterCustomObject(String group, String version, String plural, String name) {
        return Mono.create(sink -> {
            try {
                this.client.getClusterCustomObjectAsync(group, version, plural, name, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<Object> getClusterCustomObjectScale(String group, String version, String plural, String name) {
        return Mono.create(sink -> {
            try {
                this.client.getClusterCustomObjectScaleAsync(group, version, plural, name, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<Object> getClusterCustomObjectStatus(String group, String version, String plural, String name) {
        return Mono.create(sink -> {
            try {
                this.client.getClusterCustomObjectStatusAsync(group, version, plural, name, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<Object> getNamespacedCustomObject(String group, String version, String namespace, String plural, String name) {
        return Mono.create(sink -> {
            try {
                this.client.getNamespacedCustomObjectAsync(group, version, namespace, plural, name, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<Object> getNamespacedCustomObjectScale(String group, String version, String namespace, String plural, String name) {
        return Mono.create(sink -> {
            try {
                this.client.getNamespacedCustomObjectScaleAsync(group, version, namespace, plural, name, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<Object> getNamespacedCustomObjectStatus(String group, String version, String namespace, String plural, String name) {
        return Mono.create(sink -> {
            try {
                this.client.getNamespacedCustomObjectStatusAsync(group, version, namespace, plural, name, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<Object> listClusterCustomObject(String group, String version, String plural, String pretty, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, Integer timeoutSeconds) {
        return Mono.create(sink -> {
            try {
                this.client.listClusterCustomObjectAsync(group, version, plural, pretty, _continue, fieldSelector, labelSelector, limit, resourceVersion, timeoutSeconds, Boolean.FALSE, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<Object> listNamespacedCustomObject(String group, String version, String namespace, String plural, String pretty, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, Integer timeoutSeconds) {
        return Mono.create(sink -> {
            try {
                this.client.listNamespacedCustomObjectAsync(group, version, namespace, plural, pretty, _continue, fieldSelector, labelSelector, limit, resourceVersion, timeoutSeconds, Boolean.FALSE, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<Object> patchClusterCustomObject(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager, Boolean force) {
        return Mono.create(sink -> {
            try {
                this.client.patchClusterCustomObjectAsync(group, version, plural, name, body, dryRun, fieldManager, force, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<Object> patchClusterCustomObjectScale(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager, Boolean force) {
        return Mono.create(sink -> {
            try {
                this.client.patchClusterCustomObjectScaleAsync(group, version, plural, name, body, dryRun, fieldManager, force, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<Object> patchClusterCustomObjectStatus(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager, Boolean force) {
        return Mono.create(sink -> {
            try {
                this.client.patchClusterCustomObjectStatusAsync(group, version, plural, name, body, dryRun, fieldManager, force, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<Object> patchNamespacedCustomObject(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager, Boolean force) {
        return Mono.create(sink -> {
            try {
                this.client.patchNamespacedCustomObjectAsync(group, version, namespace, plural, name, body, dryRun, fieldManager, force, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<Object> patchNamespacedCustomObjectScale(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager, Boolean force) {
        return Mono.create(sink -> {
            try {
                this.client.patchNamespacedCustomObjectScaleAsync(group, version, namespace, plural, name, body, dryRun, fieldManager, force, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<Object> patchNamespacedCustomObjectStatus(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager, Boolean force) {
        return Mono.create(sink -> {
            try {
                this.client.patchNamespacedCustomObjectStatusAsync(group, version, namespace, plural, name, body, dryRun, fieldManager, force, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<Object> replaceClusterCustomObject(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager) {
        return Mono.create(sink -> {
            try {
                this.client.replaceClusterCustomObjectAsync(group, version, plural, name, body, dryRun, fieldManager, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<Object> replaceClusterCustomObjectScale(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager) {
        return Mono.create(sink -> {
            try {
                this.client.replaceClusterCustomObjectScaleAsync(group, version, plural, name, body, dryRun, fieldManager, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<Object> replaceClusterCustomObjectStatus(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager) {
        return Mono.create(sink -> {
            try {
                this.client.replaceClusterCustomObjectStatusAsync(group, version, plural, name, body, dryRun, fieldManager, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<Object> replaceNamespacedCustomObject(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager) {
        return Mono.create(sink -> {
            try {
                this.client.replaceNamespacedCustomObjectAsync(group, version, namespace, plural, name, body, dryRun, fieldManager, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<Object> replaceNamespacedCustomObjectScale(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager) {
        return Mono.create(sink -> {
            try {
                this.client.replaceNamespacedCustomObjectScaleAsync(group, version, namespace, plural, name, body, dryRun, fieldManager, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<Object> replaceNamespacedCustomObjectStatus(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager) {
        return Mono.create(sink -> {
            try {
                this.client.replaceNamespacedCustomObjectStatusAsync(group, version, namespace, plural, name, body, dryRun, fieldManager, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }
}

