/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.reactor;

import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.EventsV1Api;
import io.kubernetes.client.openapi.models.EventsV1Event;
import io.kubernetes.client.openapi.models.EventsV1EventList;
import io.kubernetes.client.openapi.models.V1APIResourceList;
import io.kubernetes.client.openapi.models.V1DeleteOptions;
import io.kubernetes.client.openapi.models.V1Status;
import io.micronaut.context.annotation.Requires;
import io.micronaut.kubernetes.client.reactor.AsyncCallbackSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(beans={EventsV1Api.class})
@Singleton
public class EventsV1ApiReactorClient {
    private final EventsV1Api client;

    EventsV1ApiReactorClient(EventsV1Api client) {
        this.client = client;
    }

    public Mono<EventsV1Event> createNamespacedEvent(String namespace, EventsV1Event body, String pretty, String dryRun, String fieldManager) {
        return Mono.create(sink -> {
            try {
                this.client.createNamespacedEventAsync(namespace, body, pretty, dryRun, fieldManager, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Status> deleteCollectionNamespacedEvent(String namespace, String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteCollectionNamespacedEventAsync(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, timeoutSeconds, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Status> deleteNamespacedEvent(String name, String namespace, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteNamespacedEventAsync(name, namespace, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1APIResourceList> getAPIResources() {
        return Mono.create(sink -> {
            try {
                this.client.getAPIResourcesAsync(new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<EventsV1EventList> listEventForAllNamespaces(Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String pretty, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Mono.create(sink -> {
            try {
                this.client.listEventForAllNamespacesAsync(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<EventsV1EventList> listNamespacedEvent(String namespace, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Mono.create(sink -> {
            try {
                this.client.listNamespacedEventAsync(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<EventsV1Event> patchNamespacedEvent(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, Boolean force) {
        return Mono.create(sink -> {
            try {
                this.client.patchNamespacedEventAsync(name, namespace, body, pretty, dryRun, fieldManager, force, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<EventsV1Event> readNamespacedEvent(String name, String namespace, String pretty, Boolean exact, Boolean export) {
        return Mono.create(sink -> {
            try {
                this.client.readNamespacedEventAsync(name, namespace, pretty, exact, export, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<EventsV1Event> replaceNamespacedEvent(String name, String namespace, EventsV1Event body, String pretty, String dryRun, String fieldManager) {
        return Mono.create(sink -> {
            try {
                this.client.replaceNamespacedEventAsync(name, namespace, body, pretty, dryRun, fieldManager, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }
}

