/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.reactor;

import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.OpenidApi;
import io.micronaut.context.annotation.Requires;
import io.micronaut.kubernetes.client.reactor.AsyncCallbackSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(beans={OpenidApi.class})
@Singleton
public class OpenidApiReactorClient {
    private final OpenidApi client;

    OpenidApiReactorClient(OpenidApi client) {
        this.client = client;
    }

    public Mono<String> getServiceAccountIssuerOpenIDKeyset() {
        return Mono.create(sink -> {
            try {
                this.client.getServiceAccountIssuerOpenIDKeysetAsync(new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }
}

