/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.reactor;

import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.WellKnownApi;
import io.micronaut.context.annotation.Requires;
import io.micronaut.kubernetes.client.reactor.AsyncCallbackSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(beans={WellKnownApi.class})
@Singleton
public class WellKnownApiReactorClient {
    private final WellKnownApi client;

    WellKnownApiReactorClient(WellKnownApi client) {
        this.client = client;
    }

    public Mono<String> getServiceAccountIssuerOpenIDConfiguration() {
        return Mono.create(sink -> {
            try {
                this.client.getServiceAccountIssuerOpenIDConfigurationAsync(new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }
}

