/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.reactor;

import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.AuthenticationV1TokenRequest;
import io.kubernetes.client.openapi.models.CoreV1Event;
import io.kubernetes.client.openapi.models.CoreV1EventList;
import io.kubernetes.client.openapi.models.V1APIResourceList;
import io.kubernetes.client.openapi.models.V1Binding;
import io.kubernetes.client.openapi.models.V1ComponentStatus;
import io.kubernetes.client.openapi.models.V1ComponentStatusList;
import io.kubernetes.client.openapi.models.V1ConfigMap;
import io.kubernetes.client.openapi.models.V1ConfigMapList;
import io.kubernetes.client.openapi.models.V1DeleteOptions;
import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1EndpointsList;
import io.kubernetes.client.openapi.models.V1Eviction;
import io.kubernetes.client.openapi.models.V1LimitRange;
import io.kubernetes.client.openapi.models.V1LimitRangeList;
import io.kubernetes.client.openapi.models.V1Namespace;
import io.kubernetes.client.openapi.models.V1NamespaceList;
import io.kubernetes.client.openapi.models.V1Node;
import io.kubernetes.client.openapi.models.V1NodeList;
import io.kubernetes.client.openapi.models.V1PersistentVolume;
import io.kubernetes.client.openapi.models.V1PersistentVolumeClaim;
import io.kubernetes.client.openapi.models.V1PersistentVolumeClaimList;
import io.kubernetes.client.openapi.models.V1PersistentVolumeList;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1PodList;
import io.kubernetes.client.openapi.models.V1PodTemplate;
import io.kubernetes.client.openapi.models.V1PodTemplateList;
import io.kubernetes.client.openapi.models.V1ReplicationController;
import io.kubernetes.client.openapi.models.V1ReplicationControllerList;
import io.kubernetes.client.openapi.models.V1ResourceQuota;
import io.kubernetes.client.openapi.models.V1ResourceQuotaList;
import io.kubernetes.client.openapi.models.V1Scale;
import io.kubernetes.client.openapi.models.V1Secret;
import io.kubernetes.client.openapi.models.V1SecretList;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServiceAccount;
import io.kubernetes.client.openapi.models.V1ServiceAccountList;
import io.kubernetes.client.openapi.models.V1ServiceList;
import io.kubernetes.client.openapi.models.V1Status;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Requires;
import io.micronaut.kubernetes.client.reactor.AsyncCallbackSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(beans={CoreV1Api.class})
@Singleton
@BootstrapContextCompatible
public class CoreV1ApiReactorClient {
    private final CoreV1Api client;

    CoreV1ApiReactorClient(CoreV1Api client) {
        this.client = client;
    }

    public Mono<String> connectDeleteNamespacedPodProxy(String name, String namespace, String path) {
        return Mono.create(sink -> {
            try {
                this.client.connectDeleteNamespacedPodProxyAsync(name, namespace, path, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectDeleteNamespacedPodProxyWithPath(String name, String namespace, String path, String path2) {
        return Mono.create(sink -> {
            try {
                this.client.connectDeleteNamespacedPodProxyWithPathAsync(name, namespace, path, path2, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectDeleteNamespacedServiceProxy(String name, String namespace, String path) {
        return Mono.create(sink -> {
            try {
                this.client.connectDeleteNamespacedServiceProxyAsync(name, namespace, path, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectDeleteNamespacedServiceProxyWithPath(String name, String namespace, String path, String path2) {
        return Mono.create(sink -> {
            try {
                this.client.connectDeleteNamespacedServiceProxyWithPathAsync(name, namespace, path, path2, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectDeleteNodeProxy(String name, String path) {
        return Mono.create(sink -> {
            try {
                this.client.connectDeleteNodeProxyAsync(name, path, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectDeleteNodeProxyWithPath(String name, String path, String path2) {
        return Mono.create(sink -> {
            try {
                this.client.connectDeleteNodeProxyWithPathAsync(name, path, path2, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectGetNamespacedPodAttach(String name, String namespace, String container, Boolean stderr, Boolean stdin, Boolean stdout, Boolean tty) {
        return Mono.create(sink -> {
            try {
                this.client.connectGetNamespacedPodAttachAsync(name, namespace, container, stderr, stdin, stdout, tty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectGetNamespacedPodExec(String name, String namespace, String command, String container, Boolean stderr, Boolean stdin, Boolean stdout, Boolean tty) {
        return Mono.create(sink -> {
            try {
                this.client.connectGetNamespacedPodExecAsync(name, namespace, command, container, stderr, stdin, stdout, tty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectGetNamespacedPodPortforward(String name, String namespace, Integer ports) {
        return Mono.create(sink -> {
            try {
                this.client.connectGetNamespacedPodPortforwardAsync(name, namespace, ports, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectGetNamespacedPodProxy(String name, String namespace, String path) {
        return Mono.create(sink -> {
            try {
                this.client.connectGetNamespacedPodProxyAsync(name, namespace, path, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectGetNamespacedPodProxyWithPath(String name, String namespace, String path, String path2) {
        return Mono.create(sink -> {
            try {
                this.client.connectGetNamespacedPodProxyWithPathAsync(name, namespace, path, path2, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectGetNamespacedServiceProxy(String name, String namespace, String path) {
        return Mono.create(sink -> {
            try {
                this.client.connectGetNamespacedServiceProxyAsync(name, namespace, path, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectGetNamespacedServiceProxyWithPath(String name, String namespace, String path, String path2) {
        return Mono.create(sink -> {
            try {
                this.client.connectGetNamespacedServiceProxyWithPathAsync(name, namespace, path, path2, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectGetNodeProxy(String name, String path) {
        return Mono.create(sink -> {
            try {
                this.client.connectGetNodeProxyAsync(name, path, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectGetNodeProxyWithPath(String name, String path, String path2) {
        return Mono.create(sink -> {
            try {
                this.client.connectGetNodeProxyWithPathAsync(name, path, path2, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectHeadNamespacedPodProxy(String name, String namespace, String path) {
        return Mono.create(sink -> {
            try {
                this.client.connectHeadNamespacedPodProxyAsync(name, namespace, path, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectHeadNamespacedPodProxyWithPath(String name, String namespace, String path, String path2) {
        return Mono.create(sink -> {
            try {
                this.client.connectHeadNamespacedPodProxyWithPathAsync(name, namespace, path, path2, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectHeadNamespacedServiceProxy(String name, String namespace, String path) {
        return Mono.create(sink -> {
            try {
                this.client.connectHeadNamespacedServiceProxyAsync(name, namespace, path, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectHeadNamespacedServiceProxyWithPath(String name, String namespace, String path, String path2) {
        return Mono.create(sink -> {
            try {
                this.client.connectHeadNamespacedServiceProxyWithPathAsync(name, namespace, path, path2, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectHeadNodeProxy(String name, String path) {
        return Mono.create(sink -> {
            try {
                this.client.connectHeadNodeProxyAsync(name, path, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectHeadNodeProxyWithPath(String name, String path, String path2) {
        return Mono.create(sink -> {
            try {
                this.client.connectHeadNodeProxyWithPathAsync(name, path, path2, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectOptionsNamespacedPodProxy(String name, String namespace, String path) {
        return Mono.create(sink -> {
            try {
                this.client.connectOptionsNamespacedPodProxyAsync(name, namespace, path, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectOptionsNamespacedPodProxyWithPath(String name, String namespace, String path, String path2) {
        return Mono.create(sink -> {
            try {
                this.client.connectOptionsNamespacedPodProxyWithPathAsync(name, namespace, path, path2, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectOptionsNamespacedServiceProxy(String name, String namespace, String path) {
        return Mono.create(sink -> {
            try {
                this.client.connectOptionsNamespacedServiceProxyAsync(name, namespace, path, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectOptionsNamespacedServiceProxyWithPath(String name, String namespace, String path, String path2) {
        return Mono.create(sink -> {
            try {
                this.client.connectOptionsNamespacedServiceProxyWithPathAsync(name, namespace, path, path2, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectOptionsNodeProxy(String name, String path) {
        return Mono.create(sink -> {
            try {
                this.client.connectOptionsNodeProxyAsync(name, path, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectOptionsNodeProxyWithPath(String name, String path, String path2) {
        return Mono.create(sink -> {
            try {
                this.client.connectOptionsNodeProxyWithPathAsync(name, path, path2, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectPatchNamespacedPodProxy(String name, String namespace, String path) {
        return Mono.create(sink -> {
            try {
                this.client.connectPatchNamespacedPodProxyAsync(name, namespace, path, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectPatchNamespacedPodProxyWithPath(String name, String namespace, String path, String path2) {
        return Mono.create(sink -> {
            try {
                this.client.connectPatchNamespacedPodProxyWithPathAsync(name, namespace, path, path2, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectPatchNamespacedServiceProxy(String name, String namespace, String path) {
        return Mono.create(sink -> {
            try {
                this.client.connectPatchNamespacedServiceProxyAsync(name, namespace, path, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectPatchNamespacedServiceProxyWithPath(String name, String namespace, String path, String path2) {
        return Mono.create(sink -> {
            try {
                this.client.connectPatchNamespacedServiceProxyWithPathAsync(name, namespace, path, path2, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectPatchNodeProxy(String name, String path) {
        return Mono.create(sink -> {
            try {
                this.client.connectPatchNodeProxyAsync(name, path, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectPatchNodeProxyWithPath(String name, String path, String path2) {
        return Mono.create(sink -> {
            try {
                this.client.connectPatchNodeProxyWithPathAsync(name, path, path2, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectPostNamespacedPodAttach(String name, String namespace, String container, Boolean stderr, Boolean stdin, Boolean stdout, Boolean tty) {
        return Mono.create(sink -> {
            try {
                this.client.connectPostNamespacedPodAttachAsync(name, namespace, container, stderr, stdin, stdout, tty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectPostNamespacedPodExec(String name, String namespace, String command, String container, Boolean stderr, Boolean stdin, Boolean stdout, Boolean tty) {
        return Mono.create(sink -> {
            try {
                this.client.connectPostNamespacedPodExecAsync(name, namespace, command, container, stderr, stdin, stdout, tty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectPostNamespacedPodPortforward(String name, String namespace, Integer ports) {
        return Mono.create(sink -> {
            try {
                this.client.connectPostNamespacedPodPortforwardAsync(name, namespace, ports, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectPostNamespacedPodProxy(String name, String namespace, String path) {
        return Mono.create(sink -> {
            try {
                this.client.connectPostNamespacedPodProxyAsync(name, namespace, path, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectPostNamespacedPodProxyWithPath(String name, String namespace, String path, String path2) {
        return Mono.create(sink -> {
            try {
                this.client.connectPostNamespacedPodProxyWithPathAsync(name, namespace, path, path2, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectPostNamespacedServiceProxy(String name, String namespace, String path) {
        return Mono.create(sink -> {
            try {
                this.client.connectPostNamespacedServiceProxyAsync(name, namespace, path, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectPostNamespacedServiceProxyWithPath(String name, String namespace, String path, String path2) {
        return Mono.create(sink -> {
            try {
                this.client.connectPostNamespacedServiceProxyWithPathAsync(name, namespace, path, path2, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectPostNodeProxy(String name, String path) {
        return Mono.create(sink -> {
            try {
                this.client.connectPostNodeProxyAsync(name, path, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectPostNodeProxyWithPath(String name, String path, String path2) {
        return Mono.create(sink -> {
            try {
                this.client.connectPostNodeProxyWithPathAsync(name, path, path2, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectPutNamespacedPodProxy(String name, String namespace, String path) {
        return Mono.create(sink -> {
            try {
                this.client.connectPutNamespacedPodProxyAsync(name, namespace, path, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectPutNamespacedPodProxyWithPath(String name, String namespace, String path, String path2) {
        return Mono.create(sink -> {
            try {
                this.client.connectPutNamespacedPodProxyWithPathAsync(name, namespace, path, path2, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectPutNamespacedServiceProxy(String name, String namespace, String path) {
        return Mono.create(sink -> {
            try {
                this.client.connectPutNamespacedServiceProxyAsync(name, namespace, path, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectPutNamespacedServiceProxyWithPath(String name, String namespace, String path, String path2) {
        return Mono.create(sink -> {
            try {
                this.client.connectPutNamespacedServiceProxyWithPathAsync(name, namespace, path, path2, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectPutNodeProxy(String name, String path) {
        return Mono.create(sink -> {
            try {
                this.client.connectPutNodeProxyAsync(name, path, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> connectPutNodeProxyWithPath(String name, String path, String path2) {
        return Mono.create(sink -> {
            try {
                this.client.connectPutNodeProxyWithPathAsync(name, path, path2, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Namespace> createNamespace(V1Namespace body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Mono.create(sink -> {
            try {
                this.client.createNamespaceAsync(body, pretty, dryRun, fieldManager, fieldValidation, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Binding> createNamespacedBinding(String namespace, V1Binding body, String dryRun, String fieldManager, String fieldValidation, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.createNamespacedBindingAsync(namespace, body, dryRun, fieldManager, fieldValidation, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1ConfigMap> createNamespacedConfigMap(String namespace, V1ConfigMap body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Mono.create(sink -> {
            try {
                this.client.createNamespacedConfigMapAsync(namespace, body, pretty, dryRun, fieldManager, fieldValidation, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Endpoints> createNamespacedEndpoints(String namespace, V1Endpoints body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Mono.create(sink -> {
            try {
                this.client.createNamespacedEndpointsAsync(namespace, body, pretty, dryRun, fieldManager, fieldValidation, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<CoreV1Event> createNamespacedEvent(String namespace, CoreV1Event body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Mono.create(sink -> {
            try {
                this.client.createNamespacedEventAsync(namespace, body, pretty, dryRun, fieldManager, fieldValidation, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1LimitRange> createNamespacedLimitRange(String namespace, V1LimitRange body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Mono.create(sink -> {
            try {
                this.client.createNamespacedLimitRangeAsync(namespace, body, pretty, dryRun, fieldManager, fieldValidation, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1PersistentVolumeClaim> createNamespacedPersistentVolumeClaim(String namespace, V1PersistentVolumeClaim body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Mono.create(sink -> {
            try {
                this.client.createNamespacedPersistentVolumeClaimAsync(namespace, body, pretty, dryRun, fieldManager, fieldValidation, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Pod> createNamespacedPod(String namespace, V1Pod body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Mono.create(sink -> {
            try {
                this.client.createNamespacedPodAsync(namespace, body, pretty, dryRun, fieldManager, fieldValidation, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Binding> createNamespacedPodBinding(String name, String namespace, V1Binding body, String dryRun, String fieldManager, String fieldValidation, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.createNamespacedPodBindingAsync(name, namespace, body, dryRun, fieldManager, fieldValidation, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Eviction> createNamespacedPodEviction(String name, String namespace, V1Eviction body, String dryRun, String fieldManager, String fieldValidation, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.createNamespacedPodEvictionAsync(name, namespace, body, dryRun, fieldManager, fieldValidation, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1PodTemplate> createNamespacedPodTemplate(String namespace, V1PodTemplate body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Mono.create(sink -> {
            try {
                this.client.createNamespacedPodTemplateAsync(namespace, body, pretty, dryRun, fieldManager, fieldValidation, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1ReplicationController> createNamespacedReplicationController(String namespace, V1ReplicationController body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Mono.create(sink -> {
            try {
                this.client.createNamespacedReplicationControllerAsync(namespace, body, pretty, dryRun, fieldManager, fieldValidation, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1ResourceQuota> createNamespacedResourceQuota(String namespace, V1ResourceQuota body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Mono.create(sink -> {
            try {
                this.client.createNamespacedResourceQuotaAsync(namespace, body, pretty, dryRun, fieldManager, fieldValidation, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Secret> createNamespacedSecret(String namespace, V1Secret body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Mono.create(sink -> {
            try {
                this.client.createNamespacedSecretAsync(namespace, body, pretty, dryRun, fieldManager, fieldValidation, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Service> createNamespacedService(String namespace, V1Service body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Mono.create(sink -> {
            try {
                this.client.createNamespacedServiceAsync(namespace, body, pretty, dryRun, fieldManager, fieldValidation, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1ServiceAccount> createNamespacedServiceAccount(String namespace, V1ServiceAccount body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Mono.create(sink -> {
            try {
                this.client.createNamespacedServiceAccountAsync(namespace, body, pretty, dryRun, fieldManager, fieldValidation, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<AuthenticationV1TokenRequest> createNamespacedServiceAccountToken(String name, String namespace, AuthenticationV1TokenRequest body, String dryRun, String fieldManager, String fieldValidation, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.createNamespacedServiceAccountTokenAsync(name, namespace, body, dryRun, fieldManager, fieldValidation, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Node> createNode(V1Node body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Mono.create(sink -> {
            try {
                this.client.createNodeAsync(body, pretty, dryRun, fieldManager, fieldValidation, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1PersistentVolume> createPersistentVolume(V1PersistentVolume body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Mono.create(sink -> {
            try {
                this.client.createPersistentVolumeAsync(body, pretty, dryRun, fieldManager, fieldValidation, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Status> deleteCollectionNamespacedConfigMap(String namespace, String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteCollectionNamespacedConfigMapAsync(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, timeoutSeconds, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Status> deleteCollectionNamespacedEndpoints(String namespace, String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteCollectionNamespacedEndpointsAsync(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, timeoutSeconds, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Status> deleteCollectionNamespacedEvent(String namespace, String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteCollectionNamespacedEventAsync(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, timeoutSeconds, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Status> deleteCollectionNamespacedLimitRange(String namespace, String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteCollectionNamespacedLimitRangeAsync(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, timeoutSeconds, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Status> deleteCollectionNamespacedPersistentVolumeClaim(String namespace, String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteCollectionNamespacedPersistentVolumeClaimAsync(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, timeoutSeconds, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Status> deleteCollectionNamespacedPod(String namespace, String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteCollectionNamespacedPodAsync(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, timeoutSeconds, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Status> deleteCollectionNamespacedPodTemplate(String namespace, String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteCollectionNamespacedPodTemplateAsync(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, timeoutSeconds, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Status> deleteCollectionNamespacedReplicationController(String namespace, String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteCollectionNamespacedReplicationControllerAsync(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, timeoutSeconds, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Status> deleteCollectionNamespacedResourceQuota(String namespace, String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteCollectionNamespacedResourceQuotaAsync(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, timeoutSeconds, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Status> deleteCollectionNamespacedSecret(String namespace, String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteCollectionNamespacedSecretAsync(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, timeoutSeconds, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Status> deleteCollectionNamespacedService(String namespace, String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteCollectionNamespacedServiceAsync(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, timeoutSeconds, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Status> deleteCollectionNamespacedServiceAccount(String namespace, String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteCollectionNamespacedServiceAccountAsync(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, timeoutSeconds, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Status> deleteCollectionNode(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteCollectionNodeAsync(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, timeoutSeconds, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Status> deleteCollectionPersistentVolume(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteCollectionPersistentVolumeAsync(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, timeoutSeconds, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Status> deleteNamespace(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteNamespaceAsync(name, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Status> deleteNamespacedConfigMap(String name, String namespace, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteNamespacedConfigMapAsync(name, namespace, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Status> deleteNamespacedEndpoints(String name, String namespace, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteNamespacedEndpointsAsync(name, namespace, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Status> deleteNamespacedEvent(String name, String namespace, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteNamespacedEventAsync(name, namespace, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Status> deleteNamespacedLimitRange(String name, String namespace, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteNamespacedLimitRangeAsync(name, namespace, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1PersistentVolumeClaim> deleteNamespacedPersistentVolumeClaim(String name, String namespace, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteNamespacedPersistentVolumeClaimAsync(name, namespace, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Pod> deleteNamespacedPod(String name, String namespace, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteNamespacedPodAsync(name, namespace, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1PodTemplate> deleteNamespacedPodTemplate(String name, String namespace, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteNamespacedPodTemplateAsync(name, namespace, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Status> deleteNamespacedReplicationController(String name, String namespace, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteNamespacedReplicationControllerAsync(name, namespace, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1ResourceQuota> deleteNamespacedResourceQuota(String name, String namespace, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteNamespacedResourceQuotaAsync(name, namespace, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Status> deleteNamespacedSecret(String name, String namespace, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteNamespacedSecretAsync(name, namespace, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Service> deleteNamespacedService(String name, String namespace, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteNamespacedServiceAsync(name, namespace, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1ServiceAccount> deleteNamespacedServiceAccount(String name, String namespace, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteNamespacedServiceAccountAsync(name, namespace, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Status> deleteNode(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deleteNodeAsync(name, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1PersistentVolume> deletePersistentVolume(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) {
        return Mono.create(sink -> {
            try {
                this.client.deletePersistentVolumeAsync(name, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1APIResourceList> getAPIResources() {
        return Mono.create(sink -> {
            try {
                this.client.getAPIResourcesAsync(new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1ComponentStatusList> listComponentStatus(Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String pretty, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Mono.create(sink -> {
            try {
                this.client.listComponentStatusAsync(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1ConfigMapList> listConfigMapForAllNamespaces(Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String pretty, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Mono.create(sink -> {
            try {
                this.client.listConfigMapForAllNamespacesAsync(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1EndpointsList> listEndpointsForAllNamespaces(Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String pretty, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Mono.create(sink -> {
            try {
                this.client.listEndpointsForAllNamespacesAsync(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<CoreV1EventList> listEventForAllNamespaces(Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String pretty, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Mono.create(sink -> {
            try {
                this.client.listEventForAllNamespacesAsync(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1LimitRangeList> listLimitRangeForAllNamespaces(Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String pretty, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Mono.create(sink -> {
            try {
                this.client.listLimitRangeForAllNamespacesAsync(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1NamespaceList> listNamespace(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Mono.create(sink -> {
            try {
                this.client.listNamespaceAsync(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1ConfigMapList> listNamespacedConfigMap(String namespace, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Mono.create(sink -> {
            try {
                this.client.listNamespacedConfigMapAsync(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1EndpointsList> listNamespacedEndpoints(String namespace, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Mono.create(sink -> {
            try {
                this.client.listNamespacedEndpointsAsync(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<CoreV1EventList> listNamespacedEvent(String namespace, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Mono.create(sink -> {
            try {
                this.client.listNamespacedEventAsync(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1LimitRangeList> listNamespacedLimitRange(String namespace, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Mono.create(sink -> {
            try {
                this.client.listNamespacedLimitRangeAsync(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1PersistentVolumeClaimList> listNamespacedPersistentVolumeClaim(String namespace, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Mono.create(sink -> {
            try {
                this.client.listNamespacedPersistentVolumeClaimAsync(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1PodList> listNamespacedPod(String namespace, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Mono.create(sink -> {
            try {
                this.client.listNamespacedPodAsync(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1PodTemplateList> listNamespacedPodTemplate(String namespace, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Mono.create(sink -> {
            try {
                this.client.listNamespacedPodTemplateAsync(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1ReplicationControllerList> listNamespacedReplicationController(String namespace, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Mono.create(sink -> {
            try {
                this.client.listNamespacedReplicationControllerAsync(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1ResourceQuotaList> listNamespacedResourceQuota(String namespace, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Mono.create(sink -> {
            try {
                this.client.listNamespacedResourceQuotaAsync(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1SecretList> listNamespacedSecret(String namespace, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Mono.create(sink -> {
            try {
                this.client.listNamespacedSecretAsync(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1ServiceList> listNamespacedService(String namespace, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Mono.create(sink -> {
            try {
                this.client.listNamespacedServiceAsync(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1ServiceAccountList> listNamespacedServiceAccount(String namespace, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Mono.create(sink -> {
            try {
                this.client.listNamespacedServiceAccountAsync(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1NodeList> listNode(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Mono.create(sink -> {
            try {
                this.client.listNodeAsync(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1PersistentVolumeList> listPersistentVolume(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Mono.create(sink -> {
            try {
                this.client.listPersistentVolumeAsync(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1PersistentVolumeClaimList> listPersistentVolumeClaimForAllNamespaces(Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String pretty, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Mono.create(sink -> {
            try {
                this.client.listPersistentVolumeClaimForAllNamespacesAsync(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1PodList> listPodForAllNamespaces(Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String pretty, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Mono.create(sink -> {
            try {
                this.client.listPodForAllNamespacesAsync(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1PodTemplateList> listPodTemplateForAllNamespaces(Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String pretty, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Mono.create(sink -> {
            try {
                this.client.listPodTemplateForAllNamespacesAsync(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1ReplicationControllerList> listReplicationControllerForAllNamespaces(Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String pretty, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Mono.create(sink -> {
            try {
                this.client.listReplicationControllerForAllNamespacesAsync(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1ResourceQuotaList> listResourceQuotaForAllNamespaces(Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String pretty, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Mono.create(sink -> {
            try {
                this.client.listResourceQuotaForAllNamespacesAsync(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1SecretList> listSecretForAllNamespaces(Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String pretty, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Mono.create(sink -> {
            try {
                this.client.listSecretForAllNamespacesAsync(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1ServiceAccountList> listServiceAccountForAllNamespaces(Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String pretty, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Mono.create(sink -> {
            try {
                this.client.listServiceAccountForAllNamespacesAsync(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1ServiceList> listServiceForAllNamespaces(Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String pretty, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Mono.create(sink -> {
            try {
                this.client.listServiceForAllNamespacesAsync(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Namespace> patchNamespace(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) {
        return Mono.create(sink -> {
            try {
                this.client.patchNamespaceAsync(name, body, pretty, dryRun, fieldManager, fieldValidation, force, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Namespace> patchNamespaceStatus(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) {
        return Mono.create(sink -> {
            try {
                this.client.patchNamespaceStatusAsync(name, body, pretty, dryRun, fieldManager, fieldValidation, force, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1ConfigMap> patchNamespacedConfigMap(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) {
        return Mono.create(sink -> {
            try {
                this.client.patchNamespacedConfigMapAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Endpoints> patchNamespacedEndpoints(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) {
        return Mono.create(sink -> {
            try {
                this.client.patchNamespacedEndpointsAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<CoreV1Event> patchNamespacedEvent(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) {
        return Mono.create(sink -> {
            try {
                this.client.patchNamespacedEventAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1LimitRange> patchNamespacedLimitRange(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) {
        return Mono.create(sink -> {
            try {
                this.client.patchNamespacedLimitRangeAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1PersistentVolumeClaim> patchNamespacedPersistentVolumeClaim(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) {
        return Mono.create(sink -> {
            try {
                this.client.patchNamespacedPersistentVolumeClaimAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1PersistentVolumeClaim> patchNamespacedPersistentVolumeClaimStatus(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) {
        return Mono.create(sink -> {
            try {
                this.client.patchNamespacedPersistentVolumeClaimStatusAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Pod> patchNamespacedPod(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) {
        return Mono.create(sink -> {
            try {
                this.client.patchNamespacedPodAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Pod> patchNamespacedPodEphemeralcontainers(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) {
        return Mono.create(sink -> {
            try {
                this.client.patchNamespacedPodEphemeralcontainersAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Pod> patchNamespacedPodStatus(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) {
        return Mono.create(sink -> {
            try {
                this.client.patchNamespacedPodStatusAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1PodTemplate> patchNamespacedPodTemplate(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) {
        return Mono.create(sink -> {
            try {
                this.client.patchNamespacedPodTemplateAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1ReplicationController> patchNamespacedReplicationController(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) {
        return Mono.create(sink -> {
            try {
                this.client.patchNamespacedReplicationControllerAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Scale> patchNamespacedReplicationControllerScale(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) {
        return Mono.create(sink -> {
            try {
                this.client.patchNamespacedReplicationControllerScaleAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1ReplicationController> patchNamespacedReplicationControllerStatus(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) {
        return Mono.create(sink -> {
            try {
                this.client.patchNamespacedReplicationControllerStatusAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1ResourceQuota> patchNamespacedResourceQuota(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) {
        return Mono.create(sink -> {
            try {
                this.client.patchNamespacedResourceQuotaAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1ResourceQuota> patchNamespacedResourceQuotaStatus(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) {
        return Mono.create(sink -> {
            try {
                this.client.patchNamespacedResourceQuotaStatusAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Secret> patchNamespacedSecret(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) {
        return Mono.create(sink -> {
            try {
                this.client.patchNamespacedSecretAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Service> patchNamespacedService(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) {
        return Mono.create(sink -> {
            try {
                this.client.patchNamespacedServiceAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1ServiceAccount> patchNamespacedServiceAccount(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) {
        return Mono.create(sink -> {
            try {
                this.client.patchNamespacedServiceAccountAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Service> patchNamespacedServiceStatus(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) {
        return Mono.create(sink -> {
            try {
                this.client.patchNamespacedServiceStatusAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Node> patchNode(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) {
        return Mono.create(sink -> {
            try {
                this.client.patchNodeAsync(name, body, pretty, dryRun, fieldManager, fieldValidation, force, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Node> patchNodeStatus(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) {
        return Mono.create(sink -> {
            try {
                this.client.patchNodeStatusAsync(name, body, pretty, dryRun, fieldManager, fieldValidation, force, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1PersistentVolume> patchPersistentVolume(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) {
        return Mono.create(sink -> {
            try {
                this.client.patchPersistentVolumeAsync(name, body, pretty, dryRun, fieldManager, fieldValidation, force, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1PersistentVolume> patchPersistentVolumeStatus(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) {
        return Mono.create(sink -> {
            try {
                this.client.patchPersistentVolumeStatusAsync(name, body, pretty, dryRun, fieldManager, fieldValidation, force, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1ComponentStatus> readComponentStatus(String name, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.readComponentStatusAsync(name, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Namespace> readNamespace(String name, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.readNamespaceAsync(name, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Namespace> readNamespaceStatus(String name, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.readNamespaceStatusAsync(name, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1ConfigMap> readNamespacedConfigMap(String name, String namespace, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.readNamespacedConfigMapAsync(name, namespace, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Endpoints> readNamespacedEndpoints(String name, String namespace, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.readNamespacedEndpointsAsync(name, namespace, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<CoreV1Event> readNamespacedEvent(String name, String namespace, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.readNamespacedEventAsync(name, namespace, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1LimitRange> readNamespacedLimitRange(String name, String namespace, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.readNamespacedLimitRangeAsync(name, namespace, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1PersistentVolumeClaim> readNamespacedPersistentVolumeClaim(String name, String namespace, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.readNamespacedPersistentVolumeClaimAsync(name, namespace, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1PersistentVolumeClaim> readNamespacedPersistentVolumeClaimStatus(String name, String namespace, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.readNamespacedPersistentVolumeClaimStatusAsync(name, namespace, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Pod> readNamespacedPod(String name, String namespace, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.readNamespacedPodAsync(name, namespace, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Pod> readNamespacedPodEphemeralcontainers(String name, String namespace, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.readNamespacedPodEphemeralcontainersAsync(name, namespace, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<String> readNamespacedPodLog(String name, String namespace, String container, Boolean follow, Boolean insecureSkipTLSVerifyBackend, Integer limitBytes, String pretty, Boolean previous, Integer sinceSeconds, Integer tailLines, Boolean timestamps) {
        return Mono.create(sink -> {
            try {
                this.client.readNamespacedPodLogAsync(name, namespace, container, follow, insecureSkipTLSVerifyBackend, limitBytes, pretty, previous, sinceSeconds, tailLines, timestamps, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Pod> readNamespacedPodStatus(String name, String namespace, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.readNamespacedPodStatusAsync(name, namespace, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1PodTemplate> readNamespacedPodTemplate(String name, String namespace, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.readNamespacedPodTemplateAsync(name, namespace, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1ReplicationController> readNamespacedReplicationController(String name, String namespace, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.readNamespacedReplicationControllerAsync(name, namespace, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Scale> readNamespacedReplicationControllerScale(String name, String namespace, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.readNamespacedReplicationControllerScaleAsync(name, namespace, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1ReplicationController> readNamespacedReplicationControllerStatus(String name, String namespace, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.readNamespacedReplicationControllerStatusAsync(name, namespace, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1ResourceQuota> readNamespacedResourceQuota(String name, String namespace, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.readNamespacedResourceQuotaAsync(name, namespace, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1ResourceQuota> readNamespacedResourceQuotaStatus(String name, String namespace, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.readNamespacedResourceQuotaStatusAsync(name, namespace, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Secret> readNamespacedSecret(String name, String namespace, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.readNamespacedSecretAsync(name, namespace, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Service> readNamespacedService(String name, String namespace, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.readNamespacedServiceAsync(name, namespace, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1ServiceAccount> readNamespacedServiceAccount(String name, String namespace, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.readNamespacedServiceAccountAsync(name, namespace, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Service> readNamespacedServiceStatus(String name, String namespace, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.readNamespacedServiceStatusAsync(name, namespace, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Node> readNode(String name, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.readNodeAsync(name, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Node> readNodeStatus(String name, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.readNodeStatusAsync(name, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1PersistentVolume> readPersistentVolume(String name, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.readPersistentVolumeAsync(name, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1PersistentVolume> readPersistentVolumeStatus(String name, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.readPersistentVolumeStatusAsync(name, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Namespace> replaceNamespace(String name, V1Namespace body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Mono.create(sink -> {
            try {
                this.client.replaceNamespaceAsync(name, body, pretty, dryRun, fieldManager, fieldValidation, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Namespace> replaceNamespaceFinalize(String name, V1Namespace body, String dryRun, String fieldManager, String fieldValidation, String pretty) {
        return Mono.create(sink -> {
            try {
                this.client.replaceNamespaceFinalizeAsync(name, body, dryRun, fieldManager, fieldValidation, pretty, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Namespace> replaceNamespaceStatus(String name, V1Namespace body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Mono.create(sink -> {
            try {
                this.client.replaceNamespaceStatusAsync(name, body, pretty, dryRun, fieldManager, fieldValidation, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1ConfigMap> replaceNamespacedConfigMap(String name, String namespace, V1ConfigMap body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Mono.create(sink -> {
            try {
                this.client.replaceNamespacedConfigMapAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Endpoints> replaceNamespacedEndpoints(String name, String namespace, V1Endpoints body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Mono.create(sink -> {
            try {
                this.client.replaceNamespacedEndpointsAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<CoreV1Event> replaceNamespacedEvent(String name, String namespace, CoreV1Event body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Mono.create(sink -> {
            try {
                this.client.replaceNamespacedEventAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1LimitRange> replaceNamespacedLimitRange(String name, String namespace, V1LimitRange body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Mono.create(sink -> {
            try {
                this.client.replaceNamespacedLimitRangeAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1PersistentVolumeClaim> replaceNamespacedPersistentVolumeClaim(String name, String namespace, V1PersistentVolumeClaim body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Mono.create(sink -> {
            try {
                this.client.replaceNamespacedPersistentVolumeClaimAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1PersistentVolumeClaim> replaceNamespacedPersistentVolumeClaimStatus(String name, String namespace, V1PersistentVolumeClaim body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Mono.create(sink -> {
            try {
                this.client.replaceNamespacedPersistentVolumeClaimStatusAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Pod> replaceNamespacedPod(String name, String namespace, V1Pod body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Mono.create(sink -> {
            try {
                this.client.replaceNamespacedPodAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Pod> replaceNamespacedPodEphemeralcontainers(String name, String namespace, V1Pod body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Mono.create(sink -> {
            try {
                this.client.replaceNamespacedPodEphemeralcontainersAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Pod> replaceNamespacedPodStatus(String name, String namespace, V1Pod body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Mono.create(sink -> {
            try {
                this.client.replaceNamespacedPodStatusAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1PodTemplate> replaceNamespacedPodTemplate(String name, String namespace, V1PodTemplate body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Mono.create(sink -> {
            try {
                this.client.replaceNamespacedPodTemplateAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1ReplicationController> replaceNamespacedReplicationController(String name, String namespace, V1ReplicationController body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Mono.create(sink -> {
            try {
                this.client.replaceNamespacedReplicationControllerAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Scale> replaceNamespacedReplicationControllerScale(String name, String namespace, V1Scale body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Mono.create(sink -> {
            try {
                this.client.replaceNamespacedReplicationControllerScaleAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1ReplicationController> replaceNamespacedReplicationControllerStatus(String name, String namespace, V1ReplicationController body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Mono.create(sink -> {
            try {
                this.client.replaceNamespacedReplicationControllerStatusAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1ResourceQuota> replaceNamespacedResourceQuota(String name, String namespace, V1ResourceQuota body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Mono.create(sink -> {
            try {
                this.client.replaceNamespacedResourceQuotaAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1ResourceQuota> replaceNamespacedResourceQuotaStatus(String name, String namespace, V1ResourceQuota body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Mono.create(sink -> {
            try {
                this.client.replaceNamespacedResourceQuotaStatusAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Secret> replaceNamespacedSecret(String name, String namespace, V1Secret body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Mono.create(sink -> {
            try {
                this.client.replaceNamespacedSecretAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Service> replaceNamespacedService(String name, String namespace, V1Service body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Mono.create(sink -> {
            try {
                this.client.replaceNamespacedServiceAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1ServiceAccount> replaceNamespacedServiceAccount(String name, String namespace, V1ServiceAccount body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Mono.create(sink -> {
            try {
                this.client.replaceNamespacedServiceAccountAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Service> replaceNamespacedServiceStatus(String name, String namespace, V1Service body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Mono.create(sink -> {
            try {
                this.client.replaceNamespacedServiceStatusAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Node> replaceNode(String name, V1Node body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Mono.create(sink -> {
            try {
                this.client.replaceNodeAsync(name, body, pretty, dryRun, fieldManager, fieldValidation, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1Node> replaceNodeStatus(String name, V1Node body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Mono.create(sink -> {
            try {
                this.client.replaceNodeStatusAsync(name, body, pretty, dryRun, fieldManager, fieldValidation, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1PersistentVolume> replacePersistentVolume(String name, V1PersistentVolume body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Mono.create(sink -> {
            try {
                this.client.replacePersistentVolumeAsync(name, body, pretty, dryRun, fieldManager, fieldValidation, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<V1PersistentVolume> replacePersistentVolumeStatus(String name, V1PersistentVolume body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Mono.create(sink -> {
            try {
                this.client.replacePersistentVolumeStatusAsync(name, body, pretty, dryRun, fieldManager, fieldValidation, new AsyncCallbackSink(sink));
            }
            catch (ApiException e) {
                sink.error((Throwable)e);
            }
        });
    }
}

