/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.rxjava3;

import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.openapi.apis.ApiextensionsV1Api;
import io.kubernetes.client.openapi.models.V1APIResourceList;
import io.kubernetes.client.openapi.models.V1CustomResourceDefinition;
import io.kubernetes.client.openapi.models.V1CustomResourceDefinitionList;
import io.kubernetes.client.openapi.models.V1DeleteOptions;
import io.kubernetes.client.openapi.models.V1Status;
import io.micronaut.context.annotation.Requires;
import io.micronaut.kubernetes.client.rxjava3.ApiCallbackEmitter;
import io.reactivex.rxjava3.core.Single;
import jakarta.inject.Singleton;

@Requires(beans={ApiextensionsV1Api.class})
@Singleton
public class ApiextensionsV1ApiRxClient {
    private final ApiextensionsV1Api client;

    ApiextensionsV1ApiRxClient(ApiextensionsV1Api client) {
        this.client = client;
    }

    public Single<V1CustomResourceDefinition> createCustomResourceDefinition(V1CustomResourceDefinition body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Single.create(emitter -> this.client.createCustomResourceDefinitionAsync(body, pretty, dryRun, fieldManager, fieldValidation, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1Status> deleteCollectionCustomResourceDefinition(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, V1DeleteOptions body) {
        return Single.create(emitter -> this.client.deleteCollectionCustomResourceDefinitionAsync(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, timeoutSeconds, body, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1Status> deleteCustomResourceDefinition(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) {
        return Single.create(emitter -> this.client.deleteCustomResourceDefinitionAsync(name, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1APIResourceList> getAPIResources() {
        return Single.create(emitter -> this.client.getAPIResourcesAsync(new ApiCallbackEmitter(emitter)));
    }

    public Single<V1CustomResourceDefinitionList> listCustomResourceDefinition(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Single.create(emitter -> this.client.listCustomResourceDefinitionAsync(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1CustomResourceDefinition> patchCustomResourceDefinition(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) {
        return Single.create(emitter -> this.client.patchCustomResourceDefinitionAsync(name, body, pretty, dryRun, fieldManager, fieldValidation, force, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1CustomResourceDefinition> patchCustomResourceDefinitionStatus(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) {
        return Single.create(emitter -> this.client.patchCustomResourceDefinitionStatusAsync(name, body, pretty, dryRun, fieldManager, fieldValidation, force, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1CustomResourceDefinition> readCustomResourceDefinition(String name, String pretty) {
        return Single.create(emitter -> this.client.readCustomResourceDefinitionAsync(name, pretty, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1CustomResourceDefinition> readCustomResourceDefinitionStatus(String name, String pretty) {
        return Single.create(emitter -> this.client.readCustomResourceDefinitionStatusAsync(name, pretty, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1CustomResourceDefinition> replaceCustomResourceDefinition(String name, V1CustomResourceDefinition body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Single.create(emitter -> this.client.replaceCustomResourceDefinitionAsync(name, body, pretty, dryRun, fieldManager, fieldValidation, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1CustomResourceDefinition> replaceCustomResourceDefinitionStatus(String name, V1CustomResourceDefinition body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Single.create(emitter -> this.client.replaceCustomResourceDefinitionStatusAsync(name, body, pretty, dryRun, fieldManager, fieldValidation, new ApiCallbackEmitter(emitter)));
    }
}

