/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.rxjava3;

import io.kubernetes.client.openapi.apis.AuthorizationV1Api;
import io.kubernetes.client.openapi.models.V1APIResourceList;
import io.kubernetes.client.openapi.models.V1LocalSubjectAccessReview;
import io.kubernetes.client.openapi.models.V1SelfSubjectAccessReview;
import io.kubernetes.client.openapi.models.V1SelfSubjectRulesReview;
import io.kubernetes.client.openapi.models.V1SubjectAccessReview;
import io.micronaut.context.annotation.Requires;
import io.micronaut.kubernetes.client.rxjava3.ApiCallbackEmitter;
import io.reactivex.rxjava3.core.Single;
import jakarta.inject.Singleton;

@Requires(beans={AuthorizationV1Api.class})
@Singleton
public class AuthorizationV1ApiRxClient {
    private final AuthorizationV1Api client;

    AuthorizationV1ApiRxClient(AuthorizationV1Api client) {
        this.client = client;
    }

    public Single<V1LocalSubjectAccessReview> createNamespacedLocalSubjectAccessReview(String namespace, V1LocalSubjectAccessReview body, String dryRun, String fieldManager, String fieldValidation, String pretty) {
        return Single.create(emitter -> this.client.createNamespacedLocalSubjectAccessReviewAsync(namespace, body, dryRun, fieldManager, fieldValidation, pretty, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1SelfSubjectAccessReview> createSelfSubjectAccessReview(V1SelfSubjectAccessReview body, String dryRun, String fieldManager, String fieldValidation, String pretty) {
        return Single.create(emitter -> this.client.createSelfSubjectAccessReviewAsync(body, dryRun, fieldManager, fieldValidation, pretty, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1SelfSubjectRulesReview> createSelfSubjectRulesReview(V1SelfSubjectRulesReview body, String dryRun, String fieldManager, String fieldValidation, String pretty) {
        return Single.create(emitter -> this.client.createSelfSubjectRulesReviewAsync(body, dryRun, fieldManager, fieldValidation, pretty, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1SubjectAccessReview> createSubjectAccessReview(V1SubjectAccessReview body, String dryRun, String fieldManager, String fieldValidation, String pretty) {
        return Single.create(emitter -> this.client.createSubjectAccessReviewAsync(body, dryRun, fieldManager, fieldValidation, pretty, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1APIResourceList> getAPIResources() {
        return Single.create(emitter -> this.client.getAPIResourcesAsync(new ApiCallbackEmitter(emitter)));
    }
}

