/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.rxjava3;

import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.openapi.apis.BatchV1Api;
import io.kubernetes.client.openapi.models.V1APIResourceList;
import io.kubernetes.client.openapi.models.V1CronJob;
import io.kubernetes.client.openapi.models.V1CronJobList;
import io.kubernetes.client.openapi.models.V1DeleteOptions;
import io.kubernetes.client.openapi.models.V1Job;
import io.kubernetes.client.openapi.models.V1JobList;
import io.kubernetes.client.openapi.models.V1Status;
import io.micronaut.context.annotation.Requires;
import io.micronaut.kubernetes.client.rxjava3.ApiCallbackEmitter;
import io.reactivex.rxjava3.core.Single;
import jakarta.inject.Singleton;

@Requires(beans={BatchV1Api.class})
@Singleton
public class BatchV1ApiRxClient {
    private final BatchV1Api client;

    BatchV1ApiRxClient(BatchV1Api client) {
        this.client = client;
    }

    public Single<V1CronJob> createNamespacedCronJob(String namespace, V1CronJob body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Single.create(emitter -> this.client.createNamespacedCronJobAsync(namespace, body, pretty, dryRun, fieldManager, fieldValidation, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1Job> createNamespacedJob(String namespace, V1Job body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Single.create(emitter -> this.client.createNamespacedJobAsync(namespace, body, pretty, dryRun, fieldManager, fieldValidation, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1Status> deleteCollectionNamespacedCronJob(String namespace, String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, V1DeleteOptions body) {
        return Single.create(emitter -> this.client.deleteCollectionNamespacedCronJobAsync(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, timeoutSeconds, body, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1Status> deleteCollectionNamespacedJob(String namespace, String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, V1DeleteOptions body) {
        return Single.create(emitter -> this.client.deleteCollectionNamespacedJobAsync(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, timeoutSeconds, body, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1Status> deleteNamespacedCronJob(String name, String namespace, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) {
        return Single.create(emitter -> this.client.deleteNamespacedCronJobAsync(name, namespace, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1Status> deleteNamespacedJob(String name, String namespace, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) {
        return Single.create(emitter -> this.client.deleteNamespacedJobAsync(name, namespace, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1APIResourceList> getAPIResources() {
        return Single.create(emitter -> this.client.getAPIResourcesAsync(new ApiCallbackEmitter(emitter)));
    }

    public Single<V1CronJobList> listCronJobForAllNamespaces(Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String pretty, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Single.create(emitter -> this.client.listCronJobForAllNamespacesAsync(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1JobList> listJobForAllNamespaces(Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String pretty, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Single.create(emitter -> this.client.listJobForAllNamespacesAsync(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1CronJobList> listNamespacedCronJob(String namespace, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Single.create(emitter -> this.client.listNamespacedCronJobAsync(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1JobList> listNamespacedJob(String namespace, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Single.create(emitter -> this.client.listNamespacedJobAsync(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1CronJob> patchNamespacedCronJob(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) {
        return Single.create(emitter -> this.client.patchNamespacedCronJobAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1CronJob> patchNamespacedCronJobStatus(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) {
        return Single.create(emitter -> this.client.patchNamespacedCronJobStatusAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1Job> patchNamespacedJob(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) {
        return Single.create(emitter -> this.client.patchNamespacedJobAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1Job> patchNamespacedJobStatus(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) {
        return Single.create(emitter -> this.client.patchNamespacedJobStatusAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1CronJob> readNamespacedCronJob(String name, String namespace, String pretty) {
        return Single.create(emitter -> this.client.readNamespacedCronJobAsync(name, namespace, pretty, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1CronJob> readNamespacedCronJobStatus(String name, String namespace, String pretty) {
        return Single.create(emitter -> this.client.readNamespacedCronJobStatusAsync(name, namespace, pretty, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1Job> readNamespacedJob(String name, String namespace, String pretty) {
        return Single.create(emitter -> this.client.readNamespacedJobAsync(name, namespace, pretty, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1Job> readNamespacedJobStatus(String name, String namespace, String pretty) {
        return Single.create(emitter -> this.client.readNamespacedJobStatusAsync(name, namespace, pretty, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1CronJob> replaceNamespacedCronJob(String name, String namespace, V1CronJob body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Single.create(emitter -> this.client.replaceNamespacedCronJobAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1CronJob> replaceNamespacedCronJobStatus(String name, String namespace, V1CronJob body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Single.create(emitter -> this.client.replaceNamespacedCronJobStatusAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1Job> replaceNamespacedJob(String name, String namespace, V1Job body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Single.create(emitter -> this.client.replaceNamespacedJobAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1Job> replaceNamespacedJobStatus(String name, String namespace, V1Job body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Single.create(emitter -> this.client.replaceNamespacedJobStatusAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, new ApiCallbackEmitter(emitter)));
    }
}

