/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.rxjava3;

import io.kubernetes.client.openapi.apis.CustomObjectsApi;
import io.kubernetes.client.openapi.models.V1APIResourceList;
import io.kubernetes.client.openapi.models.V1DeleteOptions;
import io.micronaut.context.annotation.Requires;
import io.micronaut.kubernetes.client.rxjava3.ApiCallbackEmitter;
import io.reactivex.rxjava3.core.Single;
import jakarta.inject.Singleton;

@Requires(beans={CustomObjectsApi.class})
@Singleton
public class CustomObjectsApiRxClient {
    private final CustomObjectsApi client;

    CustomObjectsApiRxClient(CustomObjectsApi client) {
        this.client = client;
    }

    public Single<Object> createClusterCustomObject(String group, String version, String plural, Object body, String pretty, String dryRun, String fieldManager) {
        return Single.create(emitter -> this.client.createClusterCustomObjectAsync(group, version, plural, body, pretty, dryRun, fieldManager, new ApiCallbackEmitter(emitter)));
    }

    public Single<Object> createNamespacedCustomObject(String group, String version, String namespace, String plural, Object body, String pretty, String dryRun, String fieldManager) {
        return Single.create(emitter -> this.client.createNamespacedCustomObjectAsync(group, version, namespace, plural, body, pretty, dryRun, fieldManager, new ApiCallbackEmitter(emitter)));
    }

    public Single<Object> deleteClusterCustomObject(String group, String version, String plural, String name, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, String dryRun, V1DeleteOptions body) {
        return Single.create(emitter -> this.client.deleteClusterCustomObjectAsync(group, version, plural, name, gracePeriodSeconds, orphanDependents, propagationPolicy, dryRun, body, new ApiCallbackEmitter(emitter)));
    }

    public Single<Object> deleteCollectionClusterCustomObject(String group, String version, String plural, String pretty, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, String dryRun, V1DeleteOptions body) {
        return Single.create(emitter -> this.client.deleteCollectionClusterCustomObjectAsync(group, version, plural, pretty, gracePeriodSeconds, orphanDependents, propagationPolicy, dryRun, body, new ApiCallbackEmitter(emitter)));
    }

    public Single<Object> deleteCollectionNamespacedCustomObject(String group, String version, String namespace, String plural, String pretty, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, String dryRun, V1DeleteOptions body) {
        return Single.create(emitter -> this.client.deleteCollectionNamespacedCustomObjectAsync(group, version, namespace, plural, pretty, gracePeriodSeconds, orphanDependents, propagationPolicy, dryRun, body, new ApiCallbackEmitter(emitter)));
    }

    public Single<Object> deleteNamespacedCustomObject(String group, String version, String namespace, String plural, String name, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, String dryRun, V1DeleteOptions body) {
        return Single.create(emitter -> this.client.deleteNamespacedCustomObjectAsync(group, version, namespace, plural, name, gracePeriodSeconds, orphanDependents, propagationPolicy, dryRun, body, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1APIResourceList> getAPIResources(String group, String version) {
        return Single.create(emitter -> this.client.getAPIResourcesAsync(group, version, new ApiCallbackEmitter(emitter)));
    }

    public Single<Object> getClusterCustomObject(String group, String version, String plural, String name) {
        return Single.create(emitter -> this.client.getClusterCustomObjectAsync(group, version, plural, name, new ApiCallbackEmitter(emitter)));
    }

    public Single<Object> getClusterCustomObjectScale(String group, String version, String plural, String name) {
        return Single.create(emitter -> this.client.getClusterCustomObjectScaleAsync(group, version, plural, name, new ApiCallbackEmitter(emitter)));
    }

    public Single<Object> getClusterCustomObjectStatus(String group, String version, String plural, String name) {
        return Single.create(emitter -> this.client.getClusterCustomObjectStatusAsync(group, version, plural, name, new ApiCallbackEmitter(emitter)));
    }

    public Single<Object> getNamespacedCustomObject(String group, String version, String namespace, String plural, String name) {
        return Single.create(emitter -> this.client.getNamespacedCustomObjectAsync(group, version, namespace, plural, name, new ApiCallbackEmitter(emitter)));
    }

    public Single<Object> getNamespacedCustomObjectScale(String group, String version, String namespace, String plural, String name) {
        return Single.create(emitter -> this.client.getNamespacedCustomObjectScaleAsync(group, version, namespace, plural, name, new ApiCallbackEmitter(emitter)));
    }

    public Single<Object> getNamespacedCustomObjectStatus(String group, String version, String namespace, String plural, String name) {
        return Single.create(emitter -> this.client.getNamespacedCustomObjectStatusAsync(group, version, namespace, plural, name, new ApiCallbackEmitter(emitter)));
    }

    public Single<Object> listClusterCustomObject(String group, String version, String plural, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Single.create(emitter -> this.client.listClusterCustomObjectAsync(group, version, plural, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new ApiCallbackEmitter(emitter)));
    }

    public Single<Object> listNamespacedCustomObject(String group, String version, String namespace, String plural, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Single.create(emitter -> this.client.listNamespacedCustomObjectAsync(group, version, namespace, plural, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new ApiCallbackEmitter(emitter)));
    }

    public Single<Object> patchClusterCustomObject(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager, Boolean force) {
        return Single.create(emitter -> this.client.patchClusterCustomObjectAsync(group, version, plural, name, body, dryRun, fieldManager, force, new ApiCallbackEmitter(emitter)));
    }

    public Single<Object> patchClusterCustomObjectScale(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager, Boolean force) {
        return Single.create(emitter -> this.client.patchClusterCustomObjectScaleAsync(group, version, plural, name, body, dryRun, fieldManager, force, new ApiCallbackEmitter(emitter)));
    }

    public Single<Object> patchClusterCustomObjectStatus(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager, Boolean force) {
        return Single.create(emitter -> this.client.patchClusterCustomObjectStatusAsync(group, version, plural, name, body, dryRun, fieldManager, force, new ApiCallbackEmitter(emitter)));
    }

    public Single<Object> patchNamespacedCustomObject(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager, Boolean force) {
        return Single.create(emitter -> this.client.patchNamespacedCustomObjectAsync(group, version, namespace, plural, name, body, dryRun, fieldManager, force, new ApiCallbackEmitter(emitter)));
    }

    public Single<Object> patchNamespacedCustomObjectScale(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager, Boolean force) {
        return Single.create(emitter -> this.client.patchNamespacedCustomObjectScaleAsync(group, version, namespace, plural, name, body, dryRun, fieldManager, force, new ApiCallbackEmitter(emitter)));
    }

    public Single<Object> patchNamespacedCustomObjectStatus(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager, Boolean force) {
        return Single.create(emitter -> this.client.patchNamespacedCustomObjectStatusAsync(group, version, namespace, plural, name, body, dryRun, fieldManager, force, new ApiCallbackEmitter(emitter)));
    }

    public Single<Object> replaceClusterCustomObject(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager) {
        return Single.create(emitter -> this.client.replaceClusterCustomObjectAsync(group, version, plural, name, body, dryRun, fieldManager, new ApiCallbackEmitter(emitter)));
    }

    public Single<Object> replaceClusterCustomObjectScale(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager) {
        return Single.create(emitter -> this.client.replaceClusterCustomObjectScaleAsync(group, version, plural, name, body, dryRun, fieldManager, new ApiCallbackEmitter(emitter)));
    }

    public Single<Object> replaceClusterCustomObjectStatus(String group, String version, String plural, String name, Object body, String dryRun, String fieldManager) {
        return Single.create(emitter -> this.client.replaceClusterCustomObjectStatusAsync(group, version, plural, name, body, dryRun, fieldManager, new ApiCallbackEmitter(emitter)));
    }

    public Single<Object> replaceNamespacedCustomObject(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager) {
        return Single.create(emitter -> this.client.replaceNamespacedCustomObjectAsync(group, version, namespace, plural, name, body, dryRun, fieldManager, new ApiCallbackEmitter(emitter)));
    }

    public Single<Object> replaceNamespacedCustomObjectScale(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager) {
        return Single.create(emitter -> this.client.replaceNamespacedCustomObjectScaleAsync(group, version, namespace, plural, name, body, dryRun, fieldManager, new ApiCallbackEmitter(emitter)));
    }

    public Single<Object> replaceNamespacedCustomObjectStatus(String group, String version, String namespace, String plural, String name, Object body, String dryRun, String fieldManager) {
        return Single.create(emitter -> this.client.replaceNamespacedCustomObjectStatusAsync(group, version, namespace, plural, name, body, dryRun, fieldManager, new ApiCallbackEmitter(emitter)));
    }
}

