/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.rxjava3;

import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.openapi.apis.InternalApiserverV1alpha1Api;
import io.kubernetes.client.openapi.models.V1APIResourceList;
import io.kubernetes.client.openapi.models.V1DeleteOptions;
import io.kubernetes.client.openapi.models.V1Status;
import io.kubernetes.client.openapi.models.V1alpha1StorageVersion;
import io.kubernetes.client.openapi.models.V1alpha1StorageVersionList;
import io.micronaut.context.annotation.Requires;
import io.micronaut.kubernetes.client.rxjava3.ApiCallbackEmitter;
import io.reactivex.rxjava3.core.Single;
import jakarta.inject.Singleton;

@Requires(beans={InternalApiserverV1alpha1Api.class})
@Singleton
public class InternalApiserverV1alpha1ApiRxClient {
    private final InternalApiserverV1alpha1Api client;

    InternalApiserverV1alpha1ApiRxClient(InternalApiserverV1alpha1Api client) {
        this.client = client;
    }

    public Single<V1alpha1StorageVersion> createStorageVersion(V1alpha1StorageVersion body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Single.create(emitter -> this.client.createStorageVersionAsync(body, pretty, dryRun, fieldManager, fieldValidation, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1Status> deleteCollectionStorageVersion(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, V1DeleteOptions body) {
        return Single.create(emitter -> this.client.deleteCollectionStorageVersionAsync(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, timeoutSeconds, body, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1Status> deleteStorageVersion(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) {
        return Single.create(emitter -> this.client.deleteStorageVersionAsync(name, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1APIResourceList> getAPIResources() {
        return Single.create(emitter -> this.client.getAPIResourcesAsync(new ApiCallbackEmitter(emitter)));
    }

    public Single<V1alpha1StorageVersionList> listStorageVersion(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Single.create(emitter -> this.client.listStorageVersionAsync(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1alpha1StorageVersion> patchStorageVersion(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) {
        return Single.create(emitter -> this.client.patchStorageVersionAsync(name, body, pretty, dryRun, fieldManager, fieldValidation, force, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1alpha1StorageVersion> patchStorageVersionStatus(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) {
        return Single.create(emitter -> this.client.patchStorageVersionStatusAsync(name, body, pretty, dryRun, fieldManager, fieldValidation, force, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1alpha1StorageVersion> readStorageVersion(String name, String pretty) {
        return Single.create(emitter -> this.client.readStorageVersionAsync(name, pretty, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1alpha1StorageVersion> readStorageVersionStatus(String name, String pretty) {
        return Single.create(emitter -> this.client.readStorageVersionStatusAsync(name, pretty, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1alpha1StorageVersion> replaceStorageVersion(String name, V1alpha1StorageVersion body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Single.create(emitter -> this.client.replaceStorageVersionAsync(name, body, pretty, dryRun, fieldManager, fieldValidation, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1alpha1StorageVersion> replaceStorageVersionStatus(String name, V1alpha1StorageVersion body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Single.create(emitter -> this.client.replaceStorageVersionStatusAsync(name, body, pretty, dryRun, fieldManager, fieldValidation, new ApiCallbackEmitter(emitter)));
    }
}

