/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.rxjava3;

import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.openapi.apis.NetworkingV1Api;
import io.kubernetes.client.openapi.models.V1APIResourceList;
import io.kubernetes.client.openapi.models.V1DeleteOptions;
import io.kubernetes.client.openapi.models.V1Ingress;
import io.kubernetes.client.openapi.models.V1IngressClass;
import io.kubernetes.client.openapi.models.V1IngressClassList;
import io.kubernetes.client.openapi.models.V1IngressList;
import io.kubernetes.client.openapi.models.V1NetworkPolicy;
import io.kubernetes.client.openapi.models.V1NetworkPolicyList;
import io.kubernetes.client.openapi.models.V1Status;
import io.micronaut.context.annotation.Requires;
import io.micronaut.kubernetes.client.rxjava3.ApiCallbackEmitter;
import io.reactivex.rxjava3.core.Single;
import jakarta.inject.Singleton;

@Requires(beans={NetworkingV1Api.class})
@Singleton
public class NetworkingV1ApiRxClient {
    private final NetworkingV1Api client;

    NetworkingV1ApiRxClient(NetworkingV1Api client) {
        this.client = client;
    }

    public Single<V1IngressClass> createIngressClass(V1IngressClass body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Single.create(emitter -> this.client.createIngressClassAsync(body, pretty, dryRun, fieldManager, fieldValidation, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1Ingress> createNamespacedIngress(String namespace, V1Ingress body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Single.create(emitter -> this.client.createNamespacedIngressAsync(namespace, body, pretty, dryRun, fieldManager, fieldValidation, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1NetworkPolicy> createNamespacedNetworkPolicy(String namespace, V1NetworkPolicy body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Single.create(emitter -> this.client.createNamespacedNetworkPolicyAsync(namespace, body, pretty, dryRun, fieldManager, fieldValidation, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1Status> deleteCollectionIngressClass(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, V1DeleteOptions body) {
        return Single.create(emitter -> this.client.deleteCollectionIngressClassAsync(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, timeoutSeconds, body, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1Status> deleteCollectionNamespacedIngress(String namespace, String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, V1DeleteOptions body) {
        return Single.create(emitter -> this.client.deleteCollectionNamespacedIngressAsync(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, timeoutSeconds, body, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1Status> deleteCollectionNamespacedNetworkPolicy(String namespace, String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, V1DeleteOptions body) {
        return Single.create(emitter -> this.client.deleteCollectionNamespacedNetworkPolicyAsync(namespace, pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, timeoutSeconds, body, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1Status> deleteIngressClass(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) {
        return Single.create(emitter -> this.client.deleteIngressClassAsync(name, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1Status> deleteNamespacedIngress(String name, String namespace, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) {
        return Single.create(emitter -> this.client.deleteNamespacedIngressAsync(name, namespace, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1Status> deleteNamespacedNetworkPolicy(String name, String namespace, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) {
        return Single.create(emitter -> this.client.deleteNamespacedNetworkPolicyAsync(name, namespace, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1APIResourceList> getAPIResources() {
        return Single.create(emitter -> this.client.getAPIResourcesAsync(new ApiCallbackEmitter(emitter)));
    }

    public Single<V1IngressClassList> listIngressClass(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Single.create(emitter -> this.client.listIngressClassAsync(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1IngressList> listIngressForAllNamespaces(Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String pretty, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Single.create(emitter -> this.client.listIngressForAllNamespacesAsync(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1IngressList> listNamespacedIngress(String namespace, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Single.create(emitter -> this.client.listNamespacedIngressAsync(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1NetworkPolicyList> listNamespacedNetworkPolicy(String namespace, String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Single.create(emitter -> this.client.listNamespacedNetworkPolicyAsync(namespace, pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1NetworkPolicyList> listNetworkPolicyForAllNamespaces(Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String pretty, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Single.create(emitter -> this.client.listNetworkPolicyForAllNamespacesAsync(allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, pretty, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1IngressClass> patchIngressClass(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) {
        return Single.create(emitter -> this.client.patchIngressClassAsync(name, body, pretty, dryRun, fieldManager, fieldValidation, force, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1Ingress> patchNamespacedIngress(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) {
        return Single.create(emitter -> this.client.patchNamespacedIngressAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1Ingress> patchNamespacedIngressStatus(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) {
        return Single.create(emitter -> this.client.patchNamespacedIngressStatusAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1NetworkPolicy> patchNamespacedNetworkPolicy(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) {
        return Single.create(emitter -> this.client.patchNamespacedNetworkPolicyAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1NetworkPolicy> patchNamespacedNetworkPolicyStatus(String name, String namespace, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) {
        return Single.create(emitter -> this.client.patchNamespacedNetworkPolicyStatusAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, force, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1IngressClass> readIngressClass(String name, String pretty) {
        return Single.create(emitter -> this.client.readIngressClassAsync(name, pretty, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1Ingress> readNamespacedIngress(String name, String namespace, String pretty) {
        return Single.create(emitter -> this.client.readNamespacedIngressAsync(name, namespace, pretty, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1Ingress> readNamespacedIngressStatus(String name, String namespace, String pretty) {
        return Single.create(emitter -> this.client.readNamespacedIngressStatusAsync(name, namespace, pretty, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1NetworkPolicy> readNamespacedNetworkPolicy(String name, String namespace, String pretty) {
        return Single.create(emitter -> this.client.readNamespacedNetworkPolicyAsync(name, namespace, pretty, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1NetworkPolicy> readNamespacedNetworkPolicyStatus(String name, String namespace, String pretty) {
        return Single.create(emitter -> this.client.readNamespacedNetworkPolicyStatusAsync(name, namespace, pretty, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1IngressClass> replaceIngressClass(String name, V1IngressClass body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Single.create(emitter -> this.client.replaceIngressClassAsync(name, body, pretty, dryRun, fieldManager, fieldValidation, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1Ingress> replaceNamespacedIngress(String name, String namespace, V1Ingress body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Single.create(emitter -> this.client.replaceNamespacedIngressAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1Ingress> replaceNamespacedIngressStatus(String name, String namespace, V1Ingress body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Single.create(emitter -> this.client.replaceNamespacedIngressStatusAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1NetworkPolicy> replaceNamespacedNetworkPolicy(String name, String namespace, V1NetworkPolicy body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Single.create(emitter -> this.client.replaceNamespacedNetworkPolicyAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1NetworkPolicy> replaceNamespacedNetworkPolicyStatus(String name, String namespace, V1NetworkPolicy body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Single.create(emitter -> this.client.replaceNamespacedNetworkPolicyStatusAsync(name, namespace, body, pretty, dryRun, fieldManager, fieldValidation, new ApiCallbackEmitter(emitter)));
    }
}

