/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.rxjava3;

import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.openapi.apis.NodeV1Api;
import io.kubernetes.client.openapi.models.V1APIResourceList;
import io.kubernetes.client.openapi.models.V1DeleteOptions;
import io.kubernetes.client.openapi.models.V1RuntimeClass;
import io.kubernetes.client.openapi.models.V1RuntimeClassList;
import io.kubernetes.client.openapi.models.V1Status;
import io.micronaut.context.annotation.Requires;
import io.micronaut.kubernetes.client.rxjava3.ApiCallbackEmitter;
import io.reactivex.rxjava3.core.Single;
import jakarta.inject.Singleton;

@Requires(beans={NodeV1Api.class})
@Singleton
public class NodeV1ApiRxClient {
    private final NodeV1Api client;

    NodeV1ApiRxClient(NodeV1Api client) {
        this.client = client;
    }

    public Single<V1RuntimeClass> createRuntimeClass(V1RuntimeClass body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Single.create(emitter -> this.client.createRuntimeClassAsync(body, pretty, dryRun, fieldManager, fieldValidation, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1Status> deleteCollectionRuntimeClass(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds, V1DeleteOptions body) {
        return Single.create(emitter -> this.client.deleteCollectionRuntimeClassAsync(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, timeoutSeconds, body, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1Status> deleteRuntimeClass(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) {
        return Single.create(emitter -> this.client.deleteRuntimeClassAsync(name, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1APIResourceList> getAPIResources() {
        return Single.create(emitter -> this.client.getAPIResourcesAsync(new ApiCallbackEmitter(emitter)));
    }

    public Single<V1RuntimeClassList> listRuntimeClass(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Integer timeoutSeconds) {
        return Single.create(emitter -> this.client.listRuntimeClassAsync(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, timeoutSeconds, Boolean.FALSE, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1RuntimeClass> patchRuntimeClass(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) {
        return Single.create(emitter -> this.client.patchRuntimeClassAsync(name, body, pretty, dryRun, fieldManager, fieldValidation, force, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1RuntimeClass> readRuntimeClass(String name, String pretty) {
        return Single.create(emitter -> this.client.readRuntimeClassAsync(name, pretty, new ApiCallbackEmitter(emitter)));
    }

    public Single<V1RuntimeClass> replaceRuntimeClass(String name, V1RuntimeClass body, String pretty, String dryRun, String fieldManager, String fieldValidation) {
        return Single.create(emitter -> this.client.replaceRuntimeClassAsync(name, body, pretty, dryRun, fieldManager, fieldValidation, new ApiCallbackEmitter(emitter)));
    }
}

