/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.kubernetes.client.ApiClientConfiguration;
import io.micronaut.kubernetes.client.NamespaceResolver;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@BootstrapContextCompatible
public class DefaultNamespaceResolver
implements NamespaceResolver {
    public static final String DEFAULT_NAMESPACE = "default";
    public static final String NAMESPACE_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/namespace";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultNamespaceResolver.class);
    private final String namespace;

    public DefaultNamespaceResolver(ApiClientConfiguration apiClientConfiguration) {
        String resolvedNamespace = apiClientConfiguration.getNamespace().orElse(null);
        if (resolvedNamespace == null) {
            try {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Namespace has not been set. Reading it from file [{}]", (Object)NAMESPACE_PATH);
                }
                resolvedNamespace = new String(Files.readAllBytes(Paths.get(NAMESPACE_PATH, new String[0])), StandardCharsets.UTF_8);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Namespace: [{}]", (Object)resolvedNamespace);
                }
            }
            catch (IOException ioe) {
                LOG.warn("An error has occurred when reading the file: [{}]. Kubernetes namespace will be set to: {}", (Object)NAMESPACE_PATH, (Object)DEFAULT_NAMESPACE);
                resolvedNamespace = DEFAULT_NAMESPACE;
            }
        }
        this.namespace = resolvedNamespace;
    }

    @Override
    public String resolveNamespace() {
        return this.namespace;
    }
}

