/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client;

import java.io.IOException;
import okhttp3.Connection;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpClientLogging
implements Interceptor {
    private static final Logger LOG = LoggerFactory.getLogger(OkHttpClientLogging.class);

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Response response;
        block13: {
            Request request = chain.request();
            Connection connection = chain.connection();
            if (LOG.isTraceEnabled()) {
                try {
                    String method = request.method();
                    RequestBody requestBody = request.body();
                    Headers headers = request.headers();
                    LOG.trace("--> {} {} {} {}-byte body", new Object[]{method, request.url(), connection != null ? connection.protocol() : "", requestBody != null ? Long.valueOf(requestBody.contentLength()) : "0"});
                    for (int i = 0; i < headers.size(); ++i) {
                        LOG.trace("{}: {}", (Object)headers.name(i), (Object)headers.value(i));
                    }
                }
                catch (Exception e) {
                    LOG.warn("Failed to generate OkHttpClient request log: " + e.getMessage(), (Throwable)e);
                }
            }
            response = null;
            try {
                response = chain.proceed(request);
            }
            catch (Exception e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("HTTP FAILED: " + e.getMessage(), (Throwable)e);
                }
                throw e;
            }
            if (LOG.isDebugEnabled()) {
                try {
                    ResponseBody responseBody = response.body();
                    long contentLength = responseBody.contentLength();
                    String contentLengthString = contentLength == -1L ? "unknown-length" : String.format("%s-byte", contentLength);
                    Headers headers = response.headers();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("<-- {} {} {} {}", new Object[]{response.code(), response.message(), response.request().url(), contentLengthString});
                        for (int i = 0; i < headers.size(); ++i) {
                            LOG.trace("{}: {}", (Object)headers.name(i), (Object)headers.value(i));
                        }
                    } else {
                        String method = request.method();
                        RequestBody requestBody = request.body();
                        LOG.debug("KubeApi {} {} {} OUT<{}-byte> IN <{}> {}", new Object[]{method, request.url(), connection != null ? connection.protocol() : "", requestBody != null ? Long.valueOf(requestBody.contentLength()) : "0", contentLengthString, response.code()});
                    }
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) break block13;
                    LOG.warn("Failed to generate OkHttpClient Response log: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return response;
    }
}

